/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.internal.ui.navigator.ContainerFolder;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerProblemsDecorator;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class PackageExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    private PackageExplorerContentProvider fContentProvider;
    private Map fWorkingSetImages;
    private boolean fIsFlatLayout;
    private PackageExplorerProblemsDecorator fProblemDecorator = new PackageExplorerProblemsDecorator();

    public PackageExplorerLabelProvider(PackageExplorerContentProvider packageExplorerContentProvider) {
        super(0x212000200029L | JavaElementLabels.ALL_CATEGORY, 3);
        this.addLabelDecorator(this.fProblemDecorator);
        Assert.isNotNull((Object)packageExplorerContentProvider);
        this.fContentProvider = packageExplorerContentProvider;
        this.fWorkingSetImages = null;
    }

    public ColoredString getRichTextLabel(Object object) {
        String string = this.getSpecificText(object);
        if (string != null) {
            return new ColoredString(this.decorateText(string, object));
        }
        return super.getRichTextLabel(object);
    }

    private String getSpecificText(Object object) {
        if (!this.fIsFlatLayout && object instanceof IPackageFragment) {
            IPackageFragment iPackageFragment = (IPackageFragment)object;
            Object object2 = this.fContentProvider.getHierarchicalPackageParent(iPackageFragment);
            if (object2 instanceof IPackageFragment) {
                return this.getNameDelta((IPackageFragment)object2, iPackageFragment);
            }
            if (object2 instanceof IFolder) {
                return this.getNameDelta((IFolder)object2, iPackageFragment);
            }
        } else if (object instanceof IWorkingSet) {
            return ((IWorkingSet)object).getLabel();
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof ContainerFolder) {
            return ((ContainerFolder)object).toString();
        }
        String string = this.getSpecificText(object);
        if (string != null) {
            return this.decorateText(string, object);
        }
        string = super.getText(object);
        if (object instanceof IClassFile) {
            string = ((IClassFile)object).getPath().lastSegment();
        } else if (object instanceof ICompilationUnit) {
            string = ((ICompilationUnit)object).getPath().lastSegment();
        }
        return string;
    }

    private String getNameDelta(IPackageFragment iPackageFragment, IPackageFragment iPackageFragment2) {
        String string = String.valueOf(iPackageFragment.getElementName()) + '/';
        String string2 = iPackageFragment2.getElementName();
        if (string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return string2;
    }

    private String getNameDelta(IFolder iFolder, IPackageFragment iPackageFragment) {
        IPath iPath;
        IPath iPath2 = iFolder.getFullPath();
        if (iPath2.isPrefixOf(iPath = iPackageFragment.getPath())) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = iPath2.segmentCount();
            while (n < iPath.segmentCount()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(iPath.segment(n));
                ++n;
            }
            return stringBuffer.toString();
        }
        return iPackageFragment.getElementName();
    }

    public Image getImage(Object object) {
        if (object instanceof ContainerFolder) {
            return super.getImage(((ContainerFolder)object).getParentObject());
        }
        if (object instanceof IWorkingSet) {
            Image image;
            ImageDescriptor imageDescriptor = ((IWorkingSet)object).getImageDescriptor();
            if (this.fWorkingSetImages == null) {
                this.fWorkingSetImages = new HashMap();
            }
            if ((image = (Image)this.fWorkingSetImages.get(imageDescriptor)) == null) {
                image = imageDescriptor.createImage();
                this.fWorkingSetImages.put(imageDescriptor, image);
            }
            return this.decorateImage(image, object);
        }
        return super.getImage(object);
    }

    public void setIsFlatLayout(boolean bl) {
        this.fIsFlatLayout = bl;
        this.fProblemDecorator.setIsFlatLayout(bl);
    }

    public void dispose() {
        if (this.fWorkingSetImages != null) {
            Iterator iterator = this.fWorkingSetImages.values().iterator();
            while (iterator.hasNext()) {
                ((Image)iterator.next()).dispose();
            }
        }
        super.dispose();
    }
}

