/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.preferences.CodeTemplateSourceViewerConfiguration;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

class EditTemplateDialog
extends StatusDialog {
    private Template fTemplate;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fContextCombo;
    private SourceViewer fPatternEditor;
    private Button fInsertVariableButton;
    private Button fAutoInsertCheckbox;
    private boolean fIsNameModifiable;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private String[][] fContextTypes;
    private ContextTypeRegistry fContextTypeRegistry;
    private final TemplateVariableProcessor fTemplateProcessor = new TemplateVariableProcessor();

    public EditTemplateDialog(Shell shell, Template template, boolean bl, boolean bl2, ContextTypeRegistry contextTypeRegistry) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String string = bl ? PreferencesMessages.EditTemplateDialog_title_edit : PreferencesMessages.EditTemplateDialog_title_new;
        this.setTitle(string);
        this.fTemplate = template;
        this.fIsNameModifiable = bl2;
        String string2 = new Document().getLegalLineDelimiters()[0];
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Iterator iterator = contextTypeRegistry.contextTypes();
        while (iterator.hasNext()) {
            TemplateContextType templateContextType = (TemplateContextType)iterator.next();
            if (templateContextType.getId().equals("javadoc")) {
                arrayList.add(new String[]{templateContextType.getId(), templateContextType.getName(), "/**" + string2});
                continue;
            }
            arrayList.add(0, new String[]{templateContextType.getId(), templateContextType.getName(), ""});
        }
        this.fContextTypes = (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
        this.fValidationStatus = new StatusInfo();
        this.fContextTypeRegistry = contextTypeRegistry;
        iterator = this.fContextTypeRegistry.getContextType(template.getContextTypeId());
        this.fTemplateProcessor.setContextType((TemplateContextType)iterator);
    }

    public void create() {
        super.create();
        this.updateStatusAndButtons();
        boolean bl = this.fNameText != null && this.fNameText.getText().length() == 0;
        this.getButton(0).setEnabled(!bl);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditTemplateDialog.this.doTextWidgetChanged(modifyEvent.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditTemplateDialog.createLabel(composite2, PreferencesMessages.EditTemplateDialog_name);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayoutData((Object)new GridData(768));
            gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite3.setLayout((Layout)gridLayout);
            this.fNameText = EditTemplateDialog.createText(composite3);
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (EditTemplateDialog.this.fSuppressError) {
                        EditTemplateDialog.this.fSuppressError = false;
                        EditTemplateDialog.this.updateStatusAndButtons();
                    }
                }
            });
            EditTemplateDialog.createLabel(composite3, PreferencesMessages.EditTemplateDialog_context);
            this.fContextCombo = new Combo(composite3, 8);
            int n = 0;
            while (n < this.fContextTypes.length) {
                this.fContextCombo.add(this.fContextTypes[n][1]);
                ++n;
            }
            this.fContextCombo.addModifyListener(modifyListener);
            this.fAutoInsertCheckbox = EditTemplateDialog.createCheckbox(composite3, PreferencesMessages.EditTemplateDialog_autoinsert);
            this.fAutoInsertCheckbox.setSelection(this.fTemplate.isAutoInsertable());
        }
        EditTemplateDialog.createLabel(composite2, PreferencesMessages.EditTemplateDialog_description);
        int n = this.fIsNameModifiable ? 2048 : 2056;
        this.fDescriptionText = new Text(composite2, n);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        this.fDescriptionText.addModifyListener(modifyListener);
        Label label = EditTemplateDialog.createLabel(composite2, PreferencesMessages.EditTemplateDialog_pattern);
        label.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(composite2);
        Label label2 = new Label(composite2, 0);
        label2.setLayoutData((Object)new GridData());
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite4, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData(this.fInsertVariableButton));
        this.fInsertVariableButton.setText(PreferencesMessages.EditTemplateDialog_insert_variable);
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fDescriptionText.setText(this.fTemplate.getDescription());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fTemplate.getName());
            this.fNameText.addModifyListener(modifyListener);
            this.fContextCombo.select(this.getIndex(this.fTemplate.getContextTypeId()));
        } else {
            this.fPatternEditor.getControl().setFocus();
        }
        this.initializeActions();
        EditTemplateDialog.applyDialogFont((Control)composite2);
        return composite4;
    }

    protected void doTextWidgetChanged(Widget widget) {
        if (widget == this.fNameText) {
            this.fSuppressError = false;
            this.updateStatusAndButtons();
        } else if (widget == this.fContextCombo) {
            String string = this.getContextId();
            this.fTemplateProcessor.setContextType(this.fContextTypeRegistry.getContextType(string));
            IDocument iDocument = this.fPatternEditor.getDocument();
            String string2 = this.getPrefix();
            iDocument.set(String.valueOf(string2) + this.getPattern());
            this.fPatternEditor.setVisibleRegion(string2.length(), iDocument.getLength() - string2.length());
        }
    }

    private String getContextId() {
        if (this.fContextCombo != null && !this.fContextCombo.isDisposed()) {
            String string = this.fContextCombo.getText();
            int n = 0;
            while (n < this.fContextTypes.length) {
                if (string.equals(this.fContextTypes[n][1])) {
                    return this.fContextTypes[n][0];
                }
                ++n;
            }
        }
        return this.fTemplate.getContextTypeId();
    }

    protected void doSourceChanged(IDocument iDocument) {
        String string = iDocument.get();
        this.fValidationStatus.setOK();
        TemplateContextType templateContextType = this.fContextTypeRegistry.getContextType(this.getContextId());
        if (templateContextType != null) {
            try {
                templateContextType.validate(string);
            }
            catch (TemplateException templateException) {
                this.fValidationStatus.setError(templateException.getLocalizedMessage());
            }
        }
        this.updateUndoAction();
        this.updateStatusAndButtons();
    }

    private static GridData getButtonGridData(Button button) {
        GridData gridData = new GridData(768);
        return gridData;
    }

    private static Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Button createCheckbox(Composite composite, String string) {
        Button button = new Button(composite, 32);
        button.setText(string);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    private static Text createText(Composite composite) {
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite composite) {
        String string = this.getPrefix();
        Document document = new Document(String.valueOf(string) + this.fTemplate.getPattern());
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        javaTextTools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer javaSourceViewer = new JavaSourceViewer(composite, null, null, false, 2816, iPreferenceStore);
        CodeTemplateSourceViewerConfiguration codeTemplateSourceViewerConfiguration = new CodeTemplateSourceViewerConfiguration(javaTextTools.getColorManager(), iPreferenceStore, null, this.fTemplateProcessor);
        javaSourceViewer.configure((SourceViewerConfiguration)codeTemplateSourceViewerConfiguration);
        javaSourceViewer.setEditable(true);
        javaSourceViewer.setDocument((IDocument)document, string.length(), document.getLength() - string.length());
        Font font = JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont");
        javaSourceViewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)javaSourceViewer, codeTemplateSourceViewerConfiguration, iPreferenceStore);
        int n = document.getNumberOfLines();
        if (n < 5) {
            n = 5;
        } else if (n > 12) {
            n = 12;
        }
        Control control = javaSourceViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(n);
        control.setLayoutData((Object)gridData);
        javaSourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent textEvent) {
                if (textEvent.getDocumentEvent() != null) {
                    EditTemplateDialog.this.doSourceChanged(textEvent.getDocumentEvent().getDocument());
                }
            }
        });
        javaSourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        javaSourceViewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                EditTemplateDialog.this.handleVerifyKeyPressed(verifyEvent);
            }
        });
        return javaSourceViewer;
    }

    private String getPrefix() {
        String string = this.getContextId();
        int n = this.getIndex(string);
        if (n != -1) {
            return this.fContextTypes[n][2];
        }
        return "";
    }

    private void handleVerifyKeyPressed(VerifyEvent verifyEvent) {
        if (!verifyEvent.doit) {
            return;
        }
        if (verifyEvent.stateMask != SWT.MOD1) {
            return;
        }
        switch (verifyEvent.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                verifyEvent.doit = false;
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
                verifyEvent.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        textViewerAction.setText(PreferencesMessages.EditTemplateDialog_undo);
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        textViewerAction.setText(PreferencesMessages.EditTemplateDialog_cut);
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        textViewerAction.setText(PreferencesMessages.EditTemplateDialog_copy);
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        textViewerAction.setText(PreferencesMessages.EditTemplateDialog_paste);
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        textViewerAction.setText(PreferencesMessages.EditTemplateDialog_select_all);
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        textViewerAction.setText(PreferencesMessages.EditTemplateDialog_content_assist);
        this.fGlobalActions.put("ContentAssistProposal", textViewerAction);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager menuManager = new MenuManager(null, null);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                EditTemplateDialog.this.fillContextMenu(iMenuManager);
            }
        });
        StyledText styledText = this.fPatternEditor.getTextWidget();
        Menu menu = menuManager.createContextMenu((Control)styledText);
        styledText.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new GroupMarker("group.undo"));
        iMenuManager.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        iMenuManager.add((IContributionItem)new Separator("group.edit"));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        iMenuManager.add((IContributionItem)new Separator("group.generate"));
        iMenuManager.appendToGroup("group.generate", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateUndoAction() {
        IAction iAction = (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    protected void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    private int getIndex(String string) {
        if (string == null) {
            return -1;
        }
        int n = 0;
        while (n < this.fContextTypes.length) {
            if (string.equals(this.fContextTypes[n][0])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void okPressed() {
        String string = this.fNameText == null ? this.fTemplate.getName() : this.fNameText.getText();
        boolean bl = this.fAutoInsertCheckbox != null && this.fAutoInsertCheckbox.getSelection();
        this.fTemplate = new Template(string, this.fDescriptionText.getText(), this.getContextId(), this.getPattern(), bl);
        super.okPressed();
    }

    private void updateStatusAndButtons() {
        boolean bl;
        StatusInfo statusInfo = this.fValidationStatus;
        boolean bl2 = bl = this.fNameText != null && this.fNameText.getText().length() == 0;
        if (!this.fSuppressError && bl) {
            statusInfo = new StatusInfo();
            statusInfo.setError(PreferencesMessages.EditTemplateDialog_error_noname);
        } else if (this.fNameText != null && this.fNameText.getText().indexOf(32) > -1) {
            statusInfo = new StatusInfo();
            statusInfo.setError(PreferencesMessages.EditTemplateDialog_error_spaces);
        }
        this.updateStatus(statusInfo);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.edit_template_dialog_context");
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    private String getPattern() {
        IDocument iDocument = this.fPatternEditor.getDocument();
        IRegion iRegion = this.fPatternEditor.getVisibleRegion();
        try {
            return iDocument.get(iRegion.getOffset(), iDocument.getLength() - iRegion.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String string = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer iTextViewer, int n) {
            this.fOperationCode = n;
            this.fOperationTarget = iTextViewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean bl = this.isEnabled();
            boolean bl2 = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(bl2);
            if (bl != bl2) {
                this.firePropertyChange("enabled", bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

