/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavadocConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class JavadocConfigurationPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.eclipse.wst.jsdt.ui.propertyPages.JavadocConfigurationPropertyPage";
    private JavadocConfigurationBlock fJavadocConfigurationBlock;
    private boolean fIsValidElement;
    private IPath fContainerPath;
    private IClasspathEntry fEntry;
    private URL fInitalLocation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControl(Composite composite) {
        IJavaElement iJavaElement = this.getJavaElement();
        try {
            if (iJavaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)iJavaElement).getKind() == 2) {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
                if (iClasspathEntry == null) {
                    this.fIsValidElement = false;
                    this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
                } else if (iClasspathEntry.getEntryKind() == 5) {
                    this.fContainerPath = iClasspathEntry.getPath();
                    this.fEntry = this.handleContainerEntry(this.fContainerPath, iJavaElement.getJavaProject(), iPackageFragmentRoot.getPath());
                    this.fIsValidElement = this.fEntry != null;
                } else {
                    this.fContainerPath = null;
                    this.fEntry = iClasspathEntry;
                    this.fIsValidElement = true;
                    this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsPackageFragmentRoot_description);
                }
            } else if (iJavaElement instanceof IJavaProject) {
                this.fIsValidElement = true;
                this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsJavaProject_description);
            } else {
                this.fIsValidElement = false;
                this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
            }
        }
        catch (JavaModelException javaModelException) {
            this.fIsValidElement = false;
            this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
        }
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.javadoc_configuration_property_page_context");
    }

    private IClasspathEntry handleContainerEntry(IPath iPath, IJavaProject iJavaProject, IPath iPath2) throws JavaModelException {
        ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)iPath.segment(0));
        IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject);
        if (classpathContainerInitializer == null || iClasspathContainer == null) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_invalid_container, iPath.toString()));
            return null;
        }
        String string = iClasspathContainer.getDescription();
        IStatus iStatus = classpathContainerInitializer.getAttributeStatus(iPath, iJavaProject, "javadoc_location");
        if (iStatus.getCode() == 1) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_not_supported, string));
            return null;
        }
        if (iStatus.getCode() == 2) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_read_only, string));
            return null;
        }
        IClasspathEntry iClasspathEntry = JavaModelUtil.findEntryInContainer(iClasspathContainer, iPath2);
        Assert.isNotNull((Object)iClasspathEntry);
        this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsPackageFragmentRoot_description);
        return iClasspathEntry;
    }

    protected Control createContents(Composite composite) {
        if (!this.fIsValidElement) {
            return new Composite(composite, 0);
        }
        IJavaElement iJavaElement = this.getJavaElement();
        this.fInitalLocation = null;
        if (iJavaElement != null) {
            try {
                this.fInitalLocation = JavaUI.getJavadocBaseLocation(iJavaElement);
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        boolean bl = iJavaElement instanceof IJavaProject;
        this.fJavadocConfigurationBlock = new JavadocConfigurationBlock(this.getShell(), this, this.fInitalLocation, bl);
        Control control = this.fJavadocConfigurationBlock.createContents(composite);
        control.setVisible(iJavaElement != null);
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private IJavaElement getJavaElement() {
        IJavaElement iJavaElement;
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource iResource = (IResource)iAdaptable.getAdapter((Class)clazz2);
            try {
                IProject iProject;
                if (iResource instanceof IFile && ArchiveFileFilter.isArchivePath(iResource.getFullPath()) && (iProject = iResource.getProject()).hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                    IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                    iJavaElement = iJavaProject.getPackageFragmentRoot(iResource);
                }
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
        return iJavaElement;
    }

    protected void performDefaults() {
        if (this.fJavadocConfigurationBlock != null) {
            this.fJavadocConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fJavadocConfigurationBlock != null) {
            URL uRL = this.fJavadocConfigurationBlock.getJavadocLocation();
            if (uRL == null && this.fInitalLocation == null || uRL != null && uRL.equals(this.fInitalLocation)) {
                return true;
            }
            IJavaElement iJavaElement = this.getJavaElement();
            try {
                IRunnableWithProgress iRunnableWithProgress = JavadocConfigurationPropertyPage.getRunnable(this.getShell(), iJavaElement, uRL, this.fEntry, this.fContainerPath);
                PlatformUI.getWorkbench().getProgressService().run(true, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = PreferencesMessages.SourceAttachmentPropertyPage_error_title;
                String string2 = PreferencesMessages.SourceAttachmentPropertyPage_error_message;
                ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    private static IRunnableWithProgress getRunnable(final Shell shell, final IJavaElement iJavaElement, final URL uRL, final IClasspathEntry iClasspathEntry, final IPath iPath) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    IJavaProject iJavaProject = iJavaElement.getJavaProject();
                    if (iJavaElement instanceof IPackageFragmentRoot) {
                        CPListElement cPListElement = CPListElement.createFromExisting(iClasspathEntry, iJavaProject);
                        String string = uRL != null ? uRL.toExternalForm() : null;
                        cPListElement.setAttribute("javadoc_location", string);
                        IClasspathEntry iClasspathEntry2 = cPListElement.getClasspathEntry();
                        String[] stringArray = new String[]{"javadoc_location"};
                        BuildPathSupport.modifyClasspathEntry(shell, iClasspathEntry2, stringArray, iJavaProject, iPath, iProgressMonitor);
                    } else {
                        JavaUI.setProjectJavadocLocation(iJavaProject, uRL);
                    }
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
    }

    public void statusChanged(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }
}

