/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class NativeLibrariesConfigurationBlock {
    private StringDialogField fPathField;
    private SelectionButtonDialogField fBrowseWorkspace;
    private SelectionButtonDialogField fBrowseExternal;
    private final IClasspathEntry fEntry;
    private Shell fShell;
    private final IStatusChangeListener fListener;
    private final String fOrginalValue;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NativeLibrariesConfigurationBlock(IStatusChangeListener iStatusChangeListener, Shell shell, String string, IClasspathEntry iClasspathEntry) {
        this.fListener = iStatusChangeListener;
        this.fEntry = iClasspathEntry;
        NativeLibrariesAdapter nativeLibrariesAdapter = new NativeLibrariesAdapter();
        this.fPathField = new StringDialogField();
        this.fPathField.setLabelText(NewWizardMessages.NativeLibrariesDialog_location_label);
        this.fPathField.setDialogFieldListener(nativeLibrariesAdapter);
        this.fBrowseWorkspace = new SelectionButtonDialogField(8);
        this.fBrowseWorkspace.setLabelText(NewWizardMessages.NativeLibrariesDialog_workspace_browse);
        this.fBrowseWorkspace.setDialogFieldListener(nativeLibrariesAdapter);
        this.fBrowseExternal = new SelectionButtonDialogField(8);
        this.fBrowseExternal.setLabelText(NewWizardMessages.NativeLibrariesDialog_external_browse);
        this.fBrowseExternal.setDialogFieldListener(nativeLibrariesAdapter);
        if (string != null) {
            this.fPathField.setText(Path.fromPortableString((String)string).toString());
            this.fOrginalValue = string;
        } else {
            this.fOrginalValue = "";
        }
    }

    public Control createContents(Composite composite) {
        this.fShell = composite.getShell();
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        int n = 3;
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite2, 64);
        label.setFont(composite2.getFont());
        label.setText(Messages.format(NewWizardMessages.NativeLibrariesDialog_description, new String[]{this.fEntry.getPath().lastSegment()}));
        GridData gridData = new GridData(4, 2, false, false, 3, 1);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(80);
        label.setLayoutData((Object)gridData);
        this.fPathField.doFillIntoGrid(composite2, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fPathField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fPathField.getTextControl(null), pixelConverter.convertWidthInCharsToPixels(50));
        this.fBrowseExternal.doFillIntoGrid(composite2, 1);
        DialogField.createEmptySpace(composite2, 2);
        this.fBrowseWorkspace.doFillIntoGrid(composite2, 1);
        this.fPathField.setFocus();
        return composite;
    }

    public String getNativeLibraryPath() {
        String string = this.fPathField.getText();
        if (string.length() == 0) {
            return null;
        }
        return new Path(string).toPortableString();
    }

    final void doFieldChanged(DialogField dialogField) {
        if (dialogField == this.fBrowseExternal) {
            String string = this.chooseExternal();
            if (string != null) {
                this.fPathField.setText(string);
            }
        } else if (dialogField == this.fBrowseWorkspace) {
            String string = this.chooseInternal();
            if (string != null) {
                this.fPathField.setText(string);
            }
        } else if (dialogField == this.fPathField) {
            this.fListener.statusChanged(this.validatePath());
        }
    }

    private IStatus validatePath() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fPathField.getText();
        if (string.length() == 0) {
            return statusInfo;
        }
        Path path = new Path(string);
        if (path.isAbsolute()) {
            if (!path.toFile().isDirectory()) {
                statusInfo.setWarning(NewWizardMessages.NativeLibrariesDialog_error_external_not_existing);
                return statusInfo;
            }
        } else if (!(ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path) instanceof IContainer)) {
            statusInfo.setWarning(NewWizardMessages.NativeLibrariesDialog_error_internal_not_existing);
            return statusInfo;
        }
        return statusInfo;
    }

    private String chooseExternal() {
        Path path = new Path(this.fPathField.getText());
        path = path.isEmpty() ? this.fEntry.getPath() : path.removeLastSegments(1);
        DirectoryDialog directoryDialog = new DirectoryDialog(this.fShell);
        directoryDialog.setMessage(NewWizardMessages.NativeLibrariesDialog_external_message);
        directoryDialog.setText(NewWizardMessages.NativeLibrariesDialog_extfiledialog_text);
        directoryDialog.setFilterPath(path.toOSString());
        String string = directoryDialog.open();
        if (string != null) {
            return string;
        }
        return null;
    }

    private String chooseInternal() {
        String string = this.fPathField.getText();
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, true);
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2);
        IResource iResource = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (string.length() > 0) {
            iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
        }
        if (iResource == null) {
            iResource = iWorkspaceRoot.findMember(this.fEntry.getPath());
        }
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.fShell, (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setComparator((ViewerComparator)new ResourceComparator(1));
        elementTreeSelectionDialog.setTitle(NewWizardMessages.NativeLibrariesDialog_intfiledialog_title);
        elementTreeSelectionDialog.setMessage(NewWizardMessages.NativeLibrariesDialog_intfiledialog_message);
        elementTreeSelectionDialog.setInput((Object)iWorkspaceRoot);
        elementTreeSelectionDialog.setInitialSelection((Object)iResource);
        elementTreeSelectionDialog.setHelpAvailable(false);
        if (elementTreeSelectionDialog.open() == 0) {
            IResource iResource2 = (IResource)elementTreeSelectionDialog.getFirstResult();
            return iResource2.getFullPath().makeRelative().toString();
        }
        return null;
    }

    public void performDefaults() {
        this.fPathField.setText(this.fOrginalValue);
    }

    private class NativeLibrariesAdapter
    implements IDialogFieldListener {
        private NativeLibrariesAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NativeLibrariesConfigurationBlock.this.doFieldChanged(dialogField);
        }
    }
}

