/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathAttributeConfigurationDescriptors;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.wst.jsdt.ui.wizards.ClasspathAttributeConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserLibraryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.wst.jsdt.ui.preferences.UserLibraryPreferencePage";
    public static final String DATA_DO_CREATE = "do_create";
    public static final String DATA_LIBRARY_TO_SELECT = "select_library";
    private IDialogSettings fDialogSettings;
    private TreeListDialogField fLibraryList;
    private IJavaProject fDummyProject;
    private ClasspathAttributeConfigurationDescriptors fAttributeDescriptors;
    private static final int IDX_NEW = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_ADD = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_UP = 5;
    private static final int IDX_DOWN = 6;
    private static final int IDX_LOAD = 8;
    private static final int IDX_SAVE = 9;

    public UserLibraryPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fDummyProject = UserLibraryPreferencePage.createPlaceholderProject();
        this.fAttributeDescriptors = JavaPlugin.getDefault().getClasspathAttributeConfigurationDescriptors();
        this.setTitle(PreferencesMessages.UserLibraryPreferencePage_title);
        this.setDescription(PreferencesMessages.UserLibraryPreferencePage_description);
        this.noDefaultAndApplyButton();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        UserLibraryAdapter userLibraryAdapter = new UserLibraryAdapter();
        String[] stringArray = new String[10];
        stringArray[0] = PreferencesMessages.UserLibraryPreferencePage_libraries_new_button;
        stringArray[1] = PreferencesMessages.UserLibraryPreferencePage_libraries_edit_button;
        stringArray[2] = PreferencesMessages.UserLibraryPreferencePage_libraries_addjar_button;
        stringArray[3] = PreferencesMessages.UserLibraryPreferencePage_libraries_remove_button;
        stringArray[5] = PreferencesMessages.UserLibraryPreferencePage_UserLibraryPreferencePage_libraries_up_button;
        stringArray[6] = PreferencesMessages.UserLibraryPreferencePage_UserLibraryPreferencePage_libraries_down_button;
        stringArray[8] = PreferencesMessages.UserLibraryPreferencePage_libraries_load_button;
        stringArray[9] = PreferencesMessages.UserLibraryPreferencePage_libraries_save_button;
        String[] stringArray2 = stringArray;
        this.fLibraryList = new TreeListDialogField(userLibraryAdapter, stringArray2, (ILabelProvider)new CPListLabelProvider());
        this.fLibraryList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_libraries_label);
        String[] stringArray3 = JavaCore.getUserLibraryNames();
        ArrayList<CPUserLibraryElement> arrayList = new ArrayList<CPUserLibraryElement>();
        int n = 0;
        while (n < stringArray3.length) {
            IPath iPath = new Path("org.eclipse.wst.jsdt.USER_LIBRARY").append(stringArray3[n]);
            try {
                IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)this.fDummyProject);
                arrayList.add(new CPUserLibraryElement(stringArray3[n], iClasspathContainer, this.fDummyProject));
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            ++n;
        }
        this.fLibraryList.setElements(arrayList);
        this.fLibraryList.setViewerComparator(new CPListElementSorter());
        this.doSelectionChanged(this.fLibraryList);
    }

    private static IJavaProject createPlaceholderProject() {
        String string = "####internal";
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject;
        while ((iProject = iWorkspaceRoot.getProject(string)).exists()) {
            string = String.valueOf(string) + '1';
        }
        return JavaCore.create((IProject)iProject);
    }

    public void applyData(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            Object v = map.get(DATA_LIBRARY_TO_SELECT);
            boolean bl = Boolean.TRUE.equals(map.get(DATA_DO_CREATE));
            if (v instanceof String) {
                int n = this.fLibraryList.getSize();
                int n2 = 0;
                while (n2 < n) {
                    CPUserLibraryElement cPUserLibraryElement = (CPUserLibraryElement)this.fLibraryList.getElement(n2);
                    if (cPUserLibraryElement.getName().equals(v)) {
                        this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)cPUserLibraryElement));
                        this.fLibraryList.expandElement(cPUserLibraryElement, 1);
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    CPUserLibraryElement cPUserLibraryElement = new CPUserLibraryElement((String)v, null, UserLibraryPreferencePage.createPlaceholderProject());
                    this.fLibraryList.addElement(cPUserLibraryElement);
                    this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)cPUserLibraryElement));
                }
            }
        }
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.cp_userlibraries_preference_page_context");
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fLibraryList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fLibraryList.getTreeControl(null));
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    try {
                        try {
                            if (iProgressMonitor != null) {
                                iProgressMonitor = new NullProgressMonitor();
                            }
                            UserLibraryPreferencePage.this.updateUserLibararies(iProgressMonitor);
                        }
                        catch (CoreException coreException) {
                            throw new InvocationTargetException(coreException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = PreferencesMessages.UserLibraryPreferencePage_config_error_title;
            String string2 = PreferencesMessages.UserLibraryPreferencePage_config_error_message;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
        return true;
    }

    private void updateUserLibararies(IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath;
        Object object;
        CPUserLibraryElement cPUserLibraryElement;
        List list = this.fLibraryList.getElements();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(JavaCore.getUserLibraryNames()));
        int n = list.size();
        HashSet<CPUserLibraryElement> hashSet2 = new HashSet<CPUserLibraryElement>(list.size());
        int n2 = 0;
        while (n2 < n) {
            cPUserLibraryElement = (CPUserLibraryElement)list.get(n2);
            boolean bl = hashSet.remove(cPUserLibraryElement.getName());
            if (!bl) {
                hashSet2.add(cPUserLibraryElement);
            }
            ++n2;
        }
        n2 = n + hashSet.size();
        iProgressMonitor.beginTask(PreferencesMessages.UserLibraryPreferencePage_operation, n2);
        cPUserLibraryElement = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, PreferencesMessages.UserLibraryPreferencePage_operation_error, null);
        ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.wst.jsdt.USER_LIBRARY");
        IJavaProject iJavaProject = this.fDummyProject;
        int n3 = 0;
        while (n3 < n) {
            object = (CPUserLibraryElement)list.get(n3);
            iPath = ((CPUserLibraryElement)object).getPath();
            if (hashSet2.contains(object) || ((CPUserLibraryElement)object).hasChanges(JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject))) {
                IClasspathContainer iClasspathContainer = ((CPUserLibraryElement)object).getUpdatedContainer();
                try {
                    classpathContainerInitializer.requestClasspathContainerUpdate(iPath, iJavaProject, iClasspathContainer);
                }
                catch (CoreException coreException) {
                    cPUserLibraryElement.add(coreException.getStatus());
                }
            }
            iProgressMonitor.worked(1);
            ++n3;
        }
        Iterator<String> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            iPath = new Path("org.eclipse.wst.jsdt.USER_LIBRARY").append((String)object);
            try {
                classpathContainerInitializer.requestClasspathContainerUpdate(iPath, iJavaProject, null);
            }
            catch (CoreException coreException) {
                cPUserLibraryElement.add(coreException.getStatus());
            }
            iProgressMonitor.worked(1);
        }
        if (!cPUserLibraryElement.isOK()) {
            throw new CoreException((IStatus)cPUserLibraryElement);
        }
    }

    private CPUserLibraryElement getSingleSelectedLibrary(List list) {
        if (list.size() == 1 && list.get(0) instanceof CPUserLibraryElement) {
            return (CPUserLibraryElement)list.get(0);
        }
        return null;
    }

    private void editAttributeEntry(CPListElementAttribute cPListElementAttribute) {
        IClasspathAttribute iClasspathAttribute;
        ClasspathAttributeConfiguration classpathAttributeConfiguration;
        String string = cPListElementAttribute.getKey();
        CPListElement cPListElement = cPListElementAttribute.getParent();
        if (string.equals("sourcepath")) {
            IClasspathEntry iClasspathEntry = BuildPathDialogAccess.configureSourceAttachment(this.getShell(), cPListElement.getClasspathEntry());
            if (iClasspathEntry != null) {
                cPListElement.setAttribute("sourcepath", iClasspathEntry.getSourceAttachmentPath());
                this.fLibraryList.refresh(cPListElementAttribute);
                this.fLibraryList.update(cPListElement);
            }
        } else if (string.equals("accessrules")) {
            AccessRulesDialog accessRulesDialog = new AccessRulesDialog(this.getShell(), cPListElement, null, false);
            if (accessRulesDialog.open() == 0) {
                cPListElement.setAttribute("accessrules", accessRulesDialog.getAccessRules());
                this.fLibraryList.refresh(cPListElementAttribute);
                this.fLibraryList.expandElement(cPListElementAttribute, 2);
            }
        } else if (!cPListElementAttribute.isBuiltIn() && (classpathAttributeConfiguration = this.fAttributeDescriptors.get(string)) != null && (iClasspathAttribute = classpathAttributeConfiguration.performEdit(this.getShell(), cPListElementAttribute.getClasspathAttributeAccess())) != null) {
            cPListElementAttribute.setValue(iClasspathAttribute.getValue());
            this.fLibraryList.refresh(cPListElementAttribute);
        }
    }

    protected void doSelectionChanged(TreeListDialogField treeListDialogField) {
        List list = treeListDialogField.getSelectedElements();
        treeListDialogField.enableButton(3, this.canRemove(list));
        treeListDialogField.enableButton(1, this.canEdit(list));
        treeListDialogField.enableButton(2, this.canAdd(list));
        treeListDialogField.enableButton(5, this.canMoveUp(list));
        treeListDialogField.enableButton(6, this.canMoveDown(list));
        treeListDialogField.enableButton(9, treeListDialogField.getSize() > 0);
    }

    protected void doCustomButtonPressed(TreeListDialogField treeListDialogField, int n) {
        if (n == 0) {
            this.editUserLibraryElement(null);
        } else if (n == 2) {
            this.doAdd(treeListDialogField.getSelectedElements());
        } else if (n == 3) {
            this.doRemove(treeListDialogField.getSelectedElements());
        } else if (n == 1) {
            this.doEdit(treeListDialogField.getSelectedElements());
        } else if (n == 9) {
            this.doSave();
        } else if (n == 8) {
            this.doLoad();
        } else if (n == 5) {
            this.doMoveUp(treeListDialogField.getSelectedElements());
        } else if (n == 6) {
            this.doMoveDown(treeListDialogField.getSelectedElements());
        }
    }

    protected void doDoubleClicked(TreeListDialogField treeListDialogField) {
        List list = treeListDialogField.getSelectedElements();
        if (this.canEdit(list)) {
            this.doEdit(treeListDialogField.getSelectedElements());
        }
    }

    protected void doKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.doRemove(list);
        }
    }

    private void doEdit(List list) {
        if (list.size() == 1) {
            Object e = list.get(0);
            if (e instanceof CPListElementAttribute) {
                this.editAttributeEntry((CPListElementAttribute)e);
            } else if (e instanceof CPUserLibraryElement) {
                this.editUserLibraryElement((CPUserLibraryElement)e);
            } else if (e instanceof CPListElement) {
                CPListElement cPListElement = (CPListElement)e;
                this.editArchiveElement(cPListElement, (CPUserLibraryElement)cPListElement.getParentContainer());
            }
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void editUserLibraryElement(CPUserLibraryElement cPUserLibraryElement) {
        LibraryNameDialog libraryNameDialog = new LibraryNameDialog(this.getShell(), cPUserLibraryElement, this.fLibraryList.getElements());
        if (libraryNameDialog.open() == 0) {
            CPUserLibraryElement cPUserLibraryElement2 = libraryNameDialog.getNewLibrary();
            if (cPUserLibraryElement != null) {
                this.fLibraryList.replaceElement(cPUserLibraryElement, cPUserLibraryElement2);
            } else {
                this.fLibraryList.addElement(cPUserLibraryElement2);
            }
            this.fLibraryList.expandElement(cPUserLibraryElement2, -1);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)cPUserLibraryElement2));
        }
    }

    private void editArchiveElement(CPListElement cPListElement, CPUserLibraryElement cPUserLibraryElement) {
        CPListElement[] cPListElementArray = this.openExtJarFileDialog(cPListElement, cPUserLibraryElement);
        if (cPListElementArray != null) {
            int n = 0;
            while (n < cPListElementArray.length) {
                if (cPListElement != null) {
                    cPUserLibraryElement.replace(cPListElement, cPListElementArray[n]);
                } else {
                    cPUserLibraryElement.add(cPListElementArray[n]);
                }
                ++n;
            }
            this.fLibraryList.refresh(cPUserLibraryElement);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(Arrays.asList(cPListElementArray)));
            this.fLibraryList.expandElement(cPUserLibraryElement, 2);
        }
    }

    private void doRemove(List list) {
        Object object = null;
        int n = 0;
        while (n < list.size()) {
            Object object2;
            Object object3;
            Object e = list.get(n);
            if (e instanceof CPUserLibraryElement) {
                this.fLibraryList.removeElement(e);
            } else if (e instanceof CPListElement) {
                object3 = ((CPListElement)e).getParentContainer();
                if (object3 instanceof CPUserLibraryElement) {
                    object2 = (CPUserLibraryElement)object3;
                    object2.remove((CPListElement)e);
                    this.fLibraryList.refresh(object2);
                    object = object3;
                }
            } else if (e instanceof CPListElementAttribute) {
                String string;
                object3 = (CPListElementAttribute)e;
                if (((CPListElementAttribute)object3).isBuiltIn()) {
                    object2 = null;
                    string = ((CPListElementAttribute)object3).getKey();
                    if (string.equals("accessrules")) {
                        object2 = new IAccessRule[]{};
                    }
                    ((CPListElementAttribute)object3).getParent().setAttribute(string, object2);
                    this.fLibraryList.refresh(object3);
                } else {
                    object2 = this.fAttributeDescriptors.get(((CPListElementAttribute)object3).getKey());
                    if (object2 != null && (string = object2.performRemove(((CPListElementAttribute)object3).getClasspathAttributeAccess())) != null) {
                        ((CPListElementAttribute)object3).setValue(string.getValue());
                        this.fLibraryList.refresh(object3);
                    }
                }
            }
            ++n;
        }
        if (this.fLibraryList.getSelectedElements().isEmpty()) {
            if (object != null) {
                this.fLibraryList.selectElements((ISelection)new StructuredSelection(object));
            } else {
                this.fLibraryList.selectFirstElement();
            }
        } else {
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void doAdd(List list) {
        if (this.canAdd(list)) {
            CPUserLibraryElement cPUserLibraryElement = this.getSingleSelectedLibrary(list);
            this.editArchiveElement(null, cPUserLibraryElement);
        }
    }

    private void doLoad() {
        List list = this.fLibraryList.getElements();
        LoadSaveDialog loadSaveDialog = new LoadSaveDialog(this.getShell(), false, list, this.fDialogSettings);
        if (loadSaveDialog.open() == 0) {
            HashMap<String, CPUserLibraryElement> hashMap = new HashMap<String, CPUserLibraryElement>(list.size());
            int n = 0;
            while (n < list.size()) {
                CPUserLibraryElement cPUserLibraryElement = (CPUserLibraryElement)list.get(n);
                hashMap.put(cPUserLibraryElement.getName(), cPUserLibraryElement);
                ++n;
            }
            List list2 = loadSaveDialog.getLoadedLibraries();
            int n2 = 0;
            while (n2 < list2.size()) {
                CPUserLibraryElement cPUserLibraryElement = (CPUserLibraryElement)list2.get(n2);
                CPUserLibraryElement cPUserLibraryElement2 = (CPUserLibraryElement)hashMap.get(cPUserLibraryElement.getName());
                if (cPUserLibraryElement2 == null) {
                    list.add(cPUserLibraryElement);
                    hashMap.put(cPUserLibraryElement.getName(), cPUserLibraryElement);
                } else {
                    list.set(list.indexOf(cPUserLibraryElement2), cPUserLibraryElement);
                }
                ++n2;
            }
            this.fLibraryList.setElements(list);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(list2));
        }
    }

    private void doSave() {
        LoadSaveDialog loadSaveDialog = new LoadSaveDialog(this.getShell(), true, this.fLibraryList.getElements(), this.fDialogSettings);
        loadSaveDialog.open();
    }

    private boolean canAdd(List list) {
        return this.getSingleSelectedLibrary(list) != null;
    }

    private boolean canEdit(List list) {
        CPListElementAttribute cPListElementAttribute;
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof IAccessRule) {
            return false;
        }
        if (e instanceof CPListElementAttribute && !(cPListElementAttribute = (CPListElementAttribute)e).isBuiltIn()) {
            ClasspathAttributeConfiguration classpathAttributeConfiguration = this.fAttributeDescriptors.get(cPListElementAttribute.getKey());
            return classpathAttributeConfiguration != null && classpathAttributeConfiguration.canEdit(cPListElementAttribute.getClasspathAttributeAccess());
        }
        return true;
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof CPListElementAttribute) {
                CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
                if (cPListElementAttribute.isNonModifiable()) {
                    return false;
                }
                if (cPListElementAttribute.isBuiltIn()) {
                    if (cPListElementAttribute.getKey().equals("accessrules")) {
                        return ((IAccessRule[])cPListElementAttribute.getValue()).length > 0;
                    }
                    if (cPListElementAttribute.getValue() == null) {
                        return false;
                    }
                } else {
                    ClasspathAttributeConfiguration classpathAttributeConfiguration = this.fAttributeDescriptors.get(cPListElementAttribute.getKey());
                    if (classpathAttributeConfiguration == null || !classpathAttributeConfiguration.canRemove(cPListElementAttribute.getClasspathAttributeAccess())) {
                        return false;
                    }
                }
            } else if (!(e instanceof CPListElement) && !(e instanceof CPUserLibraryElement)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CPUserLibraryElement getCommonParent(List list) {
        CPUserLibraryElement cPUserLibraryElement = null;
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Object e = list.get(n);
            if (!(e instanceof CPListElement)) return null;
            Object object = ((CPListElement)e).getParentContainer();
            if (cPUserLibraryElement == null) {
                if (!(object instanceof CPUserLibraryElement)) return null;
                cPUserLibraryElement = (CPUserLibraryElement)object;
            } else if (cPUserLibraryElement != object) {
                return null;
            }
            ++n;
        }
        return cPUserLibraryElement;
    }

    private void doMoveUp(List list) {
        CPUserLibraryElement cPUserLibraryElement = this.getCommonParent(list);
        if (cPUserLibraryElement != null) {
            cPUserLibraryElement.moveUp(list);
            this.fLibraryList.refresh(cPUserLibraryElement);
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void doMoveDown(List list) {
        CPUserLibraryElement cPUserLibraryElement = this.getCommonParent(list);
        if (cPUserLibraryElement != null) {
            cPUserLibraryElement.moveDown(list);
            this.fLibraryList.refresh(cPUserLibraryElement);
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private boolean canMoveUp(List list) {
        CPUserLibraryElement cPUserLibraryElement = this.getCommonParent(list);
        if (cPUserLibraryElement != null) {
            CPListElement[] cPListElementArray = cPUserLibraryElement.getChildren();
            int n = 0;
            int n2 = Math.min(list.size(), cPListElementArray.length);
            while (n < n2) {
                if (!list.contains(cPListElementArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean canMoveDown(List list) {
        CPUserLibraryElement cPUserLibraryElement = this.getCommonParent(list);
        if (cPUserLibraryElement != null) {
            CPListElement[] cPListElementArray = cPUserLibraryElement.getChildren();
            int n = cPListElementArray.length - 1;
            int n2 = Math.max(0, cPListElementArray.length - list.size());
            while (n >= n2) {
                if (!list.contains(cPListElementArray[n])) {
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    private CPListElement[] openExtJarFileDialog(CPListElement cPListElement, Object object) {
        String string;
        String string2;
        if (cPListElement != null) {
            string2 = cPListElement.getPath().removeLastSegments(1).toOSString();
        } else {
            string2 = this.fDialogSettings.get("org.eclipse.wst.jsdt.ui.lastextjar");
            if (string2 == null) {
                string2 = "";
            }
        }
        String string3 = cPListElement == null ? PreferencesMessages.UserLibraryPreferencePage_browsejar_new_title : PreferencesMessages.UserLibraryPreferencePage_browsejar_edit_title;
        FileDialog fileDialog = new FileDialog(this.getShell(), cPListElement == null ? 2 : 4);
        fileDialog.setText(string3);
        fileDialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        fileDialog.setFilterPath(string2);
        if (cPListElement != null) {
            fileDialog.setFileName(cPListElement.getPath().lastSegment());
        }
        if ((string = fileDialog.open()) == null) {
            return null;
        }
        String[] stringArray = fileDialog.getFileNames();
        int n = stringArray.length;
        IPath iPath = Path.fromOSString((String)fileDialog.getFilterPath());
        CPListElement[] cPListElementArray = new CPListElement[n];
        int n2 = 0;
        while (n2 < n) {
            IPath iPath2 = iPath.append(stringArray[n2]).makeAbsolute();
            CPListElement cPListElement2 = new CPListElement(object, null, 1, iPath2, null);
            cPListElement2.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(cPListElement2));
            cPListElement2.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(cPListElement2));
            cPListElementArray[n2] = cPListElement2;
            ++n2;
        }
        this.fDialogSettings.put("org.eclipse.wst.jsdt.ui.lastextjar", fileDialog.getFilterPath());
        return cPListElementArray;
    }

    public static class LibraryNameDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fNameField;
        private SelectionButtonDialogField fIsSystemField;
        private CPUserLibraryElement fElementToEdit;
        private List fExistingLibraries;

        public LibraryNameDialog(Shell shell, CPUserLibraryElement cPUserLibraryElement, List list) {
            super(shell);
            if (cPUserLibraryElement == null) {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_new_title);
            } else {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_edit_title);
            }
            this.fElementToEdit = cPUserLibraryElement;
            this.fExistingLibraries = list;
            this.fNameField = new StringDialogField();
            this.fNameField.setDialogFieldListener(this);
            this.fNameField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_label);
            this.fIsSystemField = new SelectionButtonDialogField(32);
            this.fIsSystemField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_issystem_label);
            if (cPUserLibraryElement != null) {
                this.fNameField.setText(cPUserLibraryElement.getName());
                this.fIsSystemField.setSelection(cPUserLibraryElement.isSystemLibrary());
            } else {
                this.fNameField.setText("");
                this.fIsSystemField.setSelection(false);
            }
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fNameField, this.fIsSystemField}, true, -1, -1);
            this.fNameField.postSetFocusOnDialogField(composite.getDisplay());
            Dialog.applyDialogFont((Control)composite2);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.cp_edit_user_library");
            return composite2;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == this.fNameField) {
                this.updateStatus(this.validateSettings());
            }
        }

        private IStatus validateSettings() {
            String string = this.fNameField.getText();
            if (string.length() == 0) {
                return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_error_entername);
            }
            int n = 0;
            while (n < this.fExistingLibraries.size()) {
                CPUserLibraryElement cPUserLibraryElement = (CPUserLibraryElement)this.fExistingLibraries.get(n);
                if (cPUserLibraryElement != this.fElementToEdit && string.equals(cPUserLibraryElement.getName())) {
                    return new StatusInfo(4, Messages.format(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_error_exists, string));
                }
                ++n;
            }
            IStatus iStatus = ResourcesPlugin.getWorkspace().validateName(string, 1);
            if (iStatus.matches(4)) {
                return new StatusInfo(4, "Name contains invalid characters.");
            }
            return StatusInfo.OK_STATUS;
        }

        public CPUserLibraryElement getNewLibrary() {
            CPListElement[] cPListElementArray = null;
            if (this.fElementToEdit != null) {
                cPListElementArray = this.fElementToEdit.getChildren();
            }
            return new CPUserLibraryElement(this.fNameField.getText(), this.fIsSystemField.isSelected(), cPListElementArray);
        }
    }

    public static class LoadSaveDialog
    extends StatusDialog
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private static final String VERSION1 = "1";
        private static final String CURRENT_VERSION = "2";
        private static final String TAG_ROOT = "eclipse-userlibraries";
        private static final String TAG_VERSION = "version";
        private static final String TAG_LIBRARY = "library";
        private static final String TAG_SOURCEATTACHMENT = "source";
        private static final String TAG_ARCHIVE_PATH = "path";
        private static final String TAG_ARCHIVE = "archive";
        private static final String TAG_SYSTEMLIBRARY = "systemlibrary";
        private static final String TAG_NAME = "name";
        private static final String TAG_JAVADOC = "javadoc";
        private static final String TAG_NATIVELIB_PATHS = "nativelibpaths";
        private static final String TAG_ACCESSRULES = "accessrules";
        private static final String TAG_ACCESSRULE = "accessrule";
        private static final String TAG_RULE_KIND = "kind";
        private static final String TAG_RULE_PATTERN = "pattern";
        private static final String PREF_LASTPATH = "org.eclipse.wst.jsdt.ui.lastuserlibrary";
        private static final String PREF_USER_LIBRARY_LOADSAVE_SIZE = "UserLibraryLoadSaveDialog.size";
        private List fExistingLibraries;
        private IDialogSettings fSettings;
        private File fLastFile;
        private StringButtonDialogField fLocationField;
        private CheckedListDialogField fExportImportList;
        private Point fInitialSize;
        private final boolean fIsSave;

        public LoadSaveDialog(Shell shell, boolean bl, List list, IDialogSettings iDialogSettings) {
            super(shell);
            this.initializeDialogUnits((Control)shell);
            this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
            this.fExistingLibraries = list;
            this.fSettings = iDialogSettings;
            this.fLastFile = null;
            this.fIsSave = bl;
            int n = this.convertWidthInCharsToPixels(80);
            int n2 = this.convertHeightInCharsToPixels(34);
            String string = this.fSettings.get(PREF_USER_LIBRARY_LOADSAVE_SIZE);
            this.fInitialSize = string != null ? StringConverter.asPoint((String)string, (Point)new Point(n, n2)) : new Point(n, n2);
            if (this.isSave()) {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_title);
            } else {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_title);
            }
            this.fLocationField = new StringButtonDialogField(this);
            this.fLocationField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_label);
            this.fLocationField.setButtonLabel(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_button);
            this.fLocationField.setDialogFieldListener(this);
            String[] stringArray = new String[]{PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_selectall_button, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_deselectall_button};
            this.fExportImportList = new CheckedListDialogField(this, stringArray, (ILabelProvider)new CPListLabelProvider());
            this.fExportImportList.setCheckAllButtonIndex(0);
            this.fExportImportList.setUncheckAllButtonIndex(1);
            this.fExportImportList.setViewerComparator(new CPListElementSorter());
            this.fExportImportList.setDialogFieldListener(this);
            if (this.isSave()) {
                this.fExportImportList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_save_label);
                this.fExportImportList.setElements(this.fExistingLibraries);
                this.fExportImportList.checkAll(true);
            } else {
                this.fExportImportList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_load_label);
            }
            String string2 = this.fSettings.get(PREF_LASTPATH);
            if (string2 != null) {
                this.fLocationField.setText(string2);
            } else {
                this.fLocationField.setText("");
            }
        }

        protected Point getInitialSize() {
            return this.fInitialSize;
        }

        private boolean isSave() {
            return this.fIsSave;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            DialogField[] dialogFieldArray = this.isSave() ? new DialogField[]{this.fExportImportList, this.fLocationField} : new DialogField[]{this.fLocationField, this.fExportImportList};
            LayoutUtil.doDefaultLayout(composite2, dialogFieldArray, true, -1, -1);
            this.fExportImportList.getListControl(null).setLayoutData((Object)new GridData(1808));
            this.fLocationField.postSetFocusOnDialogField(composite.getDisplay());
            Dialog.applyDialogFont((Control)composite2);
            if (this.isSave()) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.cp_export_user_library");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.cp_import_user_library");
            }
            return composite2;
        }

        public void changeControlPressed(DialogField dialogField) {
            String string;
            String string2 = this.isSave() ? PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_filedialog_save_title : PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_filedialog_load_title;
            FileDialog fileDialog = new FileDialog(this.getShell(), this.isSave() ? 8192 : 4096);
            fileDialog.setText(string2);
            fileDialog.setFilterExtensions(new String[]{"*.userlibraries", "*.*"});
            String string3 = this.fLocationField.getText();
            if (string3.length() == 0 || !new File(string3).exists()) {
                string3 = this.fSettings.get(PREF_LASTPATH);
            }
            if (string3 != null) {
                fileDialog.setFileName(string3);
            }
            if ((string = fileDialog.open()) != null) {
                this.fSettings.put(PREF_LASTPATH, string);
                this.fLocationField.setText(string);
            }
        }

        private IStatus updateShownLibraries(IStatus iStatus) {
            if (!iStatus.isOK()) {
                this.fExportImportList.removeAllElements();
                this.fExportImportList.setEnabled(false);
                this.fLastFile = null;
            } else {
                File file = new File(this.fLocationField.getText());
                if (!file.equals(this.fLastFile)) {
                    this.fLastFile = file;
                    try {
                        List list = LoadSaveDialog.loadLibraries(file);
                        this.fExportImportList.setElements(list);
                        this.fExportImportList.checkAll(true);
                        this.fExportImportList.setEnabled(true);
                        if (list.isEmpty()) {
                            return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_error_empty);
                        }
                    }
                    catch (IOException iOException) {
                        this.fExportImportList.removeAllElements();
                        this.fExportImportList.setEnabled(false);
                        return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_error_invalidfile);
                    }
                }
            }
            return iStatus;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == this.fLocationField) {
                IStatus iStatus = this.validateSettings();
                if (!this.isSave()) {
                    iStatus = this.updateShownLibraries(iStatus);
                }
                this.updateStatus(iStatus);
            } else if (dialogField == this.fExportImportList) {
                this.updateStatus(this.validateSettings());
            }
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
        }

        public void selectionChanged(ListDialogField listDialogField) {
        }

        public void doubleClicked(ListDialogField listDialogField) {
            List list = this.fExportImportList.getSelectedElements();
            if (list.size() == 1) {
                Object e;
                this.fExportImportList.setChecked(e, !this.fExportImportList.isChecked(e = list.get(0)));
            }
        }

        protected void okPressed() {
            if (this.isSave()) {
                String string;
                String string2;
                File file = new File(this.fLocationField.getText());
                if (file.exists()) {
                    string2 = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_overwrite_title;
                    string = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_overwrite_message;
                    if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)string2, (String)string)) {
                        return;
                    }
                }
                try {
                    String string3;
                    List list;
                    string2 = "UTF-8";
                    string = Path.fromOSString((String)file.getCanonicalPath());
                    IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                    if (string.matchingFirstSegments(iPath) == iPath.segmentCount()) {
                        list = string.removeFirstSegments(iPath.segmentCount());
                        list = list.makeRelative();
                        string3 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)list);
                        try {
                            string2 = string3.getCharset(true);
                        }
                        catch (CoreException coreException) {
                            JavaPlugin.log(coreException);
                        }
                    }
                    list = this.fExportImportList.getCheckedElements();
                    string3 = string2;
                    IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
                    try {
                        iProgressService.run(true, true, new IRunnableWithProgress(this, list, file, string3){
                            final /* synthetic */ LoadSaveDialog this$1;
                            private final /* synthetic */ List val$elements;
                            private final /* synthetic */ File val$file;
                            private final /* synthetic */ String val$charset;
                            {
                                this.this$1 = loadSaveDialog;
                                this.val$elements = list;
                                this.val$file = file;
                                this.val$charset = string;
                            }

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    LoadSaveDialog.saveLibraries(this.val$elements, this.val$file, this.val$charset, iProgressMonitor);
                                }
                                catch (IOException iOException) {
                                    throw new InvocationTargetException(iOException);
                                }
                            }
                        });
                        this.fSettings.put(PREF_LASTPATH, file.getPath());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string4 = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_errordialog_title;
                        String string5 = Messages.format(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_errordialog_message, invocationTargetException.getMessage());
                        ExceptionHandler.handle(invocationTargetException, this.getShell(), string4, string5);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    String string6 = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_ok_title;
                    String string7 = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_ok_message;
                    MessageDialog.openInformation((Shell)this.getShell(), (String)string6, (String)string7);
                }
                catch (IOException iOException) {
                    JavaPlugin.log(iOException);
                }
            } else {
                Object object;
                Object object2;
                HashSet<String> hashSet = new HashSet<String>(this.fExistingLibraries.size());
                int n = 0;
                while (n < this.fExistingLibraries.size()) {
                    object2 = (CPUserLibraryElement)this.fExistingLibraries.get(n);
                    hashSet.add(((CPUserLibraryElement)object2).getName());
                    ++n;
                }
                n = 0;
                object2 = this.getLoadedLibraries();
                int n2 = 0;
                while (n2 < object2.size()) {
                    object = (CPUserLibraryElement)object2.get(n2);
                    if (hashSet.contains(((CPUserLibraryElement)object).getName())) {
                        ++n;
                    }
                    ++n2;
                }
                if (n > 0) {
                    String string = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_title;
                    object = n == 1 ? PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_message : Messages.format(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_multiple_message, String.valueOf(n));
                    if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)string, (String)object)) {
                        return;
                    }
                }
            }
            super.okPressed();
        }

        public boolean close() {
            Point point = this.getShell().getSize();
            this.fSettings.put(PREF_USER_LIBRARY_LOADSAVE_SIZE, StringConverter.asString((Point)point));
            return super.close();
        }

        private IStatus validateSettings() {
            String string = this.fLocationField.getText();
            this.fLastFile = null;
            if (this.isSave()) {
                if (string.length() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_save_enterlocation);
                }
                File file = new File(string);
                if (file.isDirectory()) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_save_invalid);
                }
                if (this.fExportImportList.getCheckedSize() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_error_save_nothingselected);
                }
                this.fLastFile = file;
            } else {
                if (string.length() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_load_enterlocation);
                }
                if (!new File(string).isFile()) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_load_invalid);
                }
                if (this.fExportImportList.getSize() > 0 && this.fExportImportList.getCheckedSize() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_error_load_nothingselected);
                }
            }
            return new StatusInfo();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected static void saveLibraries(List list, File file, String string, IProgressMonitor iProgressMonitor) throws IOException {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                try {
                    DocumentBuilder documentBuilder = null;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    Element element = document.createElement(TAG_ROOT);
                    document.appendChild(element);
                    element.setAttribute(TAG_VERSION, CURRENT_VERSION);
                    int n = 0;
                    block9: while (true) {
                        Object object;
                        Object object2;
                        block18: {
                            if (n < list.size()) break block18;
                            Transformer transformer = TransformerFactory.newInstance().newTransformer();
                            transformer.setOutputProperty("method", "xml");
                            transformer.setOutputProperty("encoding", string);
                            transformer.setOutputProperty("indent", "yes");
                            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                            object2 = new DOMSource(document);
                            object = new StreamResult(fileOutputStream);
                            transformer.transform((Source)object2, (Result)object);
                            break;
                        }
                        object2 = document.createElement(TAG_LIBRARY);
                        element.appendChild((Node)object2);
                        object = (CPUserLibraryElement)list.get(n);
                        object2.setAttribute(TAG_NAME, ((CPUserLibraryElement)object).getName());
                        object2.setAttribute(TAG_SYSTEMLIBRARY, String.valueOf(((CPUserLibraryElement)object).isSystemLibrary()));
                        CPListElement[] cPListElementArray = ((CPUserLibraryElement)object).getChildren();
                        int n2 = 0;
                        while (true) {
                            IAccessRule[] iAccessRuleArray;
                            String string2;
                            String string3;
                            if (n2 >= cPListElementArray.length) {
                                ++n;
                                continue block9;
                            }
                            CPListElement cPListElement = cPListElementArray[n2];
                            Element element2 = document.createElement(TAG_ARCHIVE);
                            object2.appendChild(element2);
                            element2.setAttribute(TAG_ARCHIVE_PATH, cPListElement.getPath().toPortableString());
                            IPath iPath = (IPath)cPListElement.getAttribute("sourcepath");
                            if (iPath != null) {
                                element2.setAttribute(TAG_SOURCEATTACHMENT, iPath.toPortableString());
                            }
                            if ((string3 = (String)cPListElement.getAttribute("javadoc_location")) != null) {
                                element2.setAttribute(TAG_JAVADOC, string3);
                            }
                            if ((string2 = (String)cPListElement.getAttribute("org.eclipse.wst.jsdt.core.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY")) != null) {
                                element2.setAttribute(TAG_NATIVELIB_PATHS, string2);
                            }
                            if ((iAccessRuleArray = (IAccessRule[])cPListElement.getAttribute(TAG_ACCESSRULES)) != null && iAccessRuleArray.length > 0) {
                                Element element3 = document.createElement(TAG_ACCESSRULES);
                                element2.appendChild(element3);
                                int n3 = 0;
                                while (n3 < iAccessRuleArray.length) {
                                    IAccessRule iAccessRule = iAccessRuleArray[n3];
                                    Element element4 = document.createElement(TAG_ACCESSRULE);
                                    element3.appendChild(element4);
                                    element4.setAttribute(TAG_RULE_KIND, String.valueOf(iAccessRule.getKind()));
                                    element4.setAttribute(TAG_RULE_PATTERN, iAccessRule.getPattern().toPortableString());
                                    ++n3;
                                }
                            }
                            ++n2;
                        }
                        break;
                    }
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(parserConfigurationException.getMessage());
                }
                catch (TransformerException transformerException) {
                    throw new IOException(transformerException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var24_28 = null;
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
                if (iProgressMonitor == null) throw throwable;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var24_29 = null;
            }
            try {}
            catch (IOException iOException) {}
            ((OutputStream)fileOutputStream).close();
            if (iProgressMonitor == null) return;
            iProgressMonitor.done();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static List loadLibraries(File file) throws IOException {
            NodeList nodeList;
            Element element;
            Object object;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                try {
                    object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    element = ((DocumentBuilder)object).parse(new InputSource(fileInputStream)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            {
                nodeList = null;
            }
            ((InputStream)fileInputStream).close();
            if (!element.getNodeName().equalsIgnoreCase(TAG_ROOT)) {
                throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
            }
            object = element.getAttribute(TAG_VERSION);
            nodeList = element.getElementsByTagName(TAG_LIBRARY);
            int n = nodeList.getLength();
            ArrayList<CPUserLibraryElement> arrayList = new ArrayList<CPUserLibraryElement>(n);
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node instanceof Element) {
                    Element element2 = (Element)node;
                    String string = element2.getAttribute(TAG_NAME);
                    boolean bl = Boolean.valueOf(element2.getAttribute(TAG_SYSTEMLIBRARY));
                    CPUserLibraryElement cPUserLibraryElement = new CPUserLibraryElement(string, bl, null);
                    arrayList.add(cPUserLibraryElement);
                    NodeList nodeList2 = element2.getElementsByTagName(TAG_ARCHIVE);
                    int n3 = 0;
                    while (n3 < nodeList2.getLength()) {
                        Node node2 = nodeList2.item(n3);
                        if (node2 instanceof Element) {
                            NodeList nodeList3;
                            int n4;
                            Object object2;
                            Object object3;
                            Element element3 = (Element)node2;
                            String string2 = element3.getAttribute(TAG_ARCHIVE_PATH);
                            IPath iPath = ((String)object).equals(VERSION1) ? Path.fromOSString((String)string2) : Path.fromPortableString((String)string2);
                            CPListElement cPListElement = new CPListElement(cPUserLibraryElement, null, 1, iPath, null);
                            cPUserLibraryElement.add(cPListElement);
                            if (element3.hasAttribute(TAG_SOURCEATTACHMENT)) {
                                object3 = element3.getAttribute(TAG_SOURCEATTACHMENT);
                                object2 = ((String)object).equals(VERSION1) ? Path.fromOSString((String)object3) : Path.fromPortableString((String)object3);
                                cPListElement.setAttribute("sourcepath", object2);
                            }
                            if (element3.hasAttribute(TAG_JAVADOC)) {
                                object3 = element3.getAttribute(TAG_JAVADOC);
                                cPListElement.setAttribute("javadoc_location", object3);
                            }
                            if (element3.hasAttribute(TAG_NATIVELIB_PATHS)) {
                                object3 = element3.getAttribute(TAG_NATIVELIB_PATHS);
                                cPListElement.setAttribute("org.eclipse.wst.jsdt.core.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", object3);
                            }
                            if ((object3 = element3.getElementsByTagName(TAG_ACCESSRULES)).getLength() > 0 && object3.item(0) instanceof Element && (n4 = (nodeList3 = (object2 = (Element)object3.item(0)).getElementsByTagName(TAG_ACCESSRULE)).getLength()) > 0) {
                                ArrayList<IAccessRule> arrayList2 = new ArrayList<IAccessRule>(n4);
                                int n5 = 0;
                                while (true) {
                                    if (n5 >= n4) {
                                        cPListElement.setAttribute(TAG_ACCESSRULES, arrayList2.toArray(new IAccessRule[arrayList2.size()]));
                                        break;
                                    }
                                    Node node3 = nodeList3.item(n5);
                                    if (node3 instanceof Element) {
                                        Element element4 = (Element)node3;
                                        try {
                                            int n6 = Integer.parseInt(element4.getAttribute(TAG_RULE_KIND));
                                            IPath iPath2 = Path.fromPortableString((String)element4.getAttribute(TAG_RULE_PATTERN));
                                            arrayList2.add(JavaCore.newAccessRule((IPath)iPath2, (int)n6));
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    }
                                    ++n5;
                                }
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            return arrayList;
        }

        public List getLoadedLibraries() {
            return this.fExportImportList.getCheckedElements();
        }
    }

    private class UserLibraryAdapter
    implements ITreeListAdapter {
        private final Object[] EMPTY = new Object[0];

        private UserLibraryAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            UserLibraryPreferencePage.this.doCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            UserLibraryPreferencePage.this.doSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            UserLibraryPreferencePage.this.doDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            UserLibraryPreferencePage.this.doKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            CPListElementAttribute cPListElementAttribute;
            if (object instanceof CPUserLibraryElement) {
                CPUserLibraryElement cPUserLibraryElement = (CPUserLibraryElement)object;
                return cPUserLibraryElement.getChildren();
            }
            if (object instanceof CPListElement) {
                return ((CPListElement)object).getChildren(false);
            }
            if (object instanceof CPListElementAttribute && "accessrules".equals((cPListElementAttribute = (CPListElementAttribute)object).getKey())) {
                return (IAccessRule[])cPListElementAttribute.getValue();
            }
            return this.EMPTY;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)object).getParent();
            }
            if (object instanceof CPListElement) {
                return ((CPListElement)object).getParentContainer();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return this.getChildren(treeListDialogField, object).length > 0;
        }
    }
}

