/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public abstract class ModifyDialog
extends StatusDialog
implements ModifyDialogTabPage.IModificationListener {
    private static final String DS_KEY_PREFERRED_WIDTH = "modify_dialog.preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = "modify_dialog.preferred_height";
    private static final String DS_KEY_PREFERRED_X = "modify_dialog.preferred_x";
    private static final String DS_KEY_PREFERRED_Y = "modify_dialog.preferred_y";
    private static final String DS_KEY_LAST_FOCUS = "modify_dialog.last_focus";
    private static final int APPLAY_BUTTON_ID = 1024;
    private static final int SAVE_BUTTON_ID = 1025;
    private final String fKeyPreferredWidth;
    private final String fKeyPreferredHight;
    private final String fKeyPreferredX;
    private final String fKeyPreferredY;
    private final String fKeyLastFocus;
    private final String fLastSaveLoadPathKey;
    private final ProfileStore fProfileStore;
    private final boolean fNewProfile;
    private ProfileManager.Profile fProfile;
    private final Map fWorkingValues;
    private final List fTabPages;
    private final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;
    private final ProfileManager fProfileManager;
    private Button fApplyButton;
    private Button fSaveButton;
    private StringDialogField fProfileNameField;

    public ModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean bl, String string, String string2) {
        super(shell);
        this.fProfileStore = profileStore;
        this.fLastSaveLoadPathKey = string2;
        this.fKeyPreferredWidth = "org.eclipse.wst.jsdt.ui" + string + DS_KEY_PREFERRED_WIDTH;
        this.fKeyPreferredHight = "org.eclipse.wst.jsdt.ui" + string + DS_KEY_PREFERRED_HEIGHT;
        this.fKeyPreferredX = "org.eclipse.wst.jsdt.ui" + string + DS_KEY_PREFERRED_X;
        this.fKeyPreferredY = "org.eclipse.wst.jsdt.ui" + string + DS_KEY_PREFERRED_Y;
        this.fKeyLastFocus = "org.eclipse.wst.jsdt.ui" + string + DS_KEY_LAST_FOCUS;
        this.fProfileManager = profileManager;
        this.fNewProfile = bl;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fProfile = profile;
        this.setTitle(Messages.format(FormatterMessages.ModifyDialog_dialog_title, profile.getName()));
        this.fWorkingValues = new HashMap(this.fProfile.getSettings());
        this.setStatusLineAboveButtons(false);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    }

    protected abstract void addPages(Map var1);

    public void create() {
        super.create();
        int n = 0;
        try {
            n = this.fDialogSettings.getInt(this.fKeyLastFocus);
            if (n < 0) {
                n = 0;
            }
            if (n > this.fTabPages.size() - 1) {
                n = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (!this.fNewProfile) {
            this.fTabFolder.setSelection(n);
            ((ModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, false));
        composite3.setLayout((Layout)new GridLayout(3, false));
        this.fProfileNameField = new StringDialogField();
        this.fProfileNameField.setLabelText(FormatterMessages.ModifyDialog_ProfileName_Label);
        this.fProfileNameField.setText(this.fProfile.getName());
        this.fProfileNameField.getLabelControl(composite3).setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fProfileNameField.getTextControl(composite3).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fProfileNameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                ModifyDialog.this.doValidate();
            }
        });
        this.fSaveButton = this.createButton(composite3, 1025, FormatterMessages.ModifyDialog_Export_Button, false);
        this.fTabFolder = new TabFolder(composite2, 0);
        this.fTabFolder.setFont(composite2.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPages(this.fWorkingValues);
        ModifyDialog.applyDialogFont((Control)composite2);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TabItem tabItem = (TabItem)selectionEvent.item;
                ModifyDialogTabPage modifyDialogTabPage = (ModifyDialogTabPage)tabItem.getData();
                ModifyDialog.this.fDialogSettings.put(ModifyDialog.this.fKeyLastFocus, ModifyDialog.this.fTabPages.indexOf(modifyDialogTabPage));
                modifyDialogTabPage.makeVisible();
            }
        });
        this.doValidate();
        return composite2;
    }

    public void updateStatus(IStatus iStatus) {
        if (iStatus == null) {
            this.doValidate();
        } else {
            super.updateStatus(iStatus);
        }
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        try {
            int n;
            int n2 = this.fDialogSettings.getInt(this.fKeyPreferredWidth);
            if (point.x > n2) {
                n2 = point.x;
            }
            if (point.y > (n = this.fDialogSettings.getInt(this.fKeyPreferredHight))) {
                n = point.x;
            }
            return new Point(n2, n);
        }
        catch (NumberFormatException numberFormatException) {
            return point;
        }
    }

    protected Point getInitialLocation(Point point) {
        try {
            return new Point(this.fDialogSettings.getInt(this.fKeyPreferredX), this.fDialogSettings.getInt(this.fKeyPreferredY));
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(point);
        }
    }

    public boolean close() {
        Rectangle rectangle = this.getShell().getBounds();
        this.fDialogSettings.put(this.fKeyPreferredWidth, rectangle.width);
        this.fDialogSettings.put(this.fKeyPreferredHight, rectangle.height);
        this.fDialogSettings.put(this.fKeyPreferredX, rectangle.x);
        this.fDialogSettings.put(this.fKeyPreferredY, rectangle.y);
        return super.close();
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    protected void buttonPressed(int n) {
        if (n == 1024) {
            this.applyPressed();
            this.setTitle(Messages.format(FormatterMessages.ModifyDialog_dialog_title, this.fProfile.getName()));
        } else if (n == 1025) {
            this.saveButtonPressed();
        } else {
            super.buttonPressed(n);
        }
    }

    private void applyPressed() {
        if (!this.fProfile.getName().equals(this.fProfileNameField.getText())) {
            this.fProfile = this.fProfile.rename(this.fProfileNameField.getText(), this.fProfileManager);
        }
        this.fProfile.setSettings(new HashMap(this.fWorkingValues));
        this.fProfileManager.setSelected(this.fProfile);
        this.doValidate();
    }

    private void saveButtonPressed() {
        String string;
        ProfileManager.CustomProfile customProfile = new ProfileManager.CustomProfile(this.fProfileNameField.getText(), new HashMap(this.fWorkingValues), this.fProfile.getVersion(), this.fProfileManager.getProfileVersioner().getProfileKind());
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText(FormatterMessages.CodingStyleConfigurationBlock_save_profile_dialog_title);
        fileDialog.setFilterExtensions(new String[]{"*.xml"});
        String string2 = JavaPlugin.getDefault().getDialogSettings().get(String.valueOf(this.fLastSaveLoadPathKey) + ".savepath");
        if (string2 != null) {
            fileDialog.setFilterPath(string2);
        }
        if ((string = fileDialog.open()) == null) {
            return;
        }
        JavaPlugin.getDefault().getDialogSettings().put(String.valueOf(this.fLastSaveLoadPathKey) + ".savepath", fileDialog.getFilterPath());
        File file = new File(string);
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_message, string))) {
            return;
        }
        String string3 = "UTF-8";
        IContentType iContentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
        if (iContentType != null) {
            string3 = iContentType.getDefaultCharset();
        }
        ArrayList<ProfileManager.CustomProfile> arrayList = new ArrayList<ProfileManager.CustomProfile>();
        arrayList.add(customProfile);
        try {
            this.fProfileStore.writeProfilesToFile(arrayList, file, string3);
        }
        catch (CoreException coreException) {
            String string4 = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_title;
            String string5 = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_message;
            ExceptionHandler.handle(coreException, this.getShell(), string4, string5);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.fApplyButton = this.createButton(composite, 1024, FormatterMessages.ModifyDialog_apply_button, false);
        this.fApplyButton.setEnabled(false);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        gridLayout.makeColumnsEqualWidth = false;
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.widthHint = gridLayout.horizontalSpacing;
        label.setLayoutData((Object)gridData);
        super.createButtonsForButtonBar(composite);
    }

    protected final void addTabPage(String string, ModifyDialogTabPage modifyDialogTabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        ModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(string);
        tabItem.setData((Object)modifyDialogTabPage);
        tabItem.setControl((Control)modifyDialogTabPage.createContents((Composite)this.fTabFolder));
        this.fTabPages.add(modifyDialogTabPage);
    }

    public void valuesModified() {
        this.doValidate();
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        super.updateButtonsEnableState(iStatus);
        if (this.fApplyButton != null && !this.fApplyButton.isDisposed()) {
            this.fApplyButton.setEnabled(this.hasChanges() && !iStatus.matches(4));
        }
        if (this.fSaveButton != null && !this.fSaveButton.isDisposed()) {
            this.fSaveButton.setEnabled(!this.validateProfileName().matches(4));
        }
    }

    private void doValidate() {
        IStatus iStatus = this.validateProfileName();
        if (iStatus.matches(4)) {
            this.updateStatus(iStatus);
            return;
        }
        String string = this.fProfileNameField.getText().trim();
        if (!string.equals(this.fProfile.getName()) && this.fProfileManager.containsName(string)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_Duplicate_Status));
            return;
        }
        if (this.fProfile.isBuiltInProfile() || this.fProfile.isSharedProfile()) {
            this.updateStatus((IStatus)new Status(1, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_NewCreated_Status));
            return;
        }
        this.updateStatus(StatusInfo.OK_STATUS);
    }

    private IStatus validateProfileName() {
        String string = this.fProfileNameField.getText().trim();
        if (this.fProfile.isBuiltInProfile() && this.fProfile.getName().equals(string)) {
            return new Status(4, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_BuiltIn_Status);
        }
        if (this.fProfile.isSharedProfile() && this.fProfile.getName().equals(string)) {
            return new Status(4, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_Shared_Status);
        }
        if (string.length() == 0) {
            return new Status(4, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_EmptyName_Status);
        }
        return StatusInfo.OK_STATUS;
    }

    private boolean hasChanges() {
        if (!this.fProfileNameField.getText().trim().equals(this.fProfile.getName())) {
            return true;
        }
        Iterator iterator = this.fProfile.getSettings().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.fWorkingValues.get(entry.getKey()).equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

