/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.IntroduceIndirectionRefactoring;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class IntroduceIndirectionInputPage
extends UserInputWizardPage {
    private Text fIntermediaryMethodName;
    private Combo fIntermediaryTypeName;
    private static final int INTERMEDIARY_TYPE_COUNT = 10;
    private static List fgIntermediaryTypes = new ArrayList(10);

    public IntroduceIndirectionInputPage(String string) {
        super(string);
    }

    private Text createIntermediaryNameCombo(Composite composite) {
        Text text = new Text(composite, 18436);
        text.setLayoutData((Object)new GridData(768));
        TextFieldNavigationHandler.install(text);
        return text;
    }

    private Combo createIntermediaryTypeCombo(Composite composite) {
        Combo combo = new Combo(composite, 2052);
        combo.setLayoutData((Object)new GridData(768));
        combo.setItems(fgIntermediaryTypes.toArray(new String[fgIntermediaryTypes.size()]));
        combo.setVisibleItemCount(10);
        JavaTypeCompletionProcessor javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        javaTypeCompletionProcessor.setPackageFragment(this.getIntroduceIndirectionRefactoring().getInvocationPackage());
        ControlContentAssistHelper.createComboContentAssistant(combo, javaTypeCompletionProcessor);
        TextFieldNavigationHandler.install(combo);
        return combo;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(RefactoringMessages.IntroduceIndirectionInputPage_new_method_name);
        this.fIntermediaryMethodName = this.createIntermediaryNameCombo(composite2);
        Label label2 = new Label(composite2, 0);
        label2.setText(RefactoringMessages.IntroduceIndirectionInputPage_declaring_class);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 2;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)new GridData(768));
        this.fIntermediaryTypeName = this.createIntermediaryTypeCombo(composite3);
        this.fIntermediaryTypeName.setLayoutData((Object)new GridData(768));
        Button button = new Button(composite3, 8);
        button.setText(RefactoringMessages.IntroduceIndirectionInputPage_browse);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        final Button button2 = new Button(composite2, 32);
        button2.setText(RefactoringMessages.IntroduceIndirectionInputPage_update_references);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 2;
        button2.setLayoutData((Object)gridData);
        this.fIntermediaryMethodName.setText(this.getIntroduceIndirectionRefactoring().getIntermediaryMethodName());
        this.fIntermediaryTypeName.setText(this.getIntroduceIndirectionRefactoring().getIntermediaryClassName());
        this.fIntermediaryMethodName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                IntroduceIndirectionInputPage.this.validateInput();
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IntroduceIndirectionInputPage.this.getIntroduceIndirectionRefactoring().setEnableUpdateReferences(button2.getSelection());
            }
        });
        this.fIntermediaryTypeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                IntroduceIndirectionInputPage.this.validateInput();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IType iType = IntroduceIndirectionInputPage.this.chooseIntermediaryClass();
                if (iType == null) {
                    return;
                }
                IntroduceIndirectionInputPage.this.fIntermediaryTypeName.setText(iType.getFullyQualifiedName());
            }
        });
        if (this.getIntroduceIndirectionRefactoring().canEnableUpdateReferences()) {
            button2.setSelection(true);
        } else {
            button2.setSelection(false);
            button2.setEnabled(false);
            this.getIntroduceIndirectionRefactoring().setEnableUpdateReferences(false);
        }
        this.fIntermediaryMethodName.setFocus();
        this.fIntermediaryMethodName.selectAll();
        this.validateInput();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.introduce_indirection_wizard_page_context");
    }

    private IType chooseIntermediaryClass() {
        IJavaProject iJavaProject = this.getIntroduceIndirectionRefactoring().getProject();
        if (iJavaProject == null) {
            return null;
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[]{iJavaProject};
        IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray);
        FilteredTypesSelectionDialog filteredTypesSelectionDialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), iJavaSearchScope, 5);
        filteredTypesSelectionDialog.setTitle(RefactoringMessages.IntroduceIndirectionInputPage_dialog_choose_declaring_class);
        filteredTypesSelectionDialog.setMessage(RefactoringMessages.IntroduceIndirectionInputPage_dialog_choose_declaring_class_long);
        if (filteredTypesSelectionDialog.open() == 0) {
            return (IType)filteredTypesSelectionDialog.getFirstResult();
        }
        return null;
    }

    private IntroduceIndirectionRefactoring getIntroduceIndirectionRefactoring() {
        return (IntroduceIndirectionRefactoring)this.getRefactoring();
    }

    private void validateInput() {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(this.getIntroduceIndirectionRefactoring().setIntermediaryClassName(this.fIntermediaryTypeName.getText()));
        refactoringStatus.merge(this.getIntroduceIndirectionRefactoring().setIntermediaryMethodName(this.fIntermediaryMethodName.getText()));
        this.setPageComplete(!refactoringStatus.hasError());
        int n = refactoringStatus.getSeverity();
        String string = refactoringStatus.getMessageMatchingSeverity(n);
        if (n >= 1) {
            this.setMessage(string, n);
        } else {
            this.setMessage("", 0);
        }
    }

    protected boolean performFinish() {
        this.storeIntermediaryTypeName();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.storeIntermediaryTypeName();
        return super.getNextPage();
    }

    private void storeIntermediaryTypeName() {
        String string = this.fIntermediaryTypeName.getText();
        if (!fgIntermediaryTypes.remove(string) && fgIntermediaryTypes.size() >= 10) {
            fgIntermediaryTypes.remove(fgIntermediaryTypes.size() - 1);
        }
        fgIntermediaryTypes.add(0, string);
    }
}

