/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;

public class NewNameQueries
implements INewNameQueries {
    private static final String INVALID_NAME_NO_MESSAGE = "";
    private final Wizard fWizard;
    private final Shell fShell;

    public NewNameQueries() {
        this.fShell = null;
        this.fWizard = null;
    }

    public NewNameQueries(Wizard wizard) {
        this.fWizard = wizard;
        this.fShell = null;
    }

    public NewNameQueries(Shell shell) {
        this.fShell = shell;
        this.fWizard = null;
    }

    private Shell getShell() {
        Assert.isTrue((this.fWizard == null || this.fShell == null ? 1 : 0) != 0);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public INewNameQuery createNewCompilationUnitNameQuery(ICompilationUnit iCompilationUnit, String string) {
        Object[] objectArray = new String[]{JavaCore.removeJavaLikeExtension((String)iCompilationUnit.getElementName())};
        String string2 = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, objectArray);
        return NewNameQueries.createStaticQuery(NewNameQueries.createCompilationUnitNameValidator(iCompilationUnit), string2, string, this.getShell());
    }

    public INewNameQuery createNewResourceNameQuery(IResource iResource, String string) {
        Object[] objectArray = new String[]{iResource.getName()};
        String string2 = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, objectArray);
        return NewNameQueries.createStaticQuery(NewNameQueries.createResourceNameValidator(iResource), string2, string, this.getShell());
    }

    public INewNameQuery createNewPackageNameQuery(IPackageFragment iPackageFragment, String string) {
        Object[] objectArray = new String[]{iPackageFragment.getElementName()};
        String string2 = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, objectArray);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageNameValidator(iPackageFragment), string2, string, this.getShell());
    }

    public INewNameQuery createNewPackageFragmentRootNameQuery(IPackageFragmentRoot iPackageFragmentRoot, String string) {
        Object[] objectArray = new String[]{iPackageFragmentRoot.getElementName()};
        String string2 = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, objectArray);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageFragmentRootNameValidator(iPackageFragmentRoot), string2, string, this.getShell());
    }

    public INewNameQuery createNullQuery() {
        return this.createStaticQuery(null);
    }

    public INewNameQuery createStaticQuery(final String string) {
        return new INewNameQuery(){

            public String getNewName() {
                return string;
            }
        };
    }

    private static INewNameQuery createStaticQuery(final IInputValidator iInputValidator, final String string, final String string2, final Shell shell) {
        return new INewNameQuery(){

            public String getNewName() throws OperationCanceledException {
                InputDialog inputDialog = new InputDialog(this, shell, ReorgMessages.ReorgQueries_nameConflictMessage, string, string2, iInputValidator){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected Control createDialogArea(Composite composite) {
                        Control control = super.createDialogArea(composite);
                        TextFieldNavigationHandler.install(this.getText());
                        return control;
                    }
                };
                if (inputDialog.open() == 1) {
                    throw new OperationCanceledException();
                }
                return inputDialog.getValue();
            }
        };
    }

    private static IInputValidator createResourceNameValidator(final IResource iResource) {
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                if (string == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(string) || iResource.getParent() == null) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (iResource.getParent().findMember(string) != null) {
                    return ReorgMessages.ReorgQueries_resourceWithThisNameAlreadyExists;
                }
                if (!iResource.getParent().getFullPath().isValidSegment(string)) {
                    return ReorgMessages.ReorgQueries_invalidNameMessage;
                }
                IStatus iStatus = iResource.getParent().getWorkspace().validateName(string, iResource.getType());
                if (iStatus.getSeverity() == 4) {
                    return iStatus.getMessage();
                }
                if (iResource.getName().equalsIgnoreCase(string)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return iInputValidator;
    }

    private static IInputValidator createCompilationUnitNameValidator(final ICompilationUnit iCompilationUnit) {
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                if (string == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(string)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                String string2 = JavaModelUtil.getRenamedCUName(iCompilationUnit, string);
                IStatus iStatus = JavaConventions.validateCompilationUnitName((String)string2);
                if (iStatus.getSeverity() == 4) {
                    return iStatus.getMessage();
                }
                RefactoringStatus refactoringStatus = Checks.checkCompilationUnitNewName(iCompilationUnit, string);
                if (refactoringStatus.hasFatalError()) {
                    return refactoringStatus.getMessageMatchingSeverity(4);
                }
                if (iCompilationUnit.getElementName().equalsIgnoreCase(string2)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return iInputValidator;
    }

    private static IInputValidator createPackageFragmentRootNameValidator(IPackageFragmentRoot iPackageFragmentRoot) {
        return new IInputValidator(iPackageFragmentRoot){
            IInputValidator resourceNameValidator;
            {
                this.resourceNameValidator = NewNameQueries.createResourceNameValidator(iPackageFragmentRoot.getResource());
            }

            public String isValid(String string) {
                return this.resourceNameValidator.isValid(string);
            }
        };
    }

    private static IInputValidator createPackageNameValidator(final IPackageFragment iPackageFragment) {
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                if (string == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(string)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                IStatus iStatus = JavaConventions.validatePackageName((String)string);
                if (iStatus.getSeverity() == 4) {
                    return iStatus.getMessage();
                }
                IJavaElement iJavaElement = iPackageFragment.getParent();
                try {
                    if (iJavaElement instanceof IPackageFragmentRoot && !RenamePackageProcessor.isPackageNameOkInRoot(string, (IPackageFragmentRoot)iJavaElement)) {
                        return ReorgMessages.ReorgQueries_packagewithThatNameexistsMassage;
                    }
                }
                catch (CoreException coreException) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (iPackageFragment.getElementName().equalsIgnoreCase(string)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return iInputValidator;
    }
}

