/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.DestinationContentProvider;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

abstract class ReorgUserInputPage
extends UserInputWizardPage {
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_DEFAULT | 0x40L | 2L | 0x8000L;
    private TreeViewer fViewer;

    public ReorgUserInputPage(String string) {
        super(string);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        Object object = this.getInitiallySelectedElement();
        this.verifyDestination(object, true);
        this.addLabel(composite2);
        this.fViewer = this.createViewer(composite2);
        this.fViewer.setSelection((ISelection)new StructuredSelection(object), true);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ReorgUserInputPage.this.viewerSelectionChanged(selectionChangedEvent);
            }
        });
        Dialog.applyDialogFont((Control)composite2);
    }

    protected Control addLabel(Composite composite) {
        Label label = new Label(composite, 64);
        int n = this.getResources().length;
        int n2 = this.getJavaElements().length;
        String string = n == 0 && n2 == 1 ? Messages.format(ReorgMessages.ReorgUserInputPage_choose_destination_single, JavaElementLabels.getElementLabel(this.getJavaElements()[0], LABEL_FLAGS)) : (n == 1 && n2 == 0 ? Messages.format(ReorgMessages.ReorgUserInputPage_choose_destination_single, this.getResources()[0].getName()) : Messages.format(ReorgMessages.ReorgUserInputPage_choose_destination_multi, String.valueOf(n + n2)));
        label.setText(string);
        GridData gridData = new GridData(4, 0x1000008, true, false);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void viewerSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        this.verifyDestination(iStructuredSelection.getFirstElement(), false);
    }

    protected abstract Object getInitiallySelectedElement();

    protected abstract RefactoringStatus verifyDestination(Object var1) throws JavaModelException;

    protected abstract IResource[] getResources();

    protected abstract IJavaElement[] getJavaElements();

    protected abstract IReorgDestinationValidator getDestinationValidator();

    private final void verifyDestination(Object object, boolean bl) {
        try {
            RefactoringStatus refactoringStatus = this.verifyDestination(object);
            if (bl) {
                this.setPageComplete(refactoringStatus.isOK());
            } else {
                this.setPageComplete(refactoringStatus);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            this.setPageComplete(false);
        }
    }

    private TreeViewer createViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite, 2820);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        gridData.heightHint = this.convertHeightInCharsToPixels(15);
        treeViewer.getTree().setLayoutData((Object)gridData);
        treeViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(256));
        treeViewer.setContentProvider((IContentProvider)new DestinationContentProvider(this.getDestinationValidator()));
        treeViewer.setComparator((ViewerComparator)new JavaElementComparator());
        treeViewer.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        return treeViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.fViewer;
    }
}

