/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypedSource;

public class TypedSourceTransfer
extends ByteArrayTransfer {
    private static final TypedSourceTransfer fgInstance = new TypedSourceTransfer();
    private static final String TYPE_NAME = "typed-source-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)fgInstance)).hashCode();
    private static final int TYPEID = TypedSourceTransfer.registerType((String)TYPE_NAME);

    private TypedSourceTransfer() {
    }

    public static TypedSourceTransfer getInstance() {
        return fgInstance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof TypedSource[])) {
            return;
        }
        TypedSource[] typedSourceArray = (TypedSource[])object;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(typedSourceArray.length);
            int n = 0;
            while (n < typedSourceArray.length) {
                TypedSourceTransfer.writeJavaElement(dataOutputStream, typedSourceArray[n]);
                ++n;
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            super.javaToNative((Object)byteArrayOutputStream.toByteArray(), transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] byArray = (byte[])super.nativeToJava(transferData);
        if (byArray == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            int n = dataInputStream.readInt();
            TypedSource[] typedSourceArray = new TypedSource[n];
            int n2 = 0;
            while (n2 < n) {
                typedSourceArray[n2] = TypedSourceTransfer.readJavaElement(dataInputStream);
                Assert.isNotNull((Object)typedSourceArray[n2]);
                ++n2;
            }
            dataInputStream.close();
            return typedSourceArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static TypedSource readJavaElement(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        return TypedSource.create(string, n);
    }

    private static void writeJavaElement(DataOutputStream dataOutputStream, TypedSource typedSource) throws IOException {
        dataOutputStream.writeInt(typedSource.getType());
        dataOutputStream.writeUTF(typedSource.getSource());
    }
}

