/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public abstract class FindOccurrencesEngine {
    private IOccurrencesFinder fFinder;

    protected FindOccurrencesEngine(IOccurrencesFinder iOccurrencesFinder) {
        this.fFinder = iOccurrencesFinder;
    }

    public static FindOccurrencesEngine create(IJavaElement iJavaElement, IOccurrencesFinder iOccurrencesFinder) {
        if (iJavaElement == null || iOccurrencesFinder == null) {
            return null;
        }
        ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
        if (iCompilationUnit != null) {
            return new FindOccurencesCUEngine(iCompilationUnit, iOccurrencesFinder);
        }
        IClassFile iClassFile = (IClassFile)iJavaElement.getAncestor(6);
        if (iClassFile != null) {
            return new FindOccurencesClassFileEngine(iClassFile, iOccurrencesFinder);
        }
        return null;
    }

    protected abstract CompilationUnit createAST();

    protected abstract IJavaElement getInput();

    protected abstract ISourceReference getSourceReference();

    protected IOccurrencesFinder getOccurrencesFinder() {
        return this.fFinder;
    }

    public String run(int n, int n2) throws JavaModelException {
        ISourceReference iSourceReference = this.getSourceReference();
        if (iSourceReference.getSourceRange() == null) {
            return SearchMessages.FindOccurrencesEngine_noSource_text;
        }
        CompilationUnit compilationUnit = this.createAST();
        if (compilationUnit == null) {
            return SearchMessages.FindOccurrencesEngine_cannotParse_text;
        }
        String string = this.fFinder.initialize(compilationUnit, n, n2);
        if (string != null) {
            return string;
        }
        Document document = new Document(this.getSourceReference().getSource());
        this.performNewSearch(this.fFinder, (IDocument)document, this.getInput());
        return null;
    }

    private void performNewSearch(IOccurrencesFinder iOccurrencesFinder, IDocument iDocument, IJavaElement iJavaElement) {
        NewSearchUI.runQueryInBackground((ISearchQuery)new OccurrencesSearchQuery(iOccurrencesFinder, iDocument, iJavaElement));
    }

    private static class FindOccurencesCUEngine
    extends FindOccurrencesEngine {
        private ICompilationUnit fCUnit;

        public FindOccurencesCUEngine(ICompilationUnit iCompilationUnit, IOccurrencesFinder iOccurrencesFinder) {
            super(iOccurrencesFinder);
            this.fCUnit = iCompilationUnit;
        }

        protected CompilationUnit createAST() {
            return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCUnit, ASTProvider.WAIT_YES, null);
        }

        protected IJavaElement getInput() {
            return this.fCUnit;
        }

        protected ISourceReference getSourceReference() {
            return this.fCUnit;
        }
    }

    private static class FindOccurencesClassFileEngine
    extends FindOccurrencesEngine {
        private IClassFile fClassFile;

        public FindOccurencesClassFileEngine(IClassFile iClassFile, IOccurrencesFinder iOccurrencesFinder) {
            super(iOccurrencesFinder);
            this.fClassFile = iClassFile;
        }

        protected CompilationUnit createAST() {
            return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fClassFile, ASTProvider.WAIT_YES, null);
        }

        protected IJavaElement getInput() {
            return this.fClassFile;
        }

        protected ISourceReference getSourceReference() {
            return this.fClassFile;
        }
    }
}

