/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.PatternStrings;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class JavaSearchPage
extends DialogPage
implements ISearchPage {
    private static final int TYPE = 0;
    private static final int METHOD = 1;
    private static final int CONSTRUCTOR = 3;
    private static final int FIELD = 4;
    private static final int VAR = 12;
    private static final int FUNCTION = 13;
    private static final int DECLARATIONS = 0;
    private static final int REFERENCES = 2;
    private static final int ALL_OCCURRENCES = 3;
    private static final int READ_ACCESSES = 4;
    private static final int WRITE_ACCESSES = 5;
    public static final String PARTICIPANT_EXTENSION_POINT = "org.eclipse.wst.jsdt.ui.queryParticipants";
    public static final String EXTENSION_POINT_ID = "org.eclipse.wst.jsdt.ui.JavaSearchPage";
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "JavaSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_INCLUDE_MASK = "INCLUDE_MASK";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private final List fPreviousSearchPatterns = new ArrayList();
    private SearchPatternData fInitialData;
    private IJavaElement fJavaElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private Button[] fSearchFor;
    private Button[] fLimitTo;
    private Button[] fIncludeMasks;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean performAction() {
        return this.performNewSearch();
    }

    private boolean performNewSearch() {
        Object object;
        Object object2;
        SearchPatternData searchPatternData = this.getPatternData();
        IJavaSearchScope iJavaSearchScope = null;
        String string = "";
        int n = searchPatternData.getSearchFor();
        int n2 = searchPatternData.getLimitTo();
        int n3 = searchPatternData.getIncludeMask();
        JavaSearchScopeFactory javaSearchScopeFactory = JavaSearchScopeFactory.getInstance();
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                string = javaSearchScopeFactory.getWorkspaceScopeDescription(n3);
                iJavaSearchScope = javaSearchScopeFactory.createWorkspaceScope(n3);
                break;
            }
            case 1: {
                object2 = javaSearchScopeFactory.getJavaElements(this.getContainer().getSelection());
                iJavaSearchScope = javaSearchScopeFactory.createJavaSearchScope((IJavaElement[])object2, n3);
                string = javaSearchScopeFactory.getSelectionScopeDescription((IJavaElement[])object2, n3);
                break;
            }
            case 3: {
                object = this.getContainer().getSelectedProjectNames();
                iJavaSearchScope = javaSearchScopeFactory.createJavaProjectSearchScope((String[])object, n3);
                string = javaSearchScopeFactory.getProjectScopeDescription((String[])object, n3);
                break;
            }
            case 2: {
                object = this.getContainer().getSelectedWorkingSets();
                if (object == null || ((String[])object).length < 1) {
                    return false;
                }
                string = javaSearchScopeFactory.getWorkingSetScopeDescription((IWorkingSet[])object, n3);
                iJavaSearchScope = javaSearchScopeFactory.createJavaSearchScope((IWorkingSet[])object, n3);
                SearchUtil.updateLRUWorkingSets((IWorkingSet[])object);
            }
        }
        object2 = null;
        if (searchPatternData.getJavaElement() != null && this.getPattern().equals(this.fInitialData.getPattern())) {
            if (n2 == 2) {
                SearchUtil.warnIfBinaryConstant(searchPatternData.getJavaElement(), this.getShell());
            }
            object2 = new ElementQuerySpecification(searchPatternData.getJavaElement(), n2, iJavaSearchScope, string);
        } else {
            object2 = new PatternQuerySpecification(searchPatternData.getPattern(), n, searchPatternData.isCaseSensitive(), searchPatternData.getLimitTo(), iJavaSearchScope, string);
            searchPatternData.setJavaElement(null);
        }
        object = new JavaSearchQuery((QuerySpecification)object2);
        NewSearchUI.runQueryInBackground((ISearchQuery)object);
        return true;
    }

    private int getLimitTo() {
        int n = 0;
        while (n < this.fLimitTo.length) {
            Button button = this.fLimitTo[n];
            if (button.getSelection()) {
                return this.getIntData(button);
            }
            ++n;
        }
        return -1;
    }

    private int setLimitTo(int n, int n2) {
        if (n != 4 && n != 12 && (n2 == 4 || n2 == 5)) {
            n2 = 2;
        }
        int n3 = 0;
        while (n3 < this.fLimitTo.length) {
            Button button;
            int n4 = this.getIntData(button = this.fLimitTo[n3]);
            button.setSelection(n2 == n4);
            switch (n4) {
                case 0: 
                case 2: 
                case 3: {
                    button.setEnabled(true);
                    break;
                }
                case 4: 
                case 5: {
                    button.setEnabled(n == 4 || n == 12);
                }
            }
            ++n3;
        }
        return n2;
    }

    private int getIncludeMask() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fIncludeMasks.length) {
            Button button = this.fIncludeMasks[n2];
            if (button.getSelection()) {
                n |= this.getIntData(button);
            }
            ++n2;
        }
        return n;
    }

    private void setIncludeMask(int n, int n2) {
        int n3 = 0;
        while (n3 < this.fIncludeMasks.length) {
            Button button;
            button.setSelection((n & this.getIntData(button = this.fIncludeMasks[n3])) != 0);
            ++n3;
        }
    }

    private String[] getPreviousSearchPatterns() {
        int n = this.fPreviousSearchPatterns.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((SearchPatternData)this.fPreviousSearchPatterns.get(n2)).getPattern();
            ++n2;
        }
        return stringArray;
    }

    private int getSearchFor() {
        int n = 0;
        while (n < this.fSearchFor.length) {
            Button button = this.fSearchFor[n];
            if (button.getSelection()) {
                return this.getIntData(button);
            }
            ++n;
        }
        Assert.isTrue((boolean)false, (String)"shouldNeverHappen");
        return -1;
    }

    private void setSearchFor(int n) {
        int n2 = 0;
        while (n2 < this.fSearchFor.length) {
            Button button;
            button.setSelection(n == this.getIntData(button = this.fSearchFor[n2]));
            ++n2;
        }
    }

    private int getIntData(Button button) {
        return (Integer)button.getData();
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData findInPrevious(String string) {
        Iterator iterator = this.fPreviousSearchPatterns.iterator();
        while (iterator.hasNext()) {
            SearchPatternData searchPatternData = (SearchPatternData)iterator.next();
            if (!string.equals(searchPatternData.getPattern())) continue;
            return searchPatternData;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        String string = this.getPattern();
        SearchPatternData searchPatternData = this.findInPrevious(string);
        if (searchPatternData != null) {
            this.fPreviousSearchPatterns.remove(searchPatternData);
        }
        searchPatternData = new SearchPatternData(this.getSearchFor(), this.getLimitTo(), string, this.fCaseSensitive.getSelection(), this.fJavaElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets(), this.getIncludeMask());
        this.fPreviousSearchPatterns.add(0, searchPatternData);
        return searchPatternData;
    }

    public void setVisible(boolean bl) {
        if (bl && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(bl);
    }

    public boolean isValid() {
        return true;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.readConfiguration();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Control control = this.createExpression(composite2);
        control.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label label = new Label(composite2, 0);
        label.setVisible(false);
        GridData gridData = new GridData(4, 4, false, false, 2, 1);
        gridData.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        label.setLayoutData((Object)gridData);
        Control control2 = this.createSearchFor(composite2);
        control2.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control control3 = this.createLimitTo(composite2);
        control3.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control control4 = this.createIncludeMask(composite2);
        control4.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (JavaSearchPage.this.getSearchFor() == JavaSearchPage.this.fInitialData.getSearchFor()) {
                    JavaSearchPage.this.fJavaElement = JavaSearchPage.this.fInitialData.getJavaElement();
                } else {
                    JavaSearchPage.this.fJavaElement = null;
                }
                int n = JavaSearchPage.this.setLimitTo(JavaSearchPage.this.getSearchFor(), JavaSearchPage.this.getLimitTo());
                JavaSearchPage.this.setIncludeMask(JavaSearchPage.this.getIncludeMask(), n);
                JavaSearchPage.this.doPatternModified();
            }
        };
        int n = 0;
        while (n < this.fSearchFor.length) {
            this.fSearchFor[n].addSelectionListener((SelectionListener)selectionAdapter);
            ++n;
        }
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.java_search_page_context");
    }

    private Control createExpression(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(SearchMessages.SearchPage_expression_label);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.fPattern = new Combo(composite2, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaSearchPage.this.handlePatternSelected();
                JavaSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavaSearchPage.this.doPatternModified();
                JavaSearchPage.this.updateOKStatus();
            }
        });
        TextFieldNavigationHandler.install(this.fPattern);
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)gridData);
        this.fCaseSensitive = new Button(composite2, 32);
        this.fCaseSensitive.setText(SearchMessages.SearchPage_expression_caseSensitive);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaSearchPage.this.fIsCaseSensitive = JavaSearchPage.this.fCaseSensitive.getSelection();
            }
        });
        this.fCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return composite2;
    }

    final void updateOKStatus() {
        boolean bl = this.isValidSearchPattern();
        this.getContainer().setPerformActionEnabled(bl);
    }

    private boolean isValidSearchPattern() {
        if (this.getPattern().length() == 0) {
            return false;
        }
        if (this.fJavaElement != null) {
            return true;
        }
        return SearchPattern.createPattern((String)this.getPattern(), (int)this.getSearchFor(), (int)this.getLimitTo(), (int)0) != null;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private void doPatternModified() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.getPattern()) && this.fInitialData.getJavaElement() != null && this.fInitialData.getSearchFor() == this.getSearchFor()) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
            this.fJavaElement = this.fInitialData.getJavaElement();
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
            this.fJavaElement = null;
        }
    }

    private void handlePatternSelected() {
        int n = this.fPattern.getSelectionIndex();
        if (n < 0 || n >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData searchPatternData = (SearchPatternData)this.fPreviousSearchPatterns.get(n);
        this.setSearchFor(searchPatternData.getSearchFor());
        int n2 = this.setLimitTo(searchPatternData.getSearchFor(), searchPatternData.getLimitTo());
        this.setIncludeMask(searchPatternData.getIncludeMask(), n2);
        this.fPattern.setText(searchPatternData.getPattern());
        this.fIsCaseSensitive = searchPatternData.isCaseSensitive();
        this.fJavaElement = searchPatternData.getJavaElement();
        this.fCaseSensitive.setEnabled(this.fJavaElement == null);
        this.fCaseSensitive.setSelection(searchPatternData.isCaseSensitive());
        if (searchPatternData.getWorkingSets() != null) {
            this.getContainer().setSelectedWorkingSets(searchPatternData.getWorkingSets());
        } else {
            this.getContainer().setSelectedScope(searchPatternData.getScope());
        }
        this.fInitialData = searchPatternData;
    }

    private Control createSearchFor(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(SearchMessages.SearchPage_searchFor_label);
        group.setLayout((Layout)new GridLayout(2, true));
        this.fSearchFor = new Button[]{this.createButton((Composite)group, 16, SearchMessages.SearchPage_searchFor_function, 13, true), this.createButton((Composite)group, 16, SearchMessages.SearchPage_searchFor_var, 12, false), this.createButton((Composite)group, 16, SearchMessages.SearchPage_searchFor_method, 1, false), this.createButton((Composite)group, 16, SearchMessages.SearchPage_searchFor_field, 4, false), this.createButton((Composite)group, 16, SearchMessages.SearchPage_searchFor_type, 0, false), this.createButton((Composite)group, 16, SearchMessages.SearchPage_searchFor_constructor, 3, false)};
        Label label = new Label((Composite)group, 0);
        label.setVisible(false);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return group;
    }

    private Control createLimitTo(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(SearchMessages.SearchPage_limitTo_label);
        group.setLayout((Layout)new GridLayout(2, true));
        this.fLimitTo = new Button[]{this.createButton((Composite)group, 16, SearchMessages.SearchPage_limitTo_declarations, 0, false), this.createButton((Composite)group, 16, SearchMessages.SearchPage_limitTo_references, 2, true), this.createButton((Composite)group, 16, SearchMessages.SearchPage_limitTo_allOccurrences, 3, false), this.createButton((Composite)group, 16, SearchMessages.SearchPage_limitTo_readReferences, 4, false), this.createButton((Composite)group, 16, SearchMessages.SearchPage_limitTo_writeReferences, 5, false)};
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaSearchPage.this.updateUseJRE();
            }
        };
        int n = 0;
        while (n < this.fLimitTo.length) {
            this.fLimitTo[n].addSelectionListener((SelectionListener)selectionAdapter);
            ++n;
        }
        return group;
    }

    private Control createIncludeMask(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        group.setText(SearchMessages.SearchPage_searchIn_label);
        group.setLayout((Layout)new GridLayout(4, false));
        this.fIncludeMasks = new Button[]{this.createButton((Composite)group, 32, SearchMessages.SearchPage_searchIn_sources, 1, true), this.createButton((Composite)group, 32, SearchMessages.SearchPage_searchIn_projects, 8, true), this.createButton((Composite)group, 32, SearchMessages.SearchPage_searchIn_jre, 4, false), this.createButton((Composite)group, 32, SearchMessages.SearchPage_searchIn_libraries, 2, true)};
        return group;
    }

    private Button createButton(Composite composite, int n, String string, int n2, boolean bl) {
        Button button = new Button(composite, n);
        button.setText(string);
        button.setData((Object)new Integer(n2));
        button.setLayoutData((Object)new GridData());
        button.setSelection(bl);
        return button;
    }

    private void initSelections() {
        ISelection iSelection = this.getContainer().getSelection();
        SearchPatternData searchPatternData = null;
        if (iSelection instanceof IStructuredSelection) {
            searchPatternData = this.tryStructuredSelection((IStructuredSelection)iSelection);
        } else if (iSelection instanceof ITextSelection) {
            IEditorPart iEditorPart = this.getActiveEditor();
            if (iEditorPart instanceof JavaEditor) {
                try {
                    IJavaElement[] iJavaElementArray = SelectionConverter.codeResolve((JavaEditor)iEditorPart);
                    if (iJavaElementArray != null && iJavaElementArray.length > 0) {
                        searchPatternData = this.determineInitValuesFrom(iJavaElementArray[0]);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            if (searchPatternData == null) {
                searchPatternData = this.trySimpleTextSelection((ITextSelection)iSelection);
            }
        }
        if (searchPatternData == null) {
            searchPatternData = this.getDefaultInitValues();
        }
        this.fInitialData = searchPatternData;
        this.fJavaElement = searchPatternData.getJavaElement();
        this.fCaseSensitive.setSelection(searchPatternData.isCaseSensitive());
        this.fCaseSensitive.setEnabled(this.fJavaElement == null);
        this.setSearchFor(searchPatternData.getSearchFor());
        int n = this.setLimitTo(searchPatternData.getSearchFor(), searchPatternData.getLimitTo());
        this.setIncludeMask(searchPatternData.getIncludeMask(), n);
        this.fPattern.setText(searchPatternData.getPattern());
    }

    private void updateUseJRE() {
        this.setIncludeMask(this.getIncludeMask(), this.getLimitTo());
    }

    private static boolean forceIncludeAll(int n, IJavaElement iJavaElement) {
        return iJavaElement != null && n == 0;
    }

    private SearchPatternData tryStructuredSelection(IStructuredSelection iStructuredSelection) {
        IJavaElement iJavaElement;
        if (iStructuredSelection == null || iStructuredSelection.size() > 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        SearchPatternData searchPatternData = null;
        if (object instanceof IJavaElement) {
            searchPatternData = this.determineInitValuesFrom((IJavaElement)object);
        } else if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                searchPatternData = this.determineInitValuesFrom(iJavaElement);
            }
        }
        if (searchPatternData == null && object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJavaElement = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return new SearchPatternData(12, 2, this.fIsCaseSensitive, iJavaElement.getLabel(object), null, this.getLastIncludeMask());
            }
        }
        return searchPatternData;
    }

    static final boolean isSearchableType(IJavaElement iJavaElement) {
        switch (iJavaElement.getElementType()) {
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private SearchPatternData determineInitValuesFrom(IJavaElement iJavaElement) {
        block12: {
            try {
                int n = this.getLastIncludeMask();
                switch (iJavaElement.getElementType()) {
                    case 7: {
                        return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature((IType)iJavaElement), iJavaElement, n);
                    }
                    case 5: {
                        IType iType = ((ICompilationUnit)iJavaElement).findPrimaryType();
                        if (iType != null) {
                            return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature(iType), (IJavaElement)iType, n);
                        }
                        break;
                    }
                    case 6: {
                        IType iType = ((IClassFile)iJavaElement).getType();
                        if (iType.exists()) {
                            return new SearchPatternData(0, 2, true, PatternStrings.getTypeSignature(iType), (IJavaElement)iType, n);
                        }
                        break;
                    }
                    case 8: {
                        IField iField = (IField)iJavaElement;
                        return new SearchPatternData(iField.getParent().getElementType() == 7 ? 4 : 12, 2, true, PatternStrings.getFieldSignature(iField), iJavaElement, n);
                    }
                    case 9: {
                        int n2;
                        IMethod iMethod = (IMethod)iJavaElement;
                        int n3 = n2 = iMethod.isConstructor() ? 3 : 1;
                        if (iMethod.getParent().getElementType() != 7) {
                            n2 = 13;
                        }
                        return new SearchPatternData(n2, 2, true, PatternStrings.getMethodSignature(iMethod), iJavaElement, n);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                if (javaModelException.isDoesNotExist()) break block12;
                ExceptionHandler.handle((CoreException)((Object)javaModelException), SearchMessages.Search_Error_javaElementAccess_title, SearchMessages.Search_Error_javaElementAccess_message);
            }
        }
        return null;
    }

    private SearchPatternData trySimpleTextSelection(ITextSelection iTextSelection) {
        String string = iTextSelection.getText();
        if (string != null && string.length() > 0) {
            int n = 0;
            while (n < string.length() && !IndentManipulation.isLineDelimiterChar((char)string.charAt(n))) {
                ++n;
            }
            if (n > 0) {
                return new SearchPatternData(0, 2, this.fIsCaseSensitive, string.substring(0, n), null, 15);
            }
        }
        return null;
    }

    private SearchPatternData getDefaultInitValues() {
        if (!this.fPreviousSearchPatterns.isEmpty()) {
            return (SearchPatternData)this.fPreviousSearchPatterns.get(0);
        }
        return new SearchPatternData(0, 2, this.fIsCaseSensitive, "", null, this.getLastIncludeMask());
    }

    private int getLastIncludeMask() {
        try {
            return this.getDialogSettings().getInt(STORE_INCLUDE_MASK);
        }
        catch (NumberFormatException numberFormatException) {
            return 11;
        }
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.fContainer = iSearchPageContainer;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage.getActiveEditor();
        }
        return null;
    }

    private IDialogSettings getDialogSettings() {
        if (this.fDialogSettings == null) {
            this.fDialogSettings = JavaPlugin.getDefault().getDialogSettingsSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        this.fIsCaseSensitive = iDialogSettings.getBoolean(STORE_CASE_SENSITIVE);
        try {
            int n = iDialogSettings.getInt(STORE_HISTORY_SIZE);
            int n2 = 0;
            while (n2 < n) {
                SearchPatternData searchPatternData;
                IDialogSettings iDialogSettings2 = iDialogSettings.getSection(STORE_HISTORY + n2);
                if (iDialogSettings2 != null && (searchPatternData = SearchPatternData.create(iDialogSettings2)) != null) {
                    this.fPreviousSearchPatterns.add(searchPatternData);
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        iDialogSettings.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        iDialogSettings.put(STORE_INCLUDE_MASK, this.getIncludeMask());
        int n = Math.min(this.fPreviousSearchPatterns.size(), 12);
        iDialogSettings.put(STORE_HISTORY_SIZE, n);
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings iDialogSettings2 = iDialogSettings.addNewSection(STORE_HISTORY + n2);
            SearchPatternData searchPatternData = (SearchPatternData)this.fPreviousSearchPatterns.get(n2);
            searchPatternData.store(iDialogSettings2);
            ++n2;
        }
    }

    private static class SearchPatternData {
        private int searchFor;
        private int limitTo;
        private String pattern;
        private boolean isCaseSensitive;
        private IJavaElement javaElement;
        private int includeMask;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchPatternData(int n, int n2, boolean bl, String string, IJavaElement iJavaElement, int n3) {
            this(n, n2, string, bl, iJavaElement, 0, null, n3);
        }

        public SearchPatternData(int n, int n2, String string, boolean bl, IJavaElement iJavaElement, int n3, IWorkingSet[] iWorkingSetArray, int n4) {
            this.searchFor = n;
            this.limitTo = n2;
            this.pattern = string;
            this.isCaseSensitive = bl;
            this.scope = n3;
            this.workingSets = iWorkingSetArray;
            this.includeMask = n4;
            this.setJavaElement(iJavaElement);
        }

        public void setJavaElement(IJavaElement iJavaElement) {
            this.javaElement = iJavaElement;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public IJavaElement getJavaElement() {
            return this.javaElement;
        }

        public int getLimitTo() {
            return this.limitTo;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getScope() {
            return this.scope;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public int getIncludeMask() {
            return this.includeMask;
        }

        public void store(IDialogSettings iDialogSettings) {
            iDialogSettings.put("searchFor", this.searchFor);
            iDialogSettings.put("scope", this.scope);
            iDialogSettings.put("pattern", this.pattern);
            iDialogSettings.put("limitTo", this.limitTo);
            iDialogSettings.put("javaElement", this.javaElement != null ? this.javaElement.getHandleIdentifier() : "");
            iDialogSettings.put("isCaseSensitive", this.isCaseSensitive);
            if (this.workingSets != null) {
                String[] stringArray = new String[this.workingSets.length];
                int n = 0;
                while (n < this.workingSets.length) {
                    stringArray[n] = this.workingSets[n].getName();
                    ++n;
                }
                iDialogSettings.put("workingSets", stringArray);
            } else {
                iDialogSettings.put("workingSets", new String[0]);
            }
            iDialogSettings.put("includeMask", this.includeMask);
        }

        public static SearchPatternData create(IDialogSettings iDialogSettings) {
            int n;
            IJavaElement iJavaElement;
            String string = iDialogSettings.get("pattern");
            if (string.length() == 0) {
                return null;
            }
            IJavaElement iJavaElement2 = null;
            String string2 = iDialogSettings.get("javaElement");
            if (string2 != null && string2.length() > 0 && (iJavaElement = JavaCore.create((String)string2)) != null && JavaSearchPage.isSearchableType(iJavaElement) && iJavaElement.exists()) {
                iJavaElement2 = iJavaElement;
            }
            iJavaElement = iDialogSettings.getArray("workingSets");
            IWorkingSet[] iWorkingSetArray = null;
            if (iJavaElement != null && ((IJavaElement)iJavaElement).length > 0) {
                IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                iWorkingSetArray = new IWorkingSet[((IJavaElement)iJavaElement).length];
                n = 0;
                while (iWorkingSetArray != null && n < ((IJavaElement)iJavaElement).length) {
                    iWorkingSetArray[n] = iWorkingSetManager.getWorkingSet((String)iJavaElement[n]);
                    if (iWorkingSetArray[n] == null) {
                        iWorkingSetArray = null;
                    }
                    ++n;
                }
            }
            try {
                int n2;
                int n3 = iDialogSettings.getInt("searchFor");
                n = iDialogSettings.getInt("scope");
                int n4 = iDialogSettings.getInt("limitTo");
                boolean bl = iDialogSettings.getBoolean("isCaseSensitive");
                if (iDialogSettings.get("includeMask") != null) {
                    n2 = iDialogSettings.getInt("includeMask");
                } else {
                    n2 = 11;
                    if (iDialogSettings.get("includeJRE") == null ? JavaSearchPage.forceIncludeAll(n4, iJavaElement2) : iDialogSettings.getBoolean("includeJRE")) {
                        n2 = 15;
                    }
                }
                return new SearchPatternData(n3, n4, string, bl, iJavaElement2, n, iWorkingSetArray, n2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

