/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementMatch;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;

public abstract class SearchLabelProvider
extends AppearanceAwareLabelProvider {
    public static final String PROPERTY_MATCH_COUNT = "org.eclipse.wst.jsdt.search.matchCount";
    private static final String EMPHASIZE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.emphasize";
    private static final String POTENTIAL_MATCH_FG_COLOR = "org.eclipse.search.potentialMatch.fgColor";
    protected static final long DEFAULT_SEARCH_TEXTFLAGS = 36421324767241L;
    protected static final int DEFAULT_SEARCH_IMAGEFLAGS = 1;
    private Color fPotentialMatchFgColor;
    private Map fLabelProviderMap;
    protected JavaSearchResultPage fPage;
    private ScopedPreferenceStore fSearchPreferences;
    private IPropertyChangeListener fSearchPropertyListener;

    public SearchLabelProvider(JavaSearchResultPage javaSearchResultPage) {
        super(36421324767241L, 1);
        this.addLabelDecorator(new ProblemsLabelDecorator(null));
        this.fPage = javaSearchResultPage;
        this.fLabelProviderMap = new HashMap(5);
        this.fSearchPreferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.search");
        this.fSearchPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SearchLabelProvider.this.doSearchPropertyChange(propertyChangeEvent);
            }
        };
        this.fSearchPreferences.addPropertyChangeListener(this.fSearchPropertyListener);
    }

    final void doSearchPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fPotentialMatchFgColor == null) {
            return;
        }
        if (POTENTIAL_MATCH_FG_COLOR.equals(propertyChangeEvent.getProperty()) || EMPHASIZE_POTENTIAL_MATCHES.equals(propertyChangeEvent.getProperty())) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
            LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
            this.fireLabelProviderChanged(labelProviderChangedEvent);
        }
    }

    public Color getForeground(Object object) {
        if (this.arePotentialMatchesEmphasized() && this.getNumberOfPotentialMatches(object) > 0) {
            return this.getForegroundColor();
        }
        return super.getForeground(object);
    }

    private Color getForegroundColor() {
        if (this.fPotentialMatchFgColor == null) {
            this.fPotentialMatchFgColor = new Color((Device)JavaPlugin.getActiveWorkbenchShell().getDisplay(), this.getPotentialMatchForegroundColor());
        }
        return this.fPotentialMatchFgColor;
    }

    protected final int getNumberOfPotentialMatches(Object object) {
        int n = 0;
        AbstractTextSearchResult abstractTextSearchResult = this.fPage.getInput();
        if (abstractTextSearchResult != null) {
            Match[] matchArray = abstractTextSearchResult.getMatches(object);
            int n2 = 0;
            while (n2 < matchArray.length) {
                if (matchArray[n2] instanceof JavaElementMatch && ((JavaElementMatch)matchArray[n2]).getAccuracy() == 1) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    protected final ColoredString getColoredLabelWithCounts(Object object, ColoredString coloredString) {
        String string = coloredString.getString();
        String string2 = this.getLabelWithCounts(object, string);
        if (string2.length() > string.length()) {
            ColoredJavaElementLabels.decorateColoredString(coloredString, string2, ColoredJavaElementLabels.COUNTER_STYLE);
        }
        return coloredString;
    }

    protected final String getLabelWithCounts(Object object, String string) {
        int n = this.fPage.getDisplayedMatchCount(object);
        int n2 = this.getNumberOfPotentialMatches(object);
        if (n < 2) {
            if (n == 1 && this.hasChildren(object)) {
                if (n2 > 0) {
                    return Messages.format(SearchMessages.SearchLabelProvider_potential_singular, string);
                }
                return Messages.format(SearchMessages.SearchLabelProvider_exact_singular, string);
            }
            if (n2 > 0) {
                return Messages.format(SearchMessages.SearchLabelProvider_potential_noCount, string);
            }
            return Messages.format(SearchMessages.SearchLabelProvider_exact_noCount, string);
        }
        int n3 = n - n2;
        if (n2 > 0 && n3 > 0) {
            Object[] objectArray = new String[]{string, String.valueOf(n), String.valueOf(n3), String.valueOf(n2)};
            return Messages.format(SearchMessages.SearchLabelProvider_exact_and_potential_plural, objectArray);
        }
        if (n3 == 0) {
            Object[] objectArray = new String[]{string, String.valueOf(n)};
            return Messages.format(SearchMessages.SearchLabelProvider_potential_plural, objectArray);
        }
        Object[] objectArray = new String[]{string, String.valueOf(n)};
        return Messages.format(SearchMessages.SearchLabelProvider_exact_plural, objectArray);
    }

    protected boolean hasChildren(Object object) {
        return false;
    }

    public void dispose() {
        if (this.fPotentialMatchFgColor != null) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
        }
        this.fSearchPreferences.removePropertyChangeListener(this.fSearchPropertyListener);
        Iterator iterator = this.fLabelProviderMap.values().iterator();
        while (iterator.hasNext()) {
            ILabelProvider iLabelProvider = (ILabelProvider)iterator.next();
            iLabelProvider.dispose();
        }
        this.fSearchPreferences = null;
        this.fSearchPropertyListener = null;
        this.fLabelProviderMap.clear();
        super.dispose();
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        super.addListener(iLabelProviderListener);
        Iterator iterator = this.fLabelProviderMap.values().iterator();
        while (iterator.hasNext()) {
            ILabelProvider iLabelProvider = (ILabelProvider)iterator.next();
            iLabelProvider.addListener(iLabelProviderListener);
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        if (PROPERTY_MATCH_COUNT.equals(string)) {
            return true;
        }
        return this.getLabelProvider(object).isLabelProperty(object, string);
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        super.removeListener(iLabelProviderListener);
        Iterator iterator = this.fLabelProviderMap.values().iterator();
        while (iterator.hasNext()) {
            ILabelProvider iLabelProvider = (ILabelProvider)iterator.next();
            iLabelProvider.removeListener(iLabelProviderListener);
        }
    }

    protected String getParticipantText(Object object) {
        ILabelProvider iLabelProvider = this.getLabelProvider(object);
        if (iLabelProvider != null) {
            return iLabelProvider.getText(object);
        }
        return "";
    }

    protected Image getParticipantImage(Object object) {
        ILabelProvider iLabelProvider = this.getLabelProvider(object);
        if (iLabelProvider == null) {
            return null;
        }
        return iLabelProvider.getImage(object);
    }

    private ILabelProvider getLabelProvider(Object object) {
        IMatchPresentation iMatchPresentation = ((JavaSearchResult)this.fPage.getInput()).getSearchParticpant(object);
        if (iMatchPresentation == null) {
            return null;
        }
        ILabelProvider iLabelProvider = (ILabelProvider)this.fLabelProviderMap.get(iMatchPresentation);
        if (iLabelProvider == null) {
            iLabelProvider = iMatchPresentation.createLabelProvider();
            this.fLabelProviderMap.put(iMatchPresentation, iLabelProvider);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                iLabelProvider.addListener((ILabelProviderListener)objectArray[n]);
                ++n;
            }
        }
        return iLabelProvider;
    }

    private boolean arePotentialMatchesEmphasized() {
        return this.fSearchPreferences.getBoolean(EMPHASIZE_POTENTIAL_MATCHES);
    }

    private RGB getPotentialMatchForegroundColor() {
        return PreferenceConverter.getColor((IPreferenceStore)this.fSearchPreferences, (String)POTENTIAL_MATCH_FG_COLOR);
    }
}

