/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.SourceViewerInformationControl;

class ChangeHoverInformationControl
extends SourceViewerInformationControl {
    private static final String SYMBOLIC_FONT_NAME = "org.eclipse.wst.jsdt.ui.editors.textfont";
    int fMaxWidth = Integer.MAX_VALUE;
    int fMaxHeight = Integer.MAX_VALUE;
    private String fPartition;
    private int fHorizontalScrollPixel;

    public void setSizeConstraints(int n, int n2) {
        this.fMaxWidth = n;
        this.fMaxHeight = n2;
    }

    public ChangeHoverInformationControl(Shell shell, int n, int n2, String string, String string2) {
        super(shell, n, n2, string2);
        this.setViewerFont();
        this.setStartingPartitionType(string);
    }

    public Point computeSizeHint() {
        Point point = super.computeSizeHint();
        point.x = Math.min(point.x, this.fMaxWidth);
        point.y = Math.min(point.y, this.fMaxHeight);
        return point;
    }

    private void setViewerFont() {
        Font font = JFaceResources.getFont((String)SYMBOLIC_FONT_NAME);
        if (this.getViewer().getDocument() != null) {
            ITextViewerExtension iTextViewerExtension;
            StyledText styledText;
            Point point = this.getViewer().getSelectedRange();
            int n = this.getViewer().getTopIndex();
            StyledText styledText2 = styledText = this.getViewer().getTextWidget();
            if (this.getViewer() instanceof ITextViewerExtension) {
                iTextViewerExtension = (ITextViewerExtension)this.getViewer();
                styledText2 = iTextViewerExtension.getControl();
            }
            styledText2.setRedraw(false);
            styledText.setFont(font);
            this.getViewer().setSelectedRange(point.x, point.y);
            this.getViewer().setTopIndex(n);
            if (styledText2 instanceof Composite) {
                iTextViewerExtension = (Composite)styledText2;
                iTextViewerExtension.layout(true);
            }
            styledText2.setRedraw(true);
        } else {
            StyledText styledText = this.getViewer().getTextWidget();
            styledText.setFont(font);
        }
    }

    public void setStartingPartitionType(String string) {
        this.fPartition = string == null ? "__dftl_partition_content_type" : string;
    }

    public void setInformation(String string) {
        super.setInformation(string);
        IDocument iDocument = this.getViewer().getDocument();
        if (iDocument == null) {
            return;
        }
        this.ensureScrollable();
        String string2 = null;
        if ("__java_javadoc".equals(this.fPartition)) {
            string2 = "/**" + iDocument.getLegalLineDelimiters()[0];
        } else if ("__java_multiline_comment".equals(this.fPartition)) {
            string2 = "/*" + iDocument.getLegalLineDelimiters()[0];
        }
        if (string2 != null) {
            try {
                iDocument.replace(0, 0, string2);
                int n = string2.length();
                this.getViewer().setDocument(iDocument, n, iDocument.getLength() - n);
            }
            catch (BadLocationException badLocationException) {
                Assert.isTrue((boolean)false);
            }
        }
        this.getViewer().getTextWidget().setHorizontalPixel(this.fHorizontalScrollPixel);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ensureScrollable() {
        IDocument iDocument = this.getViewer().getDocument();
        if (iDocument == null) {
            return;
        }
        StyledText styledText = this.getViewer().getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        int n = iDocument.getNumberOfLines() - 1;
        GC gC = new GC((Drawable)styledText);
        gC.setFont(styledText.getFont());
        int n2 = 0;
        String string = new String();
        try {
            try {
                int n3 = 0;
                while (n3 <= n) {
                    IRegion iRegion = iDocument.getLineInformation(n3);
                    string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                    int n4 = gC.textExtent((String)string).x;
                    if (n4 > n2) {
                        n2 = n4;
                    }
                    ++n3;
                }
            }
            catch (BadLocationException badLocationException) {
                Object var10_10 = null;
                gC.dispose();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            gC.dispose();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        gC.dispose();
        this.fMaxWidth = Math.max(0, Math.min(this.fMaxWidth, n2 - this.fHorizontalScrollPixel + 8));
    }

    public boolean hasContents() {
        return super.hasContents() && this.fMaxWidth > 0;
    }

    public void setHorizontalScrollPixel(int n) {
        this.fHorizontalScrollPixel = n = Math.max(0, n);
    }
}

