/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.internal.ui.text.ITypingRunListener;
import org.eclipse.wst.jsdt.internal.ui.text.TypingRun;
import org.eclipse.wst.jsdt.internal.ui.text.TypingRunDetector;

public class SmartBackspaceManager {
    private ITextViewer fViewer;
    private BackspaceListener fBackspaceListener;
    private Map fSpecs;
    private TypingRunDetector fRunDetector;
    private ITypingRunListener fRunListener;

    public void register(UndoSpec undoSpec) {
        if (this.fViewer == null) {
            throw new IllegalStateException();
        }
        this.ensureListenerInstalled();
        this.addEdit(undoSpec);
    }

    private void addEdit(UndoSpec undoSpec) {
        Integer n = new Integer(undoSpec.triggerOffset);
        this.fSpecs.put(n, undoSpec);
    }

    private UndoSpec removeEdit(int n) {
        Integer n2 = new Integer(n);
        UndoSpec undoSpec = (UndoSpec)this.fSpecs.remove(n2);
        return undoSpec;
    }

    private void ensureListenerInstalled() {
        if (this.fBackspaceListener == null) {
            this.fBackspaceListener = new BackspaceListener();
            ITextViewer iTextViewer = this.fViewer;
            if (iTextViewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)iTextViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBackspaceListener);
            } else {
                iTextViewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this.fBackspaceListener);
            }
        }
    }

    private void ensureListenerRemoved() {
        if (this.fBackspaceListener != null) {
            ITextViewer iTextViewer = this.fViewer;
            if (iTextViewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)iTextViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBackspaceListener);
            } else {
                iTextViewer.getTextWidget().removeVerifyKeyListener((VerifyKeyListener)this.fBackspaceListener);
            }
            this.fBackspaceListener = null;
        }
    }

    private IDocument getDocument() {
        return this.fViewer.getDocument();
    }

    public void install(ITextViewer iTextViewer) {
        Assert.isLegal((iTextViewer != null ? 1 : 0) != 0);
        this.fViewer = iTextViewer;
        this.fSpecs = new HashMap();
        this.fRunDetector = new TypingRunDetector();
        this.fRunDetector.install(iTextViewer);
        this.fRunListener = new ITypingRunListener(){

            public void typingRunStarted(TypingRun typingRun) {
            }

            public void typingRunEnded(TypingRun typingRun, TypingRun.ChangeType changeType) {
                if (changeType == TypingRun.SELECTION) {
                    SmartBackspaceManager.this.fSpecs.clear();
                } else {
                    SmartBackspaceManager.this.prune();
                }
            }
        };
        this.fRunDetector.addTypingRunListener(this.fRunListener);
    }

    private void prune() {
        Iterator iterator = this.fSpecs.values().iterator();
        while (iterator.hasNext()) {
            UndoSpec undoSpec = (UndoSpec)iterator.next();
            if (--undoSpec.lives >= 0) continue;
            iterator.remove();
        }
    }

    public void uninstall() {
        if (this.fViewer != null) {
            this.fRunDetector.removeTypingRunListener(this.fRunListener);
            this.fRunDetector.uninstall();
            this.fRunDetector = null;
            this.ensureListenerRemoved();
            this.fViewer = null;
        }
    }

    private class BackspaceListener
    implements VerifyKeyListener {
        private BackspaceListener() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void verifyKey(VerifyEvent verifyEvent) {
            int n;
            UndoSpec undoSpec;
            if (SmartBackspaceManager.this.fViewer == null || !this.isBackspace(verifyEvent) || (undoSpec = SmartBackspaceManager.this.removeEdit(n = this.getCaretOffset())) == null) return;
            try {
                try {
                    this.beginChange();
                    int n2 = 0;
                    while (true) {
                        if (n2 >= undoSpec.undoEdits.length) {
                            SmartBackspaceManager.this.fViewer.setSelectedRange(undoSpec.selection.getOffset(), undoSpec.selection.getLength());
                            if (undoSpec.child != null) {
                                SmartBackspaceManager.this.register(undoSpec.child);
                            }
                            break;
                        }
                        undoSpec.undoEdits[n2].apply(SmartBackspaceManager.this.getDocument(), 2);
                        ++n2;
                    }
                }
                catch (MalformedTreeException malformedTreeException) {
                    block10: {
                        break block10;
                        catch (BadLocationException badLocationException) {}
                    }
                    Object var5_5 = null;
                    this.endChange();
                    return;
                }
                Object var5_7 = null;
                this.endChange();
                verifyEvent.doit = false;
                return;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.endChange();
                throw throwable;
            }
        }

        private void beginChange() {
            ITextViewer iTextViewer = SmartBackspaceManager.this.fViewer;
            if (iTextViewer instanceof TextViewer) {
                TextViewer textViewer = (TextViewer)iTextViewer;
                textViewer.getRewriteTarget().beginCompoundChange();
            }
        }

        private void endChange() {
            ITextViewer iTextViewer = SmartBackspaceManager.this.fViewer;
            if (iTextViewer instanceof TextViewer) {
                TextViewer textViewer = (TextViewer)iTextViewer;
                textViewer.getRewriteTarget().endCompoundChange();
            }
        }

        private boolean isBackspace(VerifyEvent verifyEvent) {
            return verifyEvent.doit && verifyEvent.character == '\b' && verifyEvent.stateMask == 0;
        }

        private int getCaretOffset() {
            ITextViewer iTextViewer = SmartBackspaceManager.this.fViewer;
            Point point = iTextViewer.getSelectedRange();
            return point.x;
        }
    }

    public static final class UndoSpec {
        private final int triggerOffset;
        private final IRegion selection;
        private final TextEdit[] undoEdits;
        private final UndoSpec child;
        int lives;

        public UndoSpec(int n, IRegion iRegion, TextEdit[] textEditArray, int n2, UndoSpec undoSpec) {
            Assert.isLegal((n >= 0 ? 1 : 0) != 0);
            Assert.isLegal((iRegion != null ? 1 : 0) != 0);
            Assert.isLegal((n2 >= 0 ? 1 : 0) != 0);
            Assert.isLegal((textEditArray != null ? 1 : 0) != 0);
            Assert.isLegal((textEditArray.length > 0 ? 1 : 0) != 0);
            int n3 = 0;
            while (n3 < textEditArray.length) {
                Assert.isLegal((textEditArray[n3] != null ? 1 : 0) != 0);
                ++n3;
            }
            this.triggerOffset = n;
            this.selection = iRegion;
            this.undoEdits = textEditArray;
            this.lives = n2;
            this.child = undoSpec;
        }
    }
}

