/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CUCorrectionProposal;

public class ASTRewriteCorrectionProposal
extends CUCorrectionProposal {
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;

    public ASTRewriteCorrectionProposal(String string, ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, int n, Image image) {
        super(string, iCompilationUnit, n, image);
        this.fRewrite = aSTRewrite;
    }

    public ImportRewrite getImportRewrite() {
        return this.fImportRewrite;
    }

    public void setImportRewrite(ImportRewrite importRewrite) {
        this.fImportRewrite = importRewrite;
    }

    public ImportRewrite createImportRewrite(CompilationUnit compilationUnit) {
        this.fImportRewrite = StubUtility.createImportRewrite(compilationUnit, true);
        return this.fImportRewrite;
    }

    protected void addEdits(IDocument iDocument, TextEdit textEdit) throws CoreException {
        super.addEdits(iDocument, textEdit);
        ASTRewrite aSTRewrite = this.getRewrite();
        if (aSTRewrite != null) {
            try {
                TextEdit textEdit2 = aSTRewrite.rewriteAST();
                textEdit.addChild(textEdit2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CoreException(JavaUIStatus.createError(4, illegalArgumentException));
            }
        }
        if (this.fImportRewrite != null) {
            textEdit.addChild(this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fRewrite == null) {
            IStatus iStatus = JavaUIStatus.createError(4, "Rewriter not initialized", null);
            throw new CoreException(iStatus);
        }
        return this.fRewrite;
    }
}

