/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class AssistContext
implements IInvocationContext {
    private ICompilationUnit fCompilationUnit;
    private int fOffset;
    private int fLength;
    private CompilationUnit fASTRoot;

    public AssistContext(ICompilationUnit iCompilationUnit, int n, int n2) {
        this.fCompilationUnit = iCompilationUnit;
        this.fOffset = n;
        this.fLength = n2;
        this.fASTRoot = null;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public int getSelectionLength() {
        return this.fLength;
    }

    public int getSelectionOffset() {
        return this.fOffset;
    }

    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = ASTProvider.getASTProvider().getAST((IJavaElement)this.fCompilationUnit, ASTProvider.WAIT_YES, null);
            if (this.fASTRoot == null) {
                this.fASTRoot = ASTResolving.createQuickFixAST(this.fCompilationUnit, null);
            }
        }
        return this.fASTRoot;
    }

    public void setASTRoot(CompilationUnit compilationUnit) {
        this.fASTRoot = compilationUnit;
    }

    public ASTNode getCoveringNode() {
        NodeFinder nodeFinder = new NodeFinder(this.fOffset, this.fLength);
        this.getASTRoot().accept((ASTVisitor)nodeFinder);
        return nodeFinder.getCoveringNode();
    }

    public ASTNode getCoveredNode() {
        NodeFinder nodeFinder = new NodeFinder(this.fOffset, this.fLength);
        this.getASTRoot().accept((ASTVisitor)nodeFinder);
        return nodeFinder.getCoveredNode();
    }
}

