/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class ConstructorFromSuperclassProposal
extends LinkedCorrectionProposal {
    private TypeDeclaration fTypeNode;
    private IMethodBinding fSuperConstructor;

    public ConstructorFromSuperclassProposal(ICompilationUnit iCompilationUnit, TypeDeclaration typeDeclaration, IMethodBinding iMethodBinding, int n) {
        super("", iCompilationUnit, (ASTRewrite)null, n, (Image)null);
        this.fTypeNode = typeDeclaration;
        this.fSuperConstructor = iMethodBinding;
    }

    public Image getImage() {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE));
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fTypeNode.getName().getIdentifier());
        stringBuffer.append('(');
        if (this.fSuperConstructor != null) {
            ITypeBinding[] iTypeBindingArray = this.fSuperConstructor.getParameterTypes();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(iTypeBindingArray[n].getName());
                ++n;
            }
        }
        stringBuffer.append(')');
        return Messages.format(CorrectionMessages.ConstructorFromSuperclassProposal_description, stringBuffer.toString());
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST aST = this.fTypeNode.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        this.createImportRewrite((CompilationUnit)this.fTypeNode.getRoot());
        CodeGenerationSettings codeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaProject());
        if (!codeGenerationSettings.createComments) {
            codeGenerationSettings = null;
        }
        MethodDeclaration methodDeclaration = this.createNewMethodDeclaration(aST, this.fSuperConstructor, aSTRewrite, codeGenerationSettings);
        aSTRewrite.getListRewrite((ASTNode)this.fTypeNode, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)methodDeclaration, null);
        this.addLinkedRanges(aSTRewrite, methodDeclaration);
        return aSTRewrite;
    }

    private void addLinkedRanges(ASTRewrite aSTRewrite, MethodDeclaration methodDeclaration) {
        List list = methodDeclaration.parameters();
        int n = 0;
        while (n < list.size()) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)list.get(n);
            String string = singleVariableDeclaration.getName().getIdentifier();
            this.addLinkedPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration.getType()), false, "arg_type_" + string);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration.getName()), false, "arg_name_" + string);
            ++n;
        }
    }

    private MethodDeclaration createNewMethodDeclaration(AST aST, IMethodBinding iMethodBinding, ASTRewrite aSTRewrite, CodeGenerationSettings codeGenerationSettings) throws CoreException {
        List list;
        Object object;
        Object object2;
        Object object3;
        String string = this.fTypeNode.getName().getIdentifier();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setConstructor(true);
        methodDeclaration.setName(aST.newSimpleName(string));
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        SuperConstructorInvocation superConstructorInvocation = null;
        List list2 = methodDeclaration.parameters();
        String[] stringArray = this.getArgumentNames(iMethodBinding);
        ITypeBinding iTypeBinding = this.getEnclosingInstance();
        if (iTypeBinding != null) {
            superConstructorInvocation = this.addEnclosingInstanceAccess(aSTRewrite, list2, stringArray, iTypeBinding);
        }
        if (iMethodBinding == null) {
            methodDeclaration.modifiers().add(aST.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        } else {
            methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, iMethodBinding.getModifiers()));
            object3 = iMethodBinding.getParameterTypes();
            int n = 0;
            while (n < ((ITypeBinding[])object3).length) {
                object2 = aST.newSingleVariableDeclaration();
                object2.setType(this.getImportRewrite().addImport(object3[n], aST));
                object2.setName(aST.newSimpleName(stringArray[n]));
                list2.add(object2);
                ++n;
            }
            object = methodDeclaration.thrownExceptions();
            object2 = iMethodBinding.getExceptionTypes();
            int n2 = 0;
            while (n2 < ((ASTNode)object2).length) {
                String string2 = this.getImportRewrite().addImport((ITypeBinding)object2[n2]);
                object.add(ASTNodeFactory.newName(aST, string2));
                ++n2;
            }
            if (superConstructorInvocation == null) {
                superConstructorInvocation = aST.newSuperConstructorInvocation();
            }
            list = superConstructorInvocation.arguments();
            int n3 = 0;
            while (n3 < stringArray.length) {
                SimpleName simpleName = aST.newSimpleName(stringArray[n3]);
                list.add(simpleName);
                this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName), false, "arg_name_" + stringArray[n3]);
                ++n3;
            }
        }
        object3 = superConstructorInvocation == null ? "" : ASTNodes.asFormattedString((ASTNode)superConstructorInvocation, 0, String.valueOf('\n'), this.getCompilationUnit().getJavaProject().getOptions(true));
        object = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), string, string, true, (String)object3, String.valueOf('\n'));
        if (object != null) {
            object2 = aSTRewrite.createStringPlaceholder((String)object, 41);
            block.statements().add(object2);
        }
        if (codeGenerationSettings != null && (object2 = CodeGeneration.getMethodComment(this.getCompilationUnit(), string, methodDeclaration, null, String.valueOf('\n'))) != null) {
            list = (Javadoc)aSTRewrite.createStringPlaceholder((String)object2, 29);
            methodDeclaration.setJavadoc((Javadoc)list);
        }
        return methodDeclaration;
    }

    private SuperConstructorInvocation addEnclosingInstanceAccess(ASTRewrite aSTRewrite, List list, String[] stringArray, ITypeBinding iTypeBinding) throws CoreException {
        AST aST = aSTRewrite.getAST();
        SuperConstructorInvocation superConstructorInvocation = aST.newSuperConstructorInvocation();
        SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
        singleVariableDeclaration.setType(this.getImportRewrite().addImport(iTypeBinding, aST));
        String[] stringArray2 = StubUtility.getArgumentNameSuggestions(this.getCompilationUnit().getJavaProject(), iTypeBinding.getTypeDeclaration().getName(), 0, stringArray);
        String string = stringArray2[0];
        singleVariableDeclaration.setName(aST.newSimpleName(string));
        list.add(singleVariableDeclaration);
        SimpleName simpleName = aST.newSimpleName(string);
        superConstructorInvocation.setExpression((Expression)simpleName);
        String string2 = "arg_name_" + string;
        this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName), false, string2);
        int n = 0;
        while (n < stringArray2.length) {
            this.addLinkedPositionProposal(string2, stringArray2[n], null);
            ++n;
        }
        return superConstructorInvocation;
    }

    private ITypeBinding getEnclosingInstance() {
        ITypeBinding iTypeBinding = this.fTypeNode.resolveBinding();
        if (iTypeBinding == null || Modifier.isStatic((int)iTypeBinding.getModifiers())) {
            return null;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 == null || iTypeBinding2.getDeclaringClass() == null || Modifier.isStatic((int)iTypeBinding2.getModifiers())) {
            return null;
        }
        ITypeBinding iTypeBinding3 = iTypeBinding2.getDeclaringClass();
        while (iTypeBinding != null) {
            if (Bindings.isSuperType(iTypeBinding3, iTypeBinding)) {
                return null;
            }
            if (Modifier.isStatic((int)iTypeBinding.getModifiers())) {
                return null;
            }
            iTypeBinding = iTypeBinding.getDeclaringClass();
        }
        return iTypeBinding3;
    }

    private String[] getArgumentNames(IMethodBinding iMethodBinding) {
        if (iMethodBinding == null) {
            return new String[0];
        }
        return StubUtility.suggestArgumentNames(this.getCompilationUnit().getJavaProject(), iMethodBinding);
    }
}

