/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.QuickAssistLightBulbUpdater;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.IColorManager;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public class JavaCorrectionAssistant
extends QuickAssistAssistant {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Position fPosition;
    private Annotation[] fCurrentAnnotations;
    private QuickAssistLightBulbUpdater fLightBulbUpdater;
    static /* synthetic */ Class class$0;

    public JavaCorrectionAssistant(ITextEditor iTextEditor) {
        Assert.isNotNull((Object)iTextEditor);
        this.fEditor = iTextEditor;
        JavaCorrectionProcessor javaCorrectionProcessor = new JavaCorrectionProcessor(this);
        this.setQuickAssistProcessor(javaCorrectionProcessor);
        this.setInformationControlCreator(this.getInformationControlCreator());
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager iColorManager = javaTextTools.getColorManager();
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        Color color = JavaCorrectionAssistant.getColor(iPreferenceStore, "content_assist_proposals_foreground", iColorManager);
        this.setProposalSelectorForeground(color);
        color = JavaCorrectionAssistant.getColor(iPreferenceStore, "content_assist_proposals_background", iColorManager);
        this.setProposalSelectorBackground(color);
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    private static Color getColor(IPreferenceStore iPreferenceStore, String string, IColorManager iColorManager) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        return iColorManager.getColor(rGB);
    }

    public void install(ISourceViewer iSourceViewer) {
        super.install(iSourceViewer);
        this.fViewer = iSourceViewer;
        this.fLightBulbUpdater = new QuickAssistLightBulbUpdater(this.fEditor, (ITextViewer)iSourceViewer);
        this.fLightBulbUpdater.install();
    }

    public void uninstall() {
        if (this.fLightBulbUpdater != null) {
            this.fLightBulbUpdater.uninstall();
            this.fLightBulbUpdater = null;
        }
        super.uninstall();
    }

    public String showPossibleQuickAssists() {
        this.fPosition = null;
        this.fCurrentAnnotations = null;
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return super.showPossibleQuickAssists();
        }
        ArrayList arrayList = new ArrayList(20);
        try {
            Point point = this.fViewer.getSelectedRange();
            int n = point.x;
            int n2 = point.y;
            boolean bl = n2 == 0;
            int n3 = JavaCorrectionAssistant.collectQuickFixableAnnotations(this.fEditor, n, bl, arrayList);
            if (n3 != n) {
                this.storePosition(n, n2);
                this.fViewer.setSelectedRange(n3, 0);
                this.fViewer.revealRange(n3, 0);
            }
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        this.fCurrentAnnotations = arrayList.toArray(new Annotation[arrayList.size()]);
        return super.showPossibleQuickAssists();
    }

    private static IRegion getRegionOfInterest(ITextEditor iTextEditor, int n) throws BadLocationException {
        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
        if (iDocumentProvider == null) {
            return null;
        }
        IDocument iDocument = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
        if (iDocument == null) {
            return null;
        }
        return iDocument.getLineInformationOfOffset(n);
    }

    /*
     * Unable to fully structure code
     */
    public static int collectQuickFixableAnnotations(ITextEditor var0, int var1_1, boolean var2_2, ArrayList var3_3) throws BadLocationException {
        var4_4 = JavaUI.getDocumentProvider().getAnnotationModel((Object)var0.getEditorInput());
        if (var4_4 == null) {
            return var1_1;
        }
        JavaCorrectionAssistant.ensureUpdatedAnnotations(var0);
        var5_5 = var4_4.getAnnotationIterator();
        if (!var2_2) ** GOTO lbl39
        var6_6 = JavaCorrectionAssistant.getRegionOfInterest(var0, var1_1);
        if (var6_6 == null) {
            return var1_1;
        }
        var7_8 = var6_6.getOffset();
        var8_10 = var7_8 + var6_6.getLength();
        var9_11 = new ArrayList<Annotation>();
        var10_12 = new ArrayList<Position>();
        var11_13 = 0x7FFFFFFF;
        while (var5_5.hasNext()) {
            var12_14 = (Annotation)var5_5.next();
            if (!JavaCorrectionProcessor.isQuickFixableType(var12_14) || (var13_16 = var4_4.getPosition(var12_14)) == null || !JavaCorrectionAssistant.isInside(var13_16.offset, var7_8, var8_10)) continue;
            var9_11.add(var12_14);
            var10_12.add(var13_16);
            var11_13 = JavaCorrectionAssistant.processAnnotation(var12_14, var13_16, var1_1, var11_13);
        }
        if (var11_13 == 0x7FFFFFFF) {
            return var1_1;
        }
        var12_15 = 0;
        while (var12_15 < var10_12.size()) {
            var13_16 = (Position)var10_12.get(var12_15);
            if (JavaCorrectionAssistant.isInside(var11_13, var13_16.offset, var13_16.offset + var13_16.length)) {
                var3_3.add(var9_11.get(var12_15));
            }
            ++var12_15;
        }
        return var11_13;
lbl-1000:
        // 1 sources

        {
            var6_7 = (Annotation)var5_5.next();
            if (!JavaCorrectionProcessor.isQuickFixableType(var6_7) || (var7_9 = var4_4.getPosition(var6_7)) == null || !JavaCorrectionAssistant.isInside(var1_1, var7_9.offset, var7_9.offset + var7_9.length)) continue;
            var3_3.add(var6_7);
lbl39:
            // 3 sources

            ** while (var5_5.hasNext())
        }
lbl40:
        // 1 sources

        return var1_1;
    }

    private static void ensureUpdatedAnnotations(ITextEditor iTextEditor) {
        Object object;
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((object = iEditorInput.getAdapter((Class)clazz)) instanceof ICompilationUnit) {
            JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)((ICompilationUnit)object), ASTProvider.WAIT_ACTIVE_ONLY, null);
        }
    }

    private static int processAnnotation(Annotation annotation, Position position, int n, int n2) {
        int n3;
        int n4 = position.offset;
        int n5 = n4 + position.length;
        if (JavaCorrectionAssistant.isInside(n, n4, n5)) {
            return n;
        }
        if (n2 != n && (n3 = JavaCorrectionAssistant.computeBestOffset(n4, n, n2)) != -1 && n3 != n2 && JavaCorrectionProcessor.hasCorrections(annotation)) {
            return n3;
        }
        return n2;
    }

    private static boolean isInside(int n, int n2, int n3) {
        return n == n2 || n == n3 || n > n2 && n < n3;
    }

    private static int computeBestOffset(int n, int n2, int n3) {
        if (n <= n2) {
            if (n3 > n2) {
                return n;
            }
            if (n3 <= n) {
                return n;
            }
            return -1;
        }
        if (n <= n3) {
            return n;
        }
        return -1;
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    private void storePosition(int n, int n2) {
        this.fPosition = new Position(n, n2);
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }

    public boolean isUpdatedOffset() {
        return this.fPosition != null;
    }

    public Annotation[] getAnnotationsAtOffset() {
        return this.fCurrentAnnotations;
    }
}

