/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class LinkedNamesAssistProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2,
ICommandAccess {
    public static final String ASSIST_ID = "org.eclipse.wst.jsdt.ui.correction.renameInFile.assist";
    private SimpleName fNode;
    private ICompilationUnit fCompilationUnit;
    private String fLabel;
    private String fValueSuggestion;
    private int fRelevance;

    public LinkedNamesAssistProposal(ICompilationUnit iCompilationUnit, SimpleName simpleName) {
        this(CorrectionMessages.LinkedNamesAssistProposal_description, iCompilationUnit, simpleName, null);
        this.fNode = simpleName;
        this.fCompilationUnit = iCompilationUnit;
        this.fRelevance = 8;
    }

    public LinkedNamesAssistProposal(String string, ICompilationUnit iCompilationUnit, SimpleName simpleName, String string2) {
        this.fLabel = string;
        this.fNode = simpleName;
        this.fCompilationUnit = iCompilationUnit;
        this.fValueSuggestion = string2;
        this.fRelevance = 8;
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        try {
            Object object;
            Point point = iTextViewer.getSelectedRange();
            CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCompilationUnit, ASTProvider.WAIT_YES, null);
            ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, this.fNode.getStartPosition(), this.fNode.getLength());
            final int n3 = this.fNode.getStartPosition();
            Object[] objectArray = aSTNode instanceof SimpleName ? LinkedNodeFinder.findByNode((ASTNode)compilationUnit, (SimpleName)aSTNode) : new ASTNode[]{aSTNode};
            Arrays.sort(objectArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return this.rank((ASTNode)object) - this.rank((ASTNode)object2);
                }

                private int rank(ASTNode aSTNode) {
                    int n = aSTNode.getStartPosition() + aSTNode.getLength() - n3;
                    if (n < 0) {
                        return Integer.MAX_VALUE + n;
                    }
                    return n;
                }
            });
            IDocument iDocument = iTextViewer.getDocument();
            LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
            int n4 = 0;
            while (n4 < objectArray.length) {
                object = objectArray[n4];
                linkedPositionGroup.addPosition(new LinkedPosition(iDocument, object.getStartPosition(), object.getLength(), n4));
                ++n4;
            }
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            linkedModeModel.addGroup(linkedPositionGroup);
            linkedModeModel.forceInstall();
            object = this.getJavaEditor();
            if (object != null) {
                linkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer((JavaEditor)object));
            }
            EditorLinkedModeUI editorLinkedModeUI = new EditorLinkedModeUI(linkedModeModel, iTextViewer);
            editorLinkedModeUI.setExitPolicy((LinkedModeUI.IExitPolicy)new DeleteBlockingExitPolicy(iDocument));
            editorLinkedModeUI.setExitPosition(iTextViewer, n2, 0, -1);
            editorLinkedModeUI.enter();
            if (this.fValueSuggestion != null) {
                iDocument.replace(aSTNode.getStartPosition(), aSTNode.getLength(), this.fValueSuggestion);
                IRegion iRegion = editorLinkedModeUI.getSelectedRegion();
                point = new Point(iRegion.getOffset(), this.fValueSuggestion.length());
            }
            iTextViewer.setSelectedRange(point.x, point.y);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private JavaEditor getJavaEditor() {
        IEditorPart iEditorPart = JavaPlugin.getActivePage().getActiveEditor();
        if (iEditorPart instanceof JavaEditor) {
            return (JavaEditor)iEditorPart;
        }
        return null;
    }

    public void apply(IDocument iDocument) {
    }

    public Point getSelection(IDocument iDocument) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return CorrectionMessages.LinkedNamesAssistProposal_proposalinfo;
    }

    public String getDisplayString() {
        String string = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (string != null) {
            return Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.fLabel, string});
        }
        return this.fLabel;
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_linked_rename.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        return false;
    }

    public String getCommandId() {
        return ASSIST_ID;
    }

    public void setRelevance(int n) {
        this.fRelevance = n;
    }

    public static class DeleteBlockingExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private IDocument fDocument;

        public DeleteBlockingExitPolicy(IDocument iDocument) {
            this.fDocument = iDocument;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel linkedModeModel, VerifyEvent verifyEvent, int n, int n2) {
            LinkedPosition linkedPosition;
            if (n2 == 0 && (verifyEvent.character == '\b' || verifyEvent.character == '\u007f') && (linkedPosition = linkedModeModel.findPosition(new LinkedPosition(this.fDocument, n, 0, -1))) != null) {
                if (verifyEvent.character == '\b') {
                    if (n - 1 < linkedPosition.getOffset()) {
                        verifyEvent.doit = false;
                    }
                } else if (n + 1 > linkedPosition.getOffset() + linkedPosition.getLength()) {
                    verifyEvent.doit = false;
                }
            }
            return null;
        }
    }
}

