/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ProblemLocation
implements IProblemLocation {
    private final int fId;
    private final String[] fArguments;
    private final int fOffset;
    private final int fLength;
    private final boolean fIsError;
    private final String fMarkerType;

    public ProblemLocation(int n, int n2, IJavaAnnotation iJavaAnnotation) {
        this.fId = iJavaAnnotation.getId();
        this.fArguments = iJavaAnnotation.getArguments();
        this.fOffset = n;
        this.fLength = n2;
        this.fIsError = "org.eclipse.wst.jsdt.ui.error".equals(iJavaAnnotation.getType());
        String string = iJavaAnnotation.getMarkerType();
        this.fMarkerType = string != null ? string : "org.eclipse.wst.jsdt.core.problem";
    }

    public ProblemLocation(int n, int n2, int n3, String[] stringArray, boolean bl, String string) {
        this.fId = n3;
        this.fArguments = stringArray;
        this.fOffset = n;
        this.fLength = n2;
        this.fIsError = bl;
        this.fMarkerType = string;
    }

    public ProblemLocation(IProblem iProblem) {
        this.fId = iProblem.getID();
        this.fArguments = iProblem.getArguments();
        this.fOffset = iProblem.getSourceStart();
        this.fLength = iProblem.getSourceEnd() - this.fOffset + 1;
        this.fIsError = iProblem.isError();
        this.fMarkerType = iProblem instanceof CategorizedProblem ? ((CategorizedProblem)iProblem).getMarkerType() : "org.eclipse.wst.jsdt.core.problem";
    }

    public int getProblemId() {
        return this.fId;
    }

    public String[] getProblemArguments() {
        return this.fArguments;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public boolean isError() {
        return this.fIsError;
    }

    public String getMarkerType() {
        return this.fMarkerType;
    }

    public ASTNode getCoveringNode(CompilationUnit compilationUnit) {
        NodeFinder nodeFinder = new NodeFinder(this.fOffset, this.fLength);
        compilationUnit.accept((ASTVisitor)nodeFinder);
        return nodeFinder.getCoveringNode();
    }

    public ASTNode getCoveredNode(CompilationUnit compilationUnit) {
        NodeFinder nodeFinder = new NodeFinder(this.fOffset, this.fLength);
        compilationUnit.accept((ASTVisitor)nodeFinder);
        return nodeFinder.getCoveredNode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Id: ").append(this.getErrorCode(this.fId)).append('\n');
        stringBuffer.append('[').append(this.fOffset).append(", ").append(this.fLength).append(']').append('\n');
        String[] stringArray = this.fArguments;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append('\n');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private String getErrorCode(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0x1000000) != 0) {
            stringBuffer.append("TypeRelated + ");
        }
        if ((n & 0x2000000) != 0) {
            stringBuffer.append("FieldRelated + ");
        }
        if ((n & 0x8000000) != 0) {
            stringBuffer.append("ConstructorRelated + ");
        }
        if ((n & 0x4000000) != 0) {
            stringBuffer.append("MethodRelated + ");
        }
        if ((n & 0x10000000) != 0) {
            stringBuffer.append("ImportRelated + ");
        }
        if ((n & 0x20000000) != 0) {
            stringBuffer.append("Internal + ");
        }
        if ((n & 0x40000000) != 0) {
            stringBuffer.append("Syntax + ");
        }
        if ((n & Integer.MIN_VALUE) != 0) {
            stringBuffer.append("Javadoc + ");
        }
        stringBuffer.append(n & 0xFFFFFF);
        return stringBuffer.toString();
    }
}

