/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;

public class RemoveDeclarationCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private SimpleName fName;

    public RemoveDeclarationCorrectionProposal(ICompilationUnit iCompilationUnit, SimpleName simpleName, int n) {
        super("", iCompilationUnit, (ASTRewrite)null, n, JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.fName = simpleName;
    }

    public String getDisplayString() {
        IBinding iBinding = this.fName.resolveBinding();
        String string = this.fName.getIdentifier();
        switch (iBinding.getKind()) {
            case 2: {
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedtype_description, string);
            }
            case 4: {
                if (((IMethodBinding)iBinding).isConstructor()) {
                    return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedconstructor_description, string);
                }
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedmethod_description, string);
            }
            case 3: {
                if (((IVariableBinding)iBinding).isField()) {
                    return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedfield_description, string);
                }
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedvar_description, string);
            }
        }
        return super.getDisplayString();
    }

    protected ASTRewrite getRewrite() {
        ASTRewrite aSTRewrite;
        IBinding iBinding = this.fName.resolveBinding();
        CompilationUnit compilationUnit = (CompilationUnit)this.fName.getRoot();
        if (iBinding.getKind() == 4) {
            IMethodBinding iMethodBinding = ((IMethodBinding)iBinding).getMethodDeclaration();
            ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)iMethodBinding);
            aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
            aSTRewrite.remove(aSTNode, null);
        } else if (iBinding.getKind() == 2) {
            ITypeBinding iTypeBinding = ((ITypeBinding)iBinding).getTypeDeclaration();
            ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)iTypeBinding);
            aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
            aSTRewrite.remove(aSTNode, null);
        } else if (iBinding.getKind() == 3) {
            CompilationUnit compilationUnit2 = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.getCompilationUnit(), ASTProvider.WAIT_YES, null);
            SimpleName simpleName = (SimpleName)NodeFinder.perform((ASTNode)compilationUnit2, this.fName.getStartPosition(), this.fName.getLength());
            aSTRewrite = ASTRewrite.create((AST)compilationUnit2.getAST());
            SimpleName[] simpleNameArray = LinkedNodeFinder.findByBinding((ASTNode)compilationUnit2, simpleName.resolveBinding());
            int n = 0;
            while (n < simpleNameArray.length) {
                this.removeVariableReferences(aSTRewrite, simpleNameArray[n]);
                ++n;
            }
            IVariableBinding iVariableBinding = ((IVariableBinding)simpleName.resolveBinding()).getVariableDeclaration();
            ASTNode aSTNode = compilationUnit2.findDeclaringNode((IBinding)iVariableBinding);
            if (aSTNode instanceof SingleVariableDeclaration) {
                this.removeParamTag(aSTRewrite, (SingleVariableDeclaration)aSTNode);
            }
        } else {
            throw new IllegalArgumentException("Unexpected binding");
        }
        return aSTRewrite;
    }

    private void removeParamTag(ASTRewrite aSTRewrite, SingleVariableDeclaration singleVariableDeclaration) {
        TagElement tagElement;
        Javadoc javadoc;
        if (singleVariableDeclaration.getParent() instanceof MethodDeclaration && (javadoc = ((MethodDeclaration)singleVariableDeclaration.getParent()).getJavadoc()) != null && (tagElement = JavadocTagsSubProcessor.findParamTag(javadoc, singleVariableDeclaration.getName().getIdentifier())) != null) {
            aSTRewrite.remove((ASTNode)tagElement, null);
        }
    }

    private void removeVariableReferences(ASTRewrite aSTRewrite, SimpleName simpleName) {
        int n;
        ASTNode aSTNode = simpleName.getParent();
        while (aSTNode instanceof QualifiedName) {
            aSTNode = aSTNode.getParent();
        }
        if (aSTNode instanceof FieldAccess) {
            aSTNode = aSTNode.getParent();
        }
        if ((n = aSTNode.getNodeType()) == 7) {
            Assignment assignment = (Assignment)aSTNode;
            Expression expression = assignment.getRightHandSide();
            ASTNode aSTNode2 = assignment.getParent();
            if (aSTNode2.getNodeType() == 21 && expression.getNodeType() != 7) {
                this.removeVariableWithInitializer(aSTRewrite, (ASTNode)expression, aSTNode2);
            } else {
                aSTRewrite.replace((ASTNode)assignment, aSTRewrite.createCopyTarget((ASTNode)expression), null);
            }
        } else if (n == 44) {
            aSTRewrite.remove(aSTNode, null);
        } else if (n == 59) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode;
            ASTNode aSTNode3 = variableDeclarationFragment.getParent();
            List list = aSTNode3 instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)aSTNode3).fragments() : (aSTNode3 instanceof FieldDeclaration ? ((FieldDeclaration)aSTNode3).fragments() : ((VariableDeclarationStatement)aSTNode3).fragments());
            if (list.size() == 1) {
                aSTRewrite.remove(aSTNode3, null);
            } else {
                aSTRewrite.remove((ASTNode)variableDeclarationFragment, null);
            }
        }
    }

    private void removeVariableWithInitializer(ASTRewrite aSTRewrite, ASTNode aSTNode, ASTNode aSTNode2) {
        ArrayList arrayList = new ArrayList();
        aSTNode.accept((ASTVisitor)new SideEffectFinder(arrayList));
        int n = arrayList.size();
        if (n == 0) {
            if (ASTNodes.isControlStatementBody(aSTNode2.getLocationInParent())) {
                aSTRewrite.replace(aSTNode2, (ASTNode)aSTRewrite.getAST().newBlock(), null);
            } else {
                aSTRewrite.remove(aSTNode2, null);
            }
        }
    }

    private static class SideEffectFinder
    extends ASTVisitor {
        private ArrayList fSideEffectNodes;

        public SideEffectFinder(ArrayList arrayList) {
            this.fSideEffectNodes = arrayList;
        }

        public boolean visit(Assignment assignment) {
            this.fSideEffectNodes.add(assignment);
            return false;
        }

        public boolean visit(PostfixExpression postfixExpression) {
            this.fSideEffectNodes.add(postfixExpression);
            return false;
        }

        public boolean visit(PrefixExpression prefixExpression) {
            PrefixExpression.Operator operator = prefixExpression.getOperator();
            if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                this.fSideEffectNodes.add(prefixExpression);
            }
            return false;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            this.fSideEffectNodes.add(methodInvocation);
            return false;
        }

        public boolean visit(ClassInstanceCreation classInstanceCreation) {
            this.fSideEffectNodes.add(classInstanceCreation);
            return false;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            this.fSideEffectNodes.add(superMethodInvocation);
            return false;
        }
    }
}

