/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.folding;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.jsdt.internal.ui.text.folding.EmptyJavaFoldingPreferenceBlock;
import org.eclipse.wst.jsdt.ui.text.folding.IJavaFoldingPreferenceBlock;
import org.eclipse.wst.jsdt.ui.text.folding.IJavaFoldingStructureProvider;

public final class JavaFoldingStructureProviderDescriptor {
    private static final String PREFERENCES_CLASS = "preferencesClass";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String ID = "id";
    private String fId;
    private String fName;
    private String fClass;
    private boolean fHasPreferences;
    private IConfigurationElement fElement;

    JavaFoldingStructureProviderDescriptor(IConfigurationElement iConfigurationElement) {
        this.fElement = iConfigurationElement;
        this.fId = iConfigurationElement.getAttribute(ID);
        Assert.isLegal((this.fId != null ? 1 : 0) != 0);
        this.fName = iConfigurationElement.getAttribute(NAME);
        if (this.fName == null) {
            this.fName = this.fId;
        }
        this.fClass = iConfigurationElement.getAttribute(CLASS);
        Assert.isLegal((this.fClass != null ? 1 : 0) != 0);
        this.fHasPreferences = iConfigurationElement.getAttribute(PREFERENCES_CLASS) != null;
    }

    public IJavaFoldingStructureProvider createProvider() throws CoreException {
        IJavaFoldingStructureProvider iJavaFoldingStructureProvider = (IJavaFoldingStructureProvider)this.fElement.createExecutableExtension(CLASS);
        return iJavaFoldingStructureProvider;
    }

    public IJavaFoldingPreferenceBlock createPreferences() throws CoreException {
        if (this.fHasPreferences) {
            IJavaFoldingPreferenceBlock iJavaFoldingPreferenceBlock = (IJavaFoldingPreferenceBlock)this.fElement.createExecutableExtension(PREFERENCES_CLASS);
            return iJavaFoldingPreferenceBlock;
        }
        return new EmptyJavaFoldingPreferenceBlock();
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }
}

