/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.ImportCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.MemberProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.SmartSemicolonAutoEditStrategy;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public abstract class AbstractJavaCompletionProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension5 {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private ProposalInfo fProposalInfo;
    private char[] fTriggerCharacters;
    private String fSortString;
    private int fRelevance;
    private boolean fIsInJavadoc;
    private StyleRange fRememberedStyleRange;
    private boolean fToggleEating;
    private ITextViewer fTextViewer;
    private IInformationControlCreator fCreator;
    private static String fgCSSStyles;
    protected final JavaContentAssistInvocationContext fInvocationContext;

    protected AbstractJavaCompletionProposal() {
        this.fInvocationContext = null;
    }

    protected AbstractJavaCompletionProposal(JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        this.fInvocationContext = javaContentAssistInvocationContext;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public void setTriggerCharacters(char[] cArray) {
        this.fTriggerCharacters = cArray;
    }

    public void setProposalInfo(ProposalInfo proposalInfo) {
        this.fProposalInfo = proposalInfo;
    }

    protected ProposalInfo getProposalInfo() {
        return this.fProposalInfo;
    }

    public void setCursorPosition(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = n;
    }

    protected int getCursorPosition() {
        return this.fCursorPosition;
    }

    public final void apply(IDocument iDocument) {
        this.apply(iDocument, '\u0000', this.getReplacementOffset() + this.getReplacementLength());
    }

    public void apply(IDocument iDocument, char c, int n) {
        Object object;
        if (this.isSupportingRequiredProposals()) {
            CompletionProposal completionProposal = ((MemberProposalInfo)this.fProposalInfo).fProposal;
            CompletionProposal[] completionProposalArray = completionProposal.getRequiredProposals();
            int n2 = 0;
            while (completionProposalArray != null && n2 < completionProposalArray.length) {
                int n3 = iDocument.getLength();
                if (completionProposalArray[n2].getKind() == 9) {
                    object = new LazyJavaTypeCompletionProposal(completionProposalArray[n2], this.fInvocationContext);
                    ((AbstractJavaCompletionProposal)object).apply(iDocument);
                    this.setReplacementOffset(this.getReplacementOffset() + iDocument.getLength() - n3);
                } else if (completionProposalArray[n2].getKind() == 23) {
                    object = new ImportCompletionProposal(completionProposalArray[n2], this.fInvocationContext, completionProposal.getKind());
                    ((AbstractJavaCompletionProposal)object).setReplacementOffset(this.getReplacementOffset());
                    ((AbstractJavaCompletionProposal)object).apply(iDocument);
                    this.setReplacementOffset(this.getReplacementOffset() + iDocument.getLength() - n3);
                } else if (completionProposalArray[n2].getKind() == 22) {
                    object = new ImportCompletionProposal(completionProposalArray[n2], this.fInvocationContext, completionProposal.getKind());
                    ((AbstractJavaCompletionProposal)object).setReplacementOffset(this.getReplacementOffset());
                    ((AbstractJavaCompletionProposal)object).apply(iDocument);
                    this.setReplacementOffset(this.getReplacementOffset() + iDocument.getLength() - n3);
                } else if (completionProposalArray[n2].getKind() == 21) {
                    object = new ImportCompletionProposal(completionProposalArray[n2], this.fInvocationContext, completionProposal.getKind());
                    ((AbstractJavaCompletionProposal)object).setReplacementOffset(this.getReplacementOffset());
                    ((AbstractJavaCompletionProposal)object).apply(iDocument);
                    this.setReplacementOffset(this.getReplacementOffset() + iDocument.getLength() - n3);
                } else {
                    Assert.isTrue((boolean)false);
                }
                ++n2;
            }
        }
        try {
            String string;
            boolean bl;
            int n4 = n - (this.getReplacementOffset() + this.getReplacementLength());
            if (n4 > 0) {
                this.setReplacementLength(this.getReplacementLength() + n4);
            }
            if ((bl = this.isSmartTrigger(c)) || c == '\u0000') {
                string = this.getReplacementString();
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.getReplacementString());
                if (this.getCursorPosition() > 0 && this.getCursorPosition() <= stringBuffer.length() && stringBuffer.charAt(this.getCursorPosition() - 1) != c) {
                    stringBuffer.insert(this.getCursorPosition(), c);
                    this.setCursorPosition(this.getCursorPosition() + 1);
                }
                string = stringBuffer.toString();
                this.setReplacementString(string);
            }
            int n5 = this.getReplacementOffset() + this.getReplacementLength();
            object = new ReferenceTracker();
            ((ReferenceTracker)object).preReplace(iDocument, n5);
            this.replace(iDocument, this.getReplacementOffset(), this.getReplacementLength(), string);
            n5 = ((ReferenceTracker)object).postReplace(iDocument);
            this.setReplacementOffset(n5 - (string == null ? 0 : string.length()));
            if (bl) {
                this.handleSmartTrigger(iDocument, c, n5);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isSmartTrigger(char c) {
        return c == ';' && JavaPlugin.getDefault().getCombinedPreferenceStore().getBoolean("smart_semicolon") || c == '{' && JavaPlugin.getDefault().getCombinedPreferenceStore().getBoolean("smart_opening_brace");
    }

    private void handleSmartTrigger(IDocument iDocument, char c, int n) throws BadLocationException {
        DocumentCommand documentCommand = new DocumentCommand(){};
        documentCommand.offset = n;
        documentCommand.length = 0;
        documentCommand.text = Character.toString(c);
        documentCommand.doit = true;
        documentCommand.shiftsCaret = true;
        documentCommand.caretOffset = this.getReplacementOffset() + this.getCursorPosition();
        SmartSemicolonAutoEditStrategy smartSemicolonAutoEditStrategy = new SmartSemicolonAutoEditStrategy("___java_partitioning");
        smartSemicolonAutoEditStrategy.customizeDocumentCommand(iDocument, documentCommand);
        this.replace(iDocument, documentCommand.offset, documentCommand.length, documentCommand.text);
        this.setCursorPosition(documentCommand.caretOffset - this.getReplacementOffset() + documentCommand.text.length());
    }

    protected final void replace(IDocument iDocument, int n, int n2, String string) throws BadLocationException {
        if (!iDocument.get(n, n2).equals(string)) {
            iDocument.replace(n, n2, string);
        }
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        IDocument iDocument = iTextViewer.getDocument();
        if (this.fTextViewer == null) {
            this.fTextViewer = iTextViewer;
        }
        if (!this.isInJavadoc() && !this.validate(iDocument, n2, null)) {
            this.setCursorPosition(n2 - this.getReplacementOffset());
            if (c != '\u0000') {
                try {
                    iDocument.replace(n2, 0, String.valueOf(c));
                    this.setCursorPosition(this.getCursorPosition() + 1);
                    if (c == '(' && this.autocloseBrackets()) {
                        iDocument.replace(this.getReplacementOffset() + this.getCursorPosition(), 0, ")");
                        this.setUpLinkedMode(iDocument, ')');
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return;
        }
        Point point = iTextViewer.getSelectedRange();
        this.fToggleEating = (n & SWT.MOD1) != 0;
        int n3 = point.x + point.y - this.getReplacementOffset();
        if (AbstractJavaCompletionProposal.insertCompletion() ^ this.fToggleEating && n3 >= 0) {
            this.setReplacementLength(n3);
        }
        this.apply(iDocument, c, n2);
        this.fToggleEating = false;
    }

    protected boolean isInJavadoc() {
        return this.fIsInJavadoc;
    }

    protected void setInJavadoc(boolean bl) {
        this.fIsInJavadoc = bl;
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.getReplacementOffset() + this.getCursorPosition(), 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public void setContextInformation(IContextInformation iContextInformation) {
        this.fContextInformation = iContextInformation;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        Object object = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        return object == null ? (String)object : object.toString();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor iProgressMonitor) {
        if (this.getProposalInfo() != null) {
            String string = this.getProposalInfo().getInfo(iProgressMonitor);
            if (string != null && string.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                HTMLPrinter.insertPageProlog((StringBuffer)stringBuffer, (int)0, (String)this.getCSSStyles());
                stringBuffer.append(string);
                HTMLPrinter.addPageEpilog((StringBuffer)stringBuffer);
                string = stringBuffer.toString();
            }
            return string;
        }
        return null;
    }

    protected String getCSSStyles() {
        String string;
        URL uRL;
        if (fgCSSStyles == null && (uRL = (string = Platform.getBundle((String)JavaPlugin.getPluginId())).getEntry("/JavadocHoverStyleSheet.css")) != null) {
            try {
                uRL = FileLocator.toFileURL((URL)uRL);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                StringBuffer stringBuffer = new StringBuffer(200);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('\n');
                    string2 = bufferedReader.readLine();
                }
                fgCSSStyles = stringBuffer.toString();
            }
            catch (IOException iOException) {
                JavaPlugin.log(iOException);
            }
        }
        if ((string = fgCSSStyles) != null) {
            uRL = JFaceResources.getFontRegistry().getFontData("org.eclipse.wst.jsdt.ui.javadocfont")[0];
            string = HTMLPrinter.convertTopLevelFont((String)string, (FontData)uRL);
        }
        return string;
    }

    public int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = n;
    }

    public int getPrefixCompletionStart(IDocument iDocument, int n) {
        return this.getReplacementOffset();
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = n;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String string) {
        Assert.isNotNull((Object)string);
        this.fReplacementString = string;
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        if (!this.isCamelCaseMatching()) {
            return this.getReplacementString();
        }
        String string = this.getPrefix(iDocument, n);
        return this.getCamelCaseCompound(string, this.getReplacementString());
    }

    public Image getImage() {
        return this.fImage;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public boolean isValidFor(IDocument iDocument, int n) {
        return this.validate(iDocument, n, null);
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        if (n < this.getReplacementOffset()) {
            return false;
        }
        boolean bl = this.isValidPrefix(this.getPrefix(iDocument, n));
        if (bl && documentEvent != null) {
            int n2 = (documentEvent.fText == null ? 0 : documentEvent.fText.length()) - documentEvent.fLength;
            int n3 = Math.max(this.getReplacementLength() + n2, 0);
            this.setReplacementLength(n3);
        }
        return bl;
    }

    protected boolean isValidPrefix(String string) {
        return this.isPrefix(string, this.getDisplayString());
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int n) {
        this.fRelevance = n;
    }

    protected String getPrefix(IDocument iDocument, int n) {
        try {
            int n2 = n - this.getReplacementOffset();
            if (n2 > 0) {
                return iDocument.get(this.getReplacementOffset(), n2);
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    protected boolean isPrefix(String string, String string2) {
        if (string == null || string2 == null || string.length() > string2.length()) {
            return false;
        }
        String string3 = string2.substring(0, string.length());
        return string3.equalsIgnoreCase(string) || this.isCamelCaseMatching() && CharOperation.camelCaseMatch((char[])string.toCharArray(), (char[])string2.toCharArray());
    }

    protected final String getCamelCaseCompound(String string, String string2) {
        if (string.length() > string2.length()) {
            return string2;
        }
        String string3 = string2.substring(0, string.length());
        if (string3.equalsIgnoreCase(string)) {
            return string2;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = 1;
        while (n <= cArray2.length) {
            if (CharOperation.camelCaseMatch((char[])cArray, (int)0, (int)cArray.length, (char[])cArray2, (int)0, (int)n)) {
                return String.valueOf(string) + string2.substring(n);
            }
            ++n;
        }
        return string2;
    }

    protected boolean isCamelCaseMatching() {
        IJavaProject iJavaProject = this.getProject();
        String string = iJavaProject == null ? JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.codeComplete.camelCaseMatch") : iJavaProject.getOption("org.eclipse.wst.jsdt.core.codeComplete.camelCaseMatch", true);
        return "enabled".equals(string);
    }

    private IJavaProject getProject() {
        return null;
    }

    private static boolean insertCompletion() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("content_assist_insert_completion");
    }

    private static Color getForegroundColor(StyledText styledText) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"content_assist_completion_replacement_foreground");
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        return javaTextTools.getColorManager().getColor(rGB);
    }

    private static Color getBackgroundColor(StyledText styledText) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"content_assist_completion_replacement_background");
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        return javaTextTools.getColorManager().getColor(rGB);
    }

    private void repairPresentation(ITextViewer iTextViewer) {
        if (this.fRememberedStyleRange != null) {
            if (iTextViewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 iTextViewerExtension2 = (ITextViewerExtension2)iTextViewer;
                if (iTextViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iTextViewer;
                    IRegion iRegion = iTextViewerExtension5.widgetRange2ModelRange((IRegion)new Region(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length));
                    if (iRegion != null) {
                        iTextViewerExtension2.invalidateTextPresentation(iRegion.getOffset(), iRegion.getLength());
                    }
                } else {
                    iTextViewerExtension2.invalidateTextPresentation(this.fRememberedStyleRange.start + iTextViewer.getVisibleRegion().getOffset(), this.fRememberedStyleRange.length);
                }
            } else {
                iTextViewer.invalidateTextPresentation();
            }
        }
    }

    private void updateStyle(ITextViewer iTextViewer) {
        ITextViewerExtension5 iTextViewerExtension5;
        StyledText styledText = iTextViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        int n = styledText.getCaretOffset();
        int n2 = 0;
        if (iTextViewer instanceof ITextViewerExtension5) {
            iTextViewerExtension5 = (ITextViewerExtension5)iTextViewer;
            n2 = iTextViewerExtension5.widgetOffset2ModelOffset(n);
        } else {
            iTextViewerExtension5 = iTextViewer.getVisibleRegion();
            n2 = n + iTextViewerExtension5.getOffset();
        }
        if (n2 >= this.getReplacementOffset() + this.getReplacementLength()) {
            this.repairPresentation(iTextViewer);
            return;
        }
        int n3 = n;
        int n4 = this.getReplacementOffset() + this.getReplacementLength() - n2;
        Color color = AbstractJavaCompletionProposal.getForegroundColor(styledText);
        Color color2 = AbstractJavaCompletionProposal.getBackgroundColor(styledText);
        StyleRange styleRange = styledText.getStyleRangeAtOffset(n3);
        int n5 = styleRange != null ? styleRange.fontStyle : 0;
        this.repairPresentation(iTextViewer);
        this.fRememberedStyleRange = new StyleRange(n3, n4, color, color2, n5);
        if (styleRange != null) {
            this.fRememberedStyleRange.strikeout = styleRange.strikeout;
            this.fRememberedStyleRange.underline = styleRange.underline;
        }
        try {
            styledText.setStyleRange(this.fRememberedStyleRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fRememberedStyleRange = null;
        }
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
        if (!AbstractJavaCompletionProposal.insertCompletion() ^ bl) {
            this.updateStyle(iTextViewer);
        } else {
            this.repairPresentation(iTextViewer);
            this.fRememberedStyleRange = null;
        }
    }

    public void unselected(ITextViewer iTextViewer) {
        this.repairPresentation(iTextViewer);
        this.fRememberedStyleRange = null;
    }

    public IInformationControlCreator getInformationControlCreator() {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (shell == null || !BrowserInformationControl.isAvailable((Composite)shell)) {
            return null;
        }
        if (this.fCreator == null) {
            this.fCreator = new ControlCreator();
        }
        return this.fCreator;
    }

    public String getSortString() {
        return this.fSortString;
    }

    protected void setSortString(String string) {
        this.fSortString = string;
    }

    protected ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    protected boolean isToggleEating() {
        return this.fToggleEating;
    }

    protected void setUpLinkedMode(IDocument iDocument, char c) {
        if (this.getTextViewer() != null && this.autocloseBrackets()) {
            int n = this.getReplacementOffset() + this.getCursorPosition();
            int n2 = this.getReplacementOffset() + this.getReplacementString().length();
            try {
                LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
                linkedPositionGroup.addPosition(new LinkedPosition(iDocument, n, 0, -1));
                LinkedModeModel linkedModeModel = new LinkedModeModel();
                linkedModeModel.addGroup(linkedPositionGroup);
                linkedModeModel.forceInstall();
                EditorLinkedModeUI editorLinkedModeUI = new EditorLinkedModeUI(linkedModeModel, this.getTextViewer());
                editorLinkedModeUI.setSimpleMode(true);
                editorLinkedModeUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(c, iDocument));
                editorLinkedModeUI.setExitPosition(this.getTextViewer(), n2, 0, Integer.MAX_VALUE);
                editorLinkedModeUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                editorLinkedModeUI.enter();
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
        }
    }

    protected boolean autocloseBrackets() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("closeBrackets");
    }

    protected void setDisplayString(String string) {
        this.fDisplayString = string;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public IJavaElement getJavaElement() {
        if (this.getProposalInfo() != null) {
            try {
                return this.getProposalInfo().getJavaElement();
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return null;
    }

    protected boolean isSupportingRequiredProposals() {
        if (this.fInvocationContext == null || !(this.fProposalInfo instanceof MemberProposalInfo)) {
            return false;
        }
        CompletionProposal completionProposal = ((MemberProposalInfo)this.fProposalInfo).fProposal;
        return completionProposal != null && (completionProposal.getKind() == 6 || completionProposal.getKind() == 2);
    }

    private static final class ControlCreator
    extends AbstractReusableInformationControlCreator {
        private ControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            return new BrowserInformationControl(shell, 12, 0, null);
        }
    }

    protected static final class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        private final IDocument fDocument;

        public ExitPolicy(char c, IDocument iDocument) {
            this.fExitCharacter = c;
            this.fDocument = iDocument;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel linkedModeModel, VerifyEvent verifyEvent, int n, int n2) {
            if (verifyEvent.character == this.fExitCharacter) {
                if (linkedModeModel.anyPositionContains(n)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (verifyEvent.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
                case '\r': {
                    if (n > 0) {
                        try {
                            if (this.fDocument.getChar(n - 1) == '{') {
                                return new LinkedModeUI.ExitFlags(1, true);
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    return null;
                }
            }
            return null;
        }
    }

    static final class ReferenceTracker {
        private static final String CATEGORY = "reference_position";
        private final IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("reference_position");
        private final Position fPosition = new Position(0);

        ReferenceTracker() {
        }

        public void preReplace(IDocument iDocument, int n) throws BadLocationException {
            this.fPosition.setOffset(n);
            try {
                iDocument.addPositionCategory(CATEGORY);
                iDocument.addPositionUpdater(this.fPositionUpdater);
                iDocument.addPosition(CATEGORY, this.fPosition);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                JavaPlugin.log(badPositionCategoryException);
            }
        }

        public int postReplace(IDocument iDocument) {
            try {
                iDocument.removePosition(CATEGORY, this.fPosition);
                iDocument.removePositionUpdater(this.fPositionUpdater);
                iDocument.removePositionCategory(CATEGORY);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                JavaPlugin.log(badPositionCategoryException);
            }
            return this.fPosition.getOffset();
        }
    }
}

