/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerDescriptor;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;

public final class CompletionProposalComputerRegistry {
    private static final String EXTENSION_POINT = "javaCompletionProposalComputer";
    private static CompletionProposalComputerRegistry fgSingleton = null;
    private final Map fDescriptorsByPartition = new HashMap();
    private final Map fPublicDescriptorsByPartition = new HashMap();
    private final List fDescriptors = new ArrayList();
    private final List fPublicDescriptors = Collections.unmodifiableList(this.fDescriptors);
    private final List fCategories = new ArrayList();
    private final List fPublicCategories = Collections.unmodifiableList(this.fCategories);
    private boolean fLoaded = false;

    public static synchronized CompletionProposalComputerRegistry getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new CompletionProposalComputerRegistry();
        }
        return fgSingleton;
    }

    List getProposalComputerDescriptors(String string) {
        this.ensureExtensionPointRead();
        List list = (List)this.fPublicDescriptorsByPartition.get(string);
        return list != null ? list : Collections.EMPTY_LIST;
    }

    List getProposalComputerDescriptors() {
        this.ensureExtensionPointRead();
        return this.fPublicDescriptors;
    }

    public List getProposalCategories() {
        this.ensureExtensionPointRead();
        return this.fPublicCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureExtensionPointRead() {
        boolean bl;
        CompletionProposalComputerRegistry completionProposalComputerRegistry = this;
        synchronized (completionProposalComputerRegistry) {
            bl = !this.fLoaded;
            this.fLoaded = true;
        }
        if (bl) {
            this.reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>(Arrays.asList(iExtensionRegistry.getConfigurationElementsFor(JavaPlugin.getPluginId(), EXTENSION_POINT)));
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        ArrayList<CompletionProposalComputerDescriptor> arrayList2 = new ArrayList<CompletionProposalComputerDescriptor>();
        List list = this.getCategories(arrayList);
        Object object6 = arrayList.iterator();
        while (object6.hasNext()) {
            object5 = (IConfigurationElement)object6.next();
            try {
                object4 = new CompletionProposalComputerDescriptor((IConfigurationElement)object5, this, list);
                object3 = ((CompletionProposalComputerDescriptor)object4).getPartitions();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    ArrayList<Object> arrayList3 = (ArrayList<Object>)hashMap.get(object);
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Object>();
                        hashMap.put((String)object, arrayList3);
                    }
                    arrayList3.add(object4);
                }
                arrayList2.add((CompletionProposalComputerDescriptor)object4);
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                object3 = new Object[]{object5.toString()};
                object2 = Messages.format(JavaTextMessages.CompletionProposalComputerRegistry_invalid_message, object3);
                object = new Status(2, JavaPlugin.getPluginId(), 0, (String)object2, (Throwable)invalidRegistryObjectException);
                this.informUser((IStatus)object);
            }
        }
        object6 = this;
        synchronized (object6) {
            this.fCategories.clear();
            this.fCategories.addAll(list);
            object5 = hashMap.keySet();
            this.fDescriptorsByPartition.keySet().retainAll((Collection<?>)object5);
            this.fPublicDescriptorsByPartition.keySet().retainAll((Collection<?>)object5);
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = (List)this.fDescriptorsByPartition.get(object3);
                object = (List)hashMap.get(object3);
                if (object2 != null) {
                    object2.clear();
                    object2.addAll(object);
                    continue;
                }
                this.fDescriptorsByPartition.put(object3, object);
                this.fPublicDescriptorsByPartition.put(object3, Collections.unmodifiableList(object));
            }
            this.fDescriptors.clear();
            this.fDescriptors.addAll(arrayList2);
        }
    }

    private List getCategories(List list) {
        Object object;
        Object object2;
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("content_assist_disabled_computers");
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        string = iPreferenceStore.getString("content_assist_category_order");
        stringTokenizer = new StringTokenizer(string, "\u0000");
        while (stringTokenizer.hasMoreTokens()) {
            object2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            object = ((StringTokenizer)object2).nextToken();
            int n = Integer.parseInt(((StringTokenizer)object2).nextToken());
            hashMap.put(object, new Integer(n));
        }
        object2 = new ArrayList();
        object = list.iterator();
        while (object.hasNext()) {
            Object object3;
            IConfigurationElement iConfigurationElement = (IConfigurationElement)object.next();
            try {
                if (!iConfigurationElement.getName().equals("proposalCategory")) continue;
                object.remove();
                CompletionProposalCategory completionProposalCategory = new CompletionProposalCategory(iConfigurationElement, this);
                object2.add(completionProposalCategory);
                completionProposalCategory.setIncluded(!hashSet.contains(completionProposalCategory.getId()));
                object3 = (Integer)hashMap.get(completionProposalCategory.getId());
                if (object3 == null) continue;
                int n = (Integer)object3;
                boolean bl = n < 65535;
                completionProposalCategory.setSeparateCommand(bl);
                completionProposalCategory.setSortOrder(n);
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                object3 = new Object[]{iConfigurationElement.toString()};
                String string2 = Messages.format(JavaTextMessages.CompletionProposalComputerRegistry_invalid_message, (Object[])object3);
                Status status = new Status(2, JavaPlugin.getPluginId(), 0, string2, (Throwable)invalidRegistryObjectException);
                this.informUser((IStatus)status);
            }
        }
        return object2;
    }

    void informUser(CompletionProposalComputerDescriptor completionProposalComputerDescriptor, IStatus iStatus) {
        JavaPlugin.log(iStatus);
        String string = JavaTextMessages.CompletionProposalComputerRegistry_error_dialog_title;
        CompletionProposalCategory completionProposalCategory = completionProposalComputerDescriptor.getCategory();
        IContributor iContributor = completionProposalComputerDescriptor.getContributor();
        Set set = this.getAffectedContributors(completionProposalCategory, iContributor);
        String string2 = iContributor == null ? null : iContributor.getName();
        final String string3 = set.isEmpty() ? Messages.format(JavaTextMessages.CompletionProposalComputerRegistry_messageAvoidanceHint, new Object[]{string2, completionProposalCategory.getDisplayName()}) : Messages.format(JavaTextMessages.CompletionProposalComputerRegistry_messageAvoidanceHintWithWarning, new Object[]{string2, completionProposalCategory.getDisplayName(), this.toString(set)});
        String string4 = iStatus.getMessage();
        MessageDialog messageDialog = new MessageDialog(JavaPlugin.getActiveWorkbenchShell(), string, null, string4, 1, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected Control createCustomArea(Composite composite) {
                Link link = new Link(composite, 0);
                link.setText(string3);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        PreferencesUtil.createPreferenceDialogOn((Shell)this.this$1.getShell(), (String)"org.eclipse.wst.jsdt.ui.preferences.CodeAssistPreferenceAdvanced", null, null).open();
                    }
                });
                GridData gridData = new GridData(4, 1, true, false);
                gridData.widthHint = this.getMinimumMessageWidth();
                link.setLayoutData((Object)gridData);
                return link;
            }
        };
        messageDialog.open();
    }

    private Set getAffectedContributors(CompletionProposalCategory completionProposalCategory, IContributor iContributor) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.getProposalComputerDescriptors().iterator();
        while (iterator.hasNext()) {
            IContributor iContributor2;
            CompletionProposalComputerDescriptor completionProposalComputerDescriptor = (CompletionProposalComputerDescriptor)iterator.next();
            CompletionProposalCategory completionProposalCategory2 = completionProposalComputerDescriptor.getCategory();
            if (!completionProposalCategory2.equals(completionProposalCategory) || (iContributor2 = completionProposalComputerDescriptor.getContributor()) == null || iContributor.equals(iContributor2)) continue;
            hashSet.add(iContributor2.getName());
        }
        return hashSet;
    }

    private Object toString(Collection collection) {
        String string = collection.toString();
        return string.substring(1, string.length() - 1);
    }

    private void informUser(IStatus iStatus) {
        JavaPlugin.log(iStatus);
        String string = JavaTextMessages.CompletionProposalComputerRegistry_error_dialog_title;
        String string2 = iStatus.getMessage();
        MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)string, (String)string2);
    }
}

