/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaDoubleClickSelector;

public class JavaStringDoubleClickSelector
extends JavaDoubleClickSelector {
    private String fPartitioning;

    public JavaStringDoubleClickSelector(String string) {
        this.fPartitioning = string;
    }

    public void doubleClicked(ITextViewer iTextViewer) {
        int n = iTextViewer.getSelectedRange().x;
        if (n < 0) {
            return;
        }
        IDocument iDocument = iTextViewer.getDocument();
        IRegion iRegion = this.match(iDocument, n);
        if (iRegion != null && iRegion.getLength() >= 2) {
            iTextViewer.setSelectedRange(iRegion.getOffset() + 1, iRegion.getLength() - 2);
        } else {
            iRegion = this.selectWord(iDocument, n);
            iTextViewer.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
        }
    }

    private IRegion match(IDocument iDocument, int n) {
        try {
            if (iDocument.getChar(n) == '\"' || iDocument.getChar(n) == '\'' || iDocument.getChar(n - 1) == '\"' || iDocument.getChar(n - 1) == '\'') {
                return TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)n, (boolean)true);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }
}

