/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTypeCompletionProposal;

public class OverrideCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private IJavaProject fJavaProject;
    private String fMethodName;
    private String[] fParamTypes;

    public OverrideCompletionProposal(IJavaProject iJavaProject, ICompilationUnit iCompilationUnit, String string, String[] stringArray, int n, int n2, String string2, String string3) {
        super(string3, iCompilationUnit, n, n2, null, string2, 0);
        Assert.isNotNull((Object)iJavaProject);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)stringArray);
        Assert.isNotNull((Object)iCompilationUnit);
        this.fParamTypes = stringArray;
        this.fMethodName = string;
        this.fJavaProject = iJavaProject;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(" {};");
        this.setReplacementString(stringBuffer.toString());
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        return this.fMethodName;
    }

    protected boolean updateReplacementString(IDocument iDocument, char c, int n, ImportRewrite importRewrite) throws CoreException, BadLocationException {
        IMethodBinding[] iMethodBindingArray;
        AbstractTypeDeclaration abstractTypeDeclaration;
        Document document = new Document(iDocument.get());
        int n2 = n - 1;
        while (n2 >= 0 && Character.isJavaIdentifierPart(document.getChar(n2))) {
            --n2;
        }
        int n3 = n - n2 - 1;
        document.replace(n2 + 1, n3, " ");
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setResolveBindings(true);
        aSTParser.setStatementsRecovery(true);
        aSTParser.setSource(document.get().toCharArray());
        aSTParser.setUnitName(this.fCompilationUnit.getResource().getFullPath().toString());
        aSTParser.setProject(this.fCompilationUnit.getJavaProject());
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST((IProgressMonitor)new NullProgressMonitor());
        ITypeBinding iTypeBinding = null;
        ChildListPropertyDescriptor childListPropertyDescriptor = null;
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, n2 + 1, 0);
        if (aSTNode instanceof AnonymousClassDeclaration) {
            switch (aSTNode.getParent().getNodeType()) {
                case 14: {
                    iTypeBinding = ((ClassInstanceCreation)aSTNode.getParent()).resolveTypeBinding();
                    break;
                }
                case 72: {
                    abstractTypeDeclaration = ((EnumConstantDeclaration)aSTNode.getParent()).resolveConstructorBinding();
                    if (abstractTypeDeclaration == null) break;
                    iTypeBinding = abstractTypeDeclaration.getDeclaringClass();
                }
            }
            childListPropertyDescriptor = AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        } else if (aSTNode instanceof AbstractTypeDeclaration) {
            abstractTypeDeclaration = (AbstractTypeDeclaration)aSTNode;
            childListPropertyDescriptor = abstractTypeDeclaration.getBodyDeclarationsProperty();
            iTypeBinding = abstractTypeDeclaration.resolveBinding();
        }
        if (iTypeBinding != null && (iMethodBindingArray = StubUtility2.getOverridableMethods((abstractTypeDeclaration = ASTRewrite.create((AST)compilationUnit.getAST())).getAST(), iTypeBinding, true)) != null && iMethodBindingArray.length > 0) {
            CodeGenerationSettings codeGenerationSettings;
            ArrayList<IMethodBinding> arrayList = new ArrayList<IMethodBinding>(iMethodBindingArray.length);
            IMethodBinding iMethodBinding = null;
            n2 = 0;
            while (n2 < iMethodBindingArray.length) {
                if (iMethodBindingArray[n2].getName().equals(this.fMethodName) && iMethodBindingArray[n2].getParameterTypes().length == this.fParamTypes.length) {
                    arrayList.add(iMethodBindingArray[n2]);
                }
                ++n2;
            }
            if (arrayList.size() > 1) {
                iMethodBinding = Bindings.findMethodInHierarchy(iTypeBinding, this.fMethodName, this.fParamTypes);
                if (iMethodBinding == null) {
                    codeGenerationSettings = abstractTypeDeclaration.getAST().resolveWellKnownType("java.lang.Object");
                    iMethodBinding = Bindings.findMethodInType((ITypeBinding)codeGenerationSettings, this.fMethodName, this.fParamTypes);
                }
            } else if (arrayList.size() == 1) {
                iMethodBinding = (IMethodBinding)arrayList.get(0);
            }
            if (iMethodBinding != null) {
                codeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fJavaProject);
                ListRewrite listRewrite = abstractTypeDeclaration.getListRewrite(aSTNode, childListPropertyDescriptor);
                String string = iMethodBinding.getKey();
                MethodDeclaration methodDeclaration = null;
                n2 = 0;
                while (n2 < iMethodBindingArray.length) {
                    if (string.equals(iMethodBindingArray[n2].getKey())) {
                        methodDeclaration = StubUtility2.createImplementationStub(this.fCompilationUnit, (ASTRewrite)abstractTypeDeclaration, importRewrite, iMethodBindingArray[n2], iTypeBinding.getName(), iTypeBinding.isInterface(), codeGenerationSettings);
                        if (methodDeclaration == null) break;
                        listRewrite.insertFirst((ASTNode)methodDeclaration, null);
                        break;
                    }
                    ++n2;
                }
                if (methodDeclaration != null) {
                    Document document2 = new Document(this.fCompilationUnit.getBuffer().getContents());
                    IRegion iRegion = document2.getLineInformationOfOffset(this.getReplacementOffset());
                    ITrackedNodePosition iTrackedNodePosition = abstractTypeDeclaration.track(methodDeclaration);
                    String string2 = IndentManipulation.extractIndentString((String)document2.get(iRegion.getOffset(), iRegion.getLength()), (int)codeGenerationSettings.tabWidth, (int)codeGenerationSettings.indentWidth);
                    try {
                        abstractTypeDeclaration.rewriteAST((IDocument)document2, this.fJavaProject.getOptions(true)).apply((IDocument)document2, 2);
                    }
                    catch (MalformedTreeException malformedTreeException) {
                        JavaPlugin.log(malformedTreeException);
                    }
                    catch (BadLocationException badLocationException) {
                        JavaPlugin.log(badLocationException);
                    }
                    this.setReplacementString(IndentManipulation.changeIndent((String)Strings.trimIndentation(document2.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength()), codeGenerationSettings.tabWidth, codeGenerationSettings.indentWidth, false), (int)0, (int)codeGenerationSettings.tabWidth, (int)codeGenerationSettings.indentWidth, (String)string2, (String)TextUtilities.getDefaultLineDelimiter((IDocument)document2)));
                }
            }
        }
        return true;
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

