/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;
import org.osgi.framework.Bundle;

public abstract class AbstractJavaEditorTextHover
implements IJavaEditorTextHover,
ITextHoverExtension {
    private static String fgStyleSheet;
    private IEditorPart fEditor;

    public void setEditor(IEditorPart iEditorPart) {
        this.fEditor = iEditorPart;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput iEditorInput = this.fEditor.getEditorInput();
            if (iEditorInput instanceof IClassFileEditorInput) {
                IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)iEditorInput;
                return iClassFileEditorInput.getClassFile();
            }
            WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
            return workingCopyManager.getWorkingCopy(iEditorInput, false);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        return JavaWordFinder.findWord(iTextViewer.getDocument(), n);
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        if (iRegion.getLength() == 0) {
            return null;
        }
        ICodeAssist iCodeAssist = this.getCodeAssist();
        if (iCodeAssist != null) {
            IJavaElement[] iJavaElementArray;
            block7: {
                block6: {
                    try {
                        iJavaElementArray = iCodeAssist.codeSelect(iRegion.getOffset(), iRegion.getLength());
                        if (iJavaElementArray != null) break block6;
                        return null;
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                }
                int n = iJavaElementArray.length;
                if (n != 0) break block7;
                return null;
            }
            return this.getHoverInfo(iJavaElementArray);
        }
        return null;
    }

    protected String getHoverInfo(IJavaElement[] iJavaElementArray) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    protected static String getStyleSheet() {
        String string;
        if (fgStyleSheet == null) {
            fgStyleSheet = AbstractJavaEditorTextHover.loadStyleSheet();
        }
        if ((string = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.wst.jsdt.ui.javadocfont")[0];
            string = HTMLPrinter.convertTopLevelFont((String)string, (FontData)fontData);
        }
        return string;
    }

    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL uRL = bundle.getEntry("/JavadocHoverStyleSheet.css");
        if (uRL != null) {
            try {
                uRL = FileLocator.toFileURL((URL)uRL);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                StringBuffer stringBuffer = new StringBuffer(200);
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuffer.append(string);
                    stringBuffer.append('\n');
                    string = bufferedReader.readLine();
                }
                return stringBuffer.toString();
            }
            catch (IOException iOException) {
                JavaPlugin.log(iOException);
                return "";
            }
        }
        return null;
    }
}

