/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;

public class MethodsContentProvider
implements IStructuredContentProvider,
IWorkingCopyProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private boolean fShowInheritedMethods;
    private TypeHierarchyLifeCycle fHierarchyLifeCycle;
    private TableViewer fViewer;

    public MethodsContentProvider(TypeHierarchyLifeCycle typeHierarchyLifeCycle) {
        this.fHierarchyLifeCycle = typeHierarchyLifeCycle;
        this.fShowInheritedMethods = false;
        this.fViewer = null;
    }

    public void showInheritedMethods(boolean bl) {
        if (bl != this.fShowInheritedMethods) {
            this.fShowInheritedMethods = bl;
            if (this.fViewer != null) {
                this.fViewer.refresh();
            }
        }
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public boolean isShowInheritedMethods() {
        return this.fShowInheritedMethods;
    }

    private void addAll(Object[] objectArray, List list) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                list.add(objectArray[n]);
                ++n;
            }
        }
    }

    public Object[] getElements(Object object) {
        if (object instanceof IType) {
            IType iType = (IType)object;
            ArrayList arrayList = new ArrayList();
            try {
                ITypeHierarchy iTypeHierarchy = this.fHierarchyLifeCycle.getHierarchy();
                if (this.fShowInheritedMethods && iTypeHierarchy != null) {
                    IType[] iTypeArray = iTypeHierarchy.getAllSupertypes(iType);
                    int n = iTypeArray.length - 1;
                    while (n >= 0) {
                        IType iType2 = iTypeArray[n];
                        if (iType2.exists()) {
                            this.addAll(iType2.getMethods(), arrayList);
                            this.addAll(iType2.getInitializers(), arrayList);
                            this.addAll(iType2.getFields(), arrayList);
                        }
                        --n;
                    }
                }
                if (iType.exists()) {
                    this.addAll(iType.getMethods(), arrayList);
                    this.addAll(iType.getInitializers(), arrayList);
                    this.addAll(iType.getFields(), arrayList);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            return arrayList.toArray();
        }
        return NO_ELEMENTS;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        Assert.isTrue((boolean)(viewer instanceof TableViewer));
        this.fViewer = (TableViewer)viewer;
    }

    public void dispose() {
    }
}

