/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectAllAction;
import org.eclipse.wst.jsdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.EnableMemberFilterAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.FocusOnSelectionAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.FocusOnTypeAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HistoryDropDownAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.MethodsViewer;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ShowQualifiedTypeNamesAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.SubTypeHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.SuperTypeHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ToggleLinkingAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ToggleOrientationAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ToggleViewAction;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TraditionalHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.SelectionProviderMediator;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.wst.jsdt.ui.ITypeHierarchyViewPart;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.actions.CCPActionGroup;
import org.eclipse.wst.jsdt.ui.actions.GenerateActionGroup;
import org.eclipse.wst.jsdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenViewActionGroup;
import org.eclipse.wst.jsdt.ui.actions.RefactorActionGroup;

public class TypeHierarchyViewPart
extends ViewPart
implements ITypeHierarchyViewPart,
IViewPartInputProvider {
    private static final String DIALOGSTORE_HIERARCHYVIEW = "TypeHierarchyViewPart.hierarchyview";
    private static final String DIALOGSTORE_VIEWLAYOUT = "TypeHierarchyViewPart.orientation";
    private static final String DIALOGSTORE_QUALIFIED_NAMES = "TypeHierarchyViewPart.qualifiednames";
    private static final String DIALOGSTORE_LINKEDITORS = "TypeHierarchyViewPart.linkeditors";
    private static final String TAG_INPUT = "input";
    private static final String TAG_VIEW = "view";
    private static final String TAG_LAYOUT = "orientation";
    private static final String TAG_RATIO = "ratio";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_VERTICAL_SCROLL = "vertical_scroll";
    private static final String TAG_QUALIFIED_NAMES = "qualified_names";
    private static final String TAG_EDITOR_LINKING = "link_editors";
    private static final String GROUP_FOCUS = "group.focus";
    private IType fSelectedType = null;
    private IJavaElement fInputElement = null;
    private ArrayList fInputHistory;
    private IMemento fMemento;
    private IDialogSettings fDialogSettings;
    private TypeHierarchyLifeCycle fHierarchyLifeCycle = new TypeHierarchyLifeCycle();
    private ITypeHierarchyLifeCycleListener fTypeHierarchyLifeCycleListener = new ITypeHierarchyLifeCycleListener(){

        public void typeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchyLifeCycle, IType[] iTypeArray) {
            TypeHierarchyViewPart.this.doTypeHierarchyChanged(typeHierarchyLifeCycle, iTypeArray);
        }
    };
    private IPropertyChangeListener fPropertyChangeListener;
    private SelectionProviderMediator fSelectionProviderMediator;
    private ISelectionChangedListener fSelectionChangedListener;
    private IPartListener2 fPartListener;
    private int fCurrentLayout;
    private boolean fInComputeLayout;
    private boolean fLinkingEnabled;
    private boolean fShowQualifiedTypeNames;
    private boolean fSelectInEditor = true;
    private boolean fIsVisible = false;
    private boolean fNeedRefresh;
    private boolean fIsEnableMemberFilter;
    private boolean fIsRefreshRunnablePosted = false;
    private int fCurrentViewerIndex;
    private TypeHierarchyViewer[] fAllViewers;
    private MethodsViewer fMethodsViewer;
    private SashForm fTypeMethodsSplitter;
    private PageBook fViewerbook;
    private PageBook fPagebook;
    private Label fNoHierarchyShownLabel;
    private Label fEmptyTypesViewer;
    private ViewForm fTypeViewerViewForm;
    private ViewForm fMethodViewerViewForm;
    private CLabel fMethodViewerPaneLabel;
    private JavaUILabelProvider fPaneLabelProvider;
    private Composite fParent;
    private ToggleViewAction[] fViewActions;
    private ToggleLinkingAction fToggleLinkingAction;
    private HistoryDropDownAction fHistoryDropDownAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private EnableMemberFilterAction fEnableMemberFilterAction;
    private ShowQualifiedTypeNamesAction fShowQualifiedTypeNamesAction;
    private FocusOnTypeAction fFocusOnTypeAction;
    private FocusOnSelectionAction fFocusOnSelectionAction;
    private CompositeActionGroup fActionGroups;
    private SelectAllAction fSelectAllAction;
    private WorkingSetFilterActionGroup fWorkingSetActionGroup;
    private Job fRestoreStateJob = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public TypeHierarchyViewPart() {
        this.fHierarchyLifeCycle.addChangedListener(this.fTypeHierarchyLifeCycleListener);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TypeHierarchyViewPart.this.doPropertyChange(propertyChangeEvent);
            }
        };
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        this.fIsEnableMemberFilter = false;
        this.fInputHistory = new ArrayList();
        this.fAllViewers = null;
        this.fViewActions = new ToggleViewAction[]{new ToggleViewAction(this, 2), new ToggleViewAction(this, 0), new ToggleViewAction(this, 1)};
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        this.fHistoryDropDownAction = new HistoryDropDownAction(this);
        this.fHistoryDropDownAction.setEnabled(false);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 3), new ToggleOrientationAction(this, 2)};
        this.fEnableMemberFilterAction = new EnableMemberFilterAction(this, false);
        this.fShowQualifiedTypeNamesAction = new ShowQualifiedTypeNamesAction(this, false);
        this.fFocusOnTypeAction = new FocusOnTypeAction(this);
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
        this.fPaneLabelProvider = new JavaUILabelProvider();
        this.fFocusOnSelectionAction = new FocusOnSelectionAction(this);
        this.fPartListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart == TypeHierarchyViewPart.this) {
                    TypeHierarchyViewPart.this.visibilityChanged(true);
                }
            }

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart == TypeHierarchyViewPart.this) {
                    TypeHierarchyViewPart.this.visibilityChanged(false);
                }
            }

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart instanceof IEditorPart) {
                    TypeHierarchyViewPart.this.editorActivated((IEditorPart)iWorkbenchPart);
                }
            }

            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart instanceof IEditorPart) {
                    TypeHierarchyViewPart.this.editorActivated((IEditorPart)iWorkbenchPart);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }
        };
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TypeHierarchyViewPart.this.doSelectionChanged(selectionChangedEvent);
            }
        };
    }

    protected void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (this.fMethodsViewer != null && MembersOrderPreferenceCache.isMemberOrderProperty(propertyChangeEvent.getProperty())) {
            this.fMethodsViewer.refresh();
        }
        if ("workingSetContentChange".equals(string)) {
            this.updateHierarchyViewer(true);
            this.updateTitle();
        }
    }

    private void addHistoryEntry(IJavaElement iJavaElement) {
        if (this.fInputHistory.contains(iJavaElement)) {
            this.fInputHistory.remove(iJavaElement);
        }
        this.fInputHistory.add(0, iJavaElement);
        this.fHistoryDropDownAction.setEnabled(true);
    }

    private void updateHistoryEntries() {
        int n = this.fInputHistory.size() - 1;
        while (n >= 0) {
            IJavaElement iJavaElement = (IJavaElement)this.fInputHistory.get(n);
            if (!iJavaElement.exists()) {
                this.fInputHistory.remove(n);
            }
            --n;
        }
        this.fHistoryDropDownAction.setEnabled(!this.fInputHistory.isEmpty());
    }

    public void gotoHistoryEntry(IJavaElement iJavaElement) {
        if (this.fInputHistory.contains(iJavaElement)) {
            this.updateInput(iJavaElement);
        }
    }

    public IJavaElement[] getHistoryEntries() {
        if (this.fInputHistory.size() > 0) {
            this.updateHistoryEntries();
        }
        return this.fInputHistory.toArray(new IJavaElement[this.fInputHistory.size()]);
    }

    public void setHistoryEntries(IJavaElement[] iJavaElementArray) {
        this.fInputHistory.clear();
        int n = 0;
        while (n < iJavaElementArray.length) {
            this.fInputHistory.add(iJavaElementArray[n]);
            ++n;
        }
        this.updateHistoryEntries();
    }

    public void selectMember(IMember iMember) {
        this.fSelectInEditor = false;
        if (iMember.getElementType() != 7) {
            Control control = this.fMethodsViewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.setFocus();
            }
            this.fMethodsViewer.setSelection((ISelection)new StructuredSelection((Object)iMember), true);
        } else {
            Control control = this.getCurrentViewer().getControl();
            if (control != null && !control.isDisposed()) {
                control.setFocus();
            }
            if (!iMember.equals(this.fSelectedType)) {
                this.getCurrentViewer().setSelection((ISelection)new StructuredSelection((Object)iMember), true);
            }
        }
        this.fSelectInEditor = true;
    }

    public IType getInput() {
        if (this.fInputElement instanceof IType) {
            return (IType)this.fInputElement;
        }
        return null;
    }

    public void setInput(IType iType) {
        this.setInputElement((IJavaElement)iType);
    }

    public IJavaElement getInputElement() {
        return this.fInputElement;
    }

    public void setInputElement(IJavaElement iJavaElement) {
        IMember iMember = null;
        if (iJavaElement != null) {
            if (iJavaElement instanceof IMember) {
                if (iJavaElement.getElementType() != 7) {
                    iMember = (IMember)iJavaElement;
                    iJavaElement = iMember.getDeclaringType();
                }
                if (iJavaElement == null || !iJavaElement.exists()) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)TypeHierarchyMessages.TypeHierarchyViewPart_error_title, (String)TypeHierarchyMessages.TypeHierarchyViewPart_error_message);
                    return;
                }
            } else {
                int n = iJavaElement.getElementType();
                if (n != 2 && n != 3 && n != 4) {
                    iJavaElement = null;
                    JavaPlugin.logErrorMessage("Invalid type hierarchy input type.");
                }
            }
        }
        if (iJavaElement != null && !iJavaElement.equals(this.fInputElement)) {
            this.addHistoryEntry(iJavaElement);
        }
        this.updateInput(iJavaElement);
        if (iMember != null) {
            this.selectMember(iMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateInput(IJavaElement iJavaElement) {
        IJavaElement iJavaElement2 = this.fInputElement;
        TypeHierarchyViewPart typeHierarchyViewPart = this;
        synchronized (typeHierarchyViewPart) {
            if (this.fRestoreStateJob != null) {
                this.fRestoreStateJob.cancel();
                try {
                    try {
                        this.fRestoreStateJob.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    Object var4_7 = null;
                    this.fRestoreStateJob = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.fRestoreStateJob = null;
                    throw throwable;
                }
            }
        }
        this.processOutstandingEvents();
        if (iJavaElement == null) {
            this.clearInput();
            return;
        }
        this.fInputElement = iJavaElement;
        this.fNoHierarchyShownLabel.setText(Messages.format(TypeHierarchyMessages.TypeHierarchyViewPart_createinput, iJavaElement.getElementName()));
        try {
            this.fHierarchyLifeCycle.ensureRefreshedTypeHierarchy(iJavaElement, (IRunnableContext)JavaPlugin.getActiveWorkbenchWindow());
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getSite().getShell(), TypeHierarchyMessages.TypeHierarchyViewPart_exception_title, TypeHierarchyMessages.TypeHierarchyViewPart_exception_message);
            this.clearInput();
            return;
        }
        catch (InterruptedException interruptedException) {
            this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.TypeHierarchyViewPart_empty);
            return;
        }
        if (iJavaElement.getElementType() != 7) {
            this.setHierarchyMode(2);
        }
        this.fSelectInEditor = false;
        this.setMemberFilter(null);
        this.internalSelectType(null, false);
        this.fIsEnableMemberFilter = false;
        if (!iJavaElement.equals(iJavaElement2)) {
            this.updateHierarchyViewer(true);
        }
        typeHierarchyViewPart = this.getSelectableType(iJavaElement);
        this.internalSelectType((IMember)typeHierarchyViewPart, true);
        this.updateMethodViewer((IType)typeHierarchyViewPart);
        this.updateToolbarButtons();
        this.updateTitle();
        this.showMembersInHierarchy(false);
        this.fPagebook.showPage((Control)this.fTypeMethodsSplitter);
        this.fSelectInEditor = true;
    }

    private void processOutstandingEvents() {
        Display display = this.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.update();
        }
    }

    private void clearInput() {
        this.fInputElement = null;
        this.fHierarchyLifeCycle.freeHierarchy();
        this.updateHierarchyViewer(false);
        this.updateToolbarButtons();
    }

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void dispose() {
        this.fHierarchyLifeCycle.freeHierarchy();
        this.fHierarchyLifeCycle.removeChangedListener(this.fTypeHierarchyLifeCycleListener);
        this.fPaneLabelProvider.dispose();
        if (this.fMethodsViewer != null) {
            this.fMethodsViewer.dispose();
        }
        if (this.fPropertyChangeListener != null) {
            JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fWorkingSetActionGroup != null) {
            this.fWorkingSetActionGroup.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.getShowInSource();
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz4) {
            return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.wst.jsdt.ui.type_hierarchy_view_context");
        }
        return super.getAdapter(clazz);
    }

    private Control createTypeViewerControl(Composite composite) {
        int n;
        this.fViewerbook = new PageBook(composite, 0);
        KeyListener keyListener = this.createKeyListener();
        SuperTypeHierarchyViewer superTypeHierarchyViewer = new SuperTypeHierarchyViewer((Composite)this.fViewerbook, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.initializeTypesViewer(superTypeHierarchyViewer, keyListener, "org.eclipse.wst.jsdt.ui.TypeHierarchy.supertypes");
        SubTypeHierarchyViewer subTypeHierarchyViewer = new SubTypeHierarchyViewer((Composite)this.fViewerbook, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.initializeTypesViewer(subTypeHierarchyViewer, keyListener, "org.eclipse.wst.jsdt.ui.TypeHierarchy.subtypes");
        TraditionalHierarchyViewer traditionalHierarchyViewer = new TraditionalHierarchyViewer((Composite)this.fViewerbook, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.initializeTypesViewer(traditionalHierarchyViewer, keyListener, "org.eclipse.wst.jsdt.ui.TypeHierarchy.typehierarchy");
        this.fAllViewers = new TypeHierarchyViewer[3];
        this.fAllViewers[0] = superTypeHierarchyViewer;
        this.fAllViewers[1] = subTypeHierarchyViewer;
        this.fAllViewers[2] = traditionalHierarchyViewer;
        try {
            n = this.fDialogSettings.getInt(DIALOGSTORE_HIERARCHYVIEW);
            if (n < 0 || n > 2) {
                n = 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 2;
        }
        this.fEmptyTypesViewer = new Label((Composite)this.fViewerbook, 16576);
        int n2 = 0;
        while (n2 < this.fAllViewers.length) {
            this.fAllViewers[n2].setInput(this.fAllViewers[n2]);
            ++n2;
        }
        this.fCurrentViewerIndex = -1;
        this.setHierarchyMode(n);
        return this.fViewerbook;
    }

    private KeyListener createKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x100000E) {
                    ITypeHierarchy iTypeHierarchy = TypeHierarchyViewPart.this.fHierarchyLifeCycle.getHierarchy();
                    if (iTypeHierarchy != null) {
                        TypeHierarchyViewPart.this.fHierarchyLifeCycle.typeHierarchyChanged(iTypeHierarchy);
                        TypeHierarchyViewPart.this.doTypeHierarchyChangedOnViewers(null);
                    }
                    TypeHierarchyViewPart.this.updateHierarchyViewer(false);
                    return;
                }
            }
        };
    }

    private void initializeTypesViewer(final TypeHierarchyViewer typeHierarchyViewer, KeyListener keyListener, String string) {
        typeHierarchyViewer.getControl().setVisible(false);
        typeHierarchyViewer.getControl().addKeyListener(keyListener);
        typeHierarchyViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                TypeHierarchyViewPart.this.fillTypesViewerContextMenu(typeHierarchyViewer, iMenuManager);
            }
        }, string, this.getSite());
        typeHierarchyViewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
        typeHierarchyViewer.setQualifiedTypeName(this.isQualifiedTypeNamesEnabled());
        typeHierarchyViewer.setWorkingSetFilter(this.fWorkingSetActionGroup.getWorkingSetFilter());
    }

    private Control createMethodViewerControl(Composite composite) {
        this.fMethodsViewer = new MethodsViewer(composite, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.fMethodsViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                TypeHierarchyViewPart.this.fillMethodsViewerContextMenu(iMenuManager);
            }
        }, "org.eclipse.wst.jsdt.ui.TypeHierarchy.members", this.getSite());
        this.fMethodsViewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
        Table table = this.fMethodsViewer.getTable();
        table.addKeyListener(this.createKeyListener());
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                TypeHierarchyViewPart.this.fSelectAllAction.setEnabled(true);
            }

            public void focusLost(FocusEvent focusEvent) {
                TypeHierarchyViewPart.this.fSelectAllAction.setEnabled(false);
            }
        });
        return table;
    }

    private void initDragAndDrop() {
        int n = 0;
        while (n < this.fAllViewers.length) {
            this.addDragAdapters((StructuredViewer)this.fAllViewers[n]);
            this.addDropAdapters((AbstractTreeViewer)this.fAllViewers[n]);
            ++n;
        }
        this.addDragAdapters((StructuredViewer)this.fMethodsViewer);
        this.fMethodsViewer.addDropSupport(0, new Transfer[0], (DropTargetListener)new DropTargetAdapter());
        DropTarget dropTarget = new DropTarget((Control)this.fPagebook, 23);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new TypeHierarchyTransferDropAdapter(this, (AbstractTreeViewer)this.fAllViewers[0]));
    }

    private void addDropAdapters(AbstractTreeViewer abstractTreeViewer) {
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance()};
        int n = 23;
        TransferDropTargetListener[] transferDropTargetListenerArray = new TransferDropTargetListener[]{new TypeHierarchyTransferDropAdapter(this, abstractTreeViewer)};
        abstractTreeViewer.addDropSupport(n, transferArray, (DropTargetListener)new DelegatingDropAdapter(transferDropTargetListenerArray));
    }

    private void addDragAdapters(StructuredViewer structuredViewer) {
        int n = 5;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        TransferDragSourceListener[] transferDragSourceListenerArray = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)structuredViewer), new ResourceTransferDragAdapter((ISelectionProvider)structuredViewer)};
        structuredViewer.addDragSupport(n, transferArray, (DragSourceListener)new JdtViewerDragAdapter(structuredViewer, transferDragSourceListenerArray));
    }

    public void createPartControl(Composite composite) {
        int n;
        this.fParent = composite;
        this.addResizeListener(composite);
        this.fPagebook = new PageBook(composite, 0);
        this.fWorkingSetActionGroup = new WorkingSetFilterActionGroup(this.getSite(), this.fPropertyChangeListener);
        this.fNoHierarchyShownLabel = new Label((Composite)this.fPagebook, 16576);
        this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.TypeHierarchyViewPart_empty);
        this.fTypeMethodsSplitter = new SashForm((Composite)this.fPagebook, 512);
        this.fTypeMethodsSplitter.setVisible(false);
        this.fTypeViewerViewForm = new ViewForm((Composite)this.fTypeMethodsSplitter, 0);
        Control control = this.createTypeViewerControl((Composite)this.fTypeViewerViewForm);
        this.fTypeViewerViewForm.setContent(control);
        this.fMethodViewerViewForm = new ViewForm((Composite)this.fTypeMethodsSplitter, 0);
        this.fTypeMethodsSplitter.setWeights(new int[]{35, 65});
        Control control2 = this.createMethodViewerControl((Composite)this.fMethodViewerViewForm);
        this.fMethodViewerViewForm.setContent(control2);
        this.fMethodViewerPaneLabel = new CLabel((Composite)this.fMethodViewerViewForm, 0);
        this.fMethodViewerViewForm.setTopLeft((Control)this.fMethodViewerPaneLabel);
        ToolBar toolBar = new ToolBar((Composite)this.fMethodViewerViewForm, 0x800040);
        this.fMethodViewerViewForm.setTopCenter((Control)toolBar);
        this.initDragAndDrop();
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.fFocusOnTypeAction);
        this.fNoHierarchyShownLabel.setMenu(menuManager.createContextMenu((Control)this.fNoHierarchyShownLabel));
        this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        try {
            n = this.fDialogSettings.getInt(DIALOGSTORE_VIEWLAYOUT);
            if (n < 0 || n > 3) {
                n = 3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 3;
        }
        this.fCurrentLayout = -1;
        this.setViewLayout(n);
        this.showQualifiedTypeNames(this.fDialogSettings.getBoolean(DIALOGSTORE_QUALIFIED_NAMES));
        this.setLinkingEnabled(this.fDialogSettings.getBoolean(DIALOGSTORE_LINKEDITORS));
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        int n2 = 0;
        while (n2 < this.fViewActions.length) {
            ToggleViewAction toggleViewAction = this.fViewActions[n2];
            iMenuManager.add((IAction)toggleViewAction);
            toggleViewAction.setEnabled(false);
            ++n2;
        }
        iMenuManager.add((IContributionItem)new Separator());
        this.fWorkingSetActionGroup.fillViewMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        MenuManager menuManager2 = new MenuManager(TypeHierarchyMessages.TypeHierarchyViewPart_layout_submenu);
        iMenuManager.add((IContributionItem)menuManager2);
        int n3 = 0;
        while (n3 < this.fToggleOrientationActions.length) {
            menuManager2.add((IAction)this.fToggleOrientationActions[n3]);
            ++n3;
        }
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IAction)this.fShowQualifiedTypeNamesAction);
        iMenuManager.add((IAction)this.fToggleLinkingAction);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.add((IAction)this.fEnableMemberFilterAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.fMethodsViewer.contributeToToolBar(toolBarManager);
        toolBarManager.update(true);
        int n4 = this.fAllViewers.length;
        StructuredViewer[] structuredViewerArray = new StructuredViewer[n4 + 1];
        int n5 = 0;
        while (n5 < n4) {
            structuredViewerArray[n5] = this.fAllViewers[n5];
            ++n5;
        }
        structuredViewerArray[n4] = this.fMethodsViewer;
        this.fSelectionProviderMediator = new SelectionProviderMediator(structuredViewerArray, (StructuredViewer)this.getCurrentViewer());
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fSelectionProviderMediator.addSelectionChangedListener(new StatusBarUpdater(iStatusLineManager));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProviderMediator);
        this.getSite().getPage().addPartListener(this.fPartListener);
        IJavaElement iJavaElement = null;
        if (this.fMemento != null) {
            this.restoreState(this.fMemento, iJavaElement);
        } else if (iJavaElement != null) {
            this.setInputElement(iJavaElement);
        } else {
            this.setViewerVisibility(false);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fPagebook, "org.eclipse.wst.jsdt.ui.type_hierarchy_view_context");
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new NewWizardsActionGroup((IWorkbenchSite)this.getSite()), new OpenEditorActionGroup(this), new OpenViewActionGroup(this), new CCPActionGroup(this), new GenerateActionGroup(this), new RefactorActionGroup(this), new JavaSearchActionGroup(this)});
        this.fActionGroups.fillActionBars(iActionBars);
        this.fSelectAllAction = new SelectAllAction(this.fMethodsViewer);
        iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
    }

    private void addResizeListener(Composite composite) {
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                if (TypeHierarchyViewPart.this.getViewLayout() == 3 && !TypeHierarchyViewPart.this.fInComputeLayout) {
                    TypeHierarchyViewPart.this.setViewLayout(3);
                }
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setViewLayout(int n) {
        if (this.fCurrentLayout == n) {
            if (n != 3) return;
        }
        this.fInComputeLayout = true;
        try {
            boolean bl = false;
            if (this.fMethodViewerViewForm != null && !this.fMethodViewerViewForm.isDisposed() && this.fTypeMethodsSplitter != null && !this.fTypeMethodsSplitter.isDisposed()) {
                boolean bl2 = false;
                if (n == 2) {
                    this.fMethodViewerViewForm.setVisible(false);
                    this.showMembersInHierarchy(false);
                    this.updateMethodViewer(null);
                } else {
                    if (this.fCurrentLayout == 2) {
                        this.fMethodViewerViewForm.setVisible(true);
                        bl = true;
                    }
                    if (n == 3) {
                        if (this.fParent != null && !this.fParent.isDisposed()) {
                            Point point = this.fParent.getSize();
                            if (point.x != 0 && point.y != 0) {
                                Control control = this.fTypeViewerViewForm.getTopLeft();
                                if (control != null && !control.isDisposed() && control.isVisible()) {
                                    point.y -= control.getSize().y;
                                }
                                boolean bl3 = bl2 = point.x > point.y;
                            }
                        }
                        if (this.fCurrentLayout == 3) {
                            boolean bl4;
                            boolean bl5 = bl4 = this.fTypeMethodsSplitter.getOrientation() == 256;
                            if (bl4 == bl2) {
                                Object var6_7 = null;
                                this.fInComputeLayout = false;
                                return;
                            }
                        }
                    } else if (n == 1) {
                        bl2 = true;
                    }
                    this.fTypeMethodsSplitter.setOrientation(bl2 ? 256 : 512);
                }
                this.updateMainToolbar(bl2);
                this.fTypeMethodsSplitter.layout();
            }
            if (bl) {
                this.updateMethodViewer(this.fSelectedType);
            }
            this.fDialogSettings.put(DIALOGSTORE_VIEWLAYOUT, n);
            this.fCurrentLayout = n;
            this.updateCheckedState();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.fInComputeLayout = false;
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.fInComputeLayout = false;
            return;
        }
    }

    public int getViewLayout() {
        return this.fCurrentLayout;
    }

    private void updateCheckedState() {
        int n = 0;
        while (n < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[n].setChecked(this.getViewLayout() == this.fToggleOrientationActions[n].getOrientation());
            ++n;
        }
    }

    private void updateMainToolbar(boolean bl) {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        if (bl) {
            this.clearMainToolBar(iToolBarManager);
            ToolBar toolBar = new ToolBar((Composite)this.fTypeViewerViewForm, 0x800040);
            this.fillMainToolBar((IToolBarManager)new ToolBarManager(toolBar));
            this.fTypeViewerViewForm.setTopLeft((Control)toolBar);
        } else {
            this.fTypeViewerViewForm.setTopLeft(null);
            this.fillMainToolBar(iToolBarManager);
        }
    }

    private void fillMainToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.removeAll();
        int n = 0;
        while (n < this.fViewActions.length) {
            iToolBarManager.add((IAction)this.fViewActions[n]);
            ++n;
        }
        iToolBarManager.add((IAction)this.fHistoryDropDownAction);
        iToolBarManager.update(false);
    }

    private void clearMainToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.removeAll();
        iToolBarManager.update(false);
    }

    private void fillTypesViewerContextMenu(TypeHierarchyViewer typeHierarchyViewer, IMenuManager iMenuManager) {
        JavaPlugin.createStandardGroups(iMenuManager);
        iMenuManager.appendToGroup("group.show", (IContributionItem)new Separator(GROUP_FOCUS));
        typeHierarchyViewer.contributeToContextMenu(iMenuManager);
        if (this.fFocusOnSelectionAction.canActionBeAdded()) {
            iMenuManager.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnSelectionAction);
        }
        iMenuManager.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnTypeAction);
        this.fActionGroups.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroups.fillContextMenu(iMenuManager);
        this.fActionGroups.setContext(null);
    }

    private void fillMethodsViewerContextMenu(IMenuManager iMenuManager) {
        JavaPlugin.createStandardGroups(iMenuManager);
        this.fMethodsViewer.contributeToContextMenu(iMenuManager);
        this.fActionGroups.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroups.fillContextMenu(iMenuManager);
        this.fActionGroups.setContext(null);
    }

    private void setViewerVisibility(boolean bl) {
        if (bl) {
            this.fViewerbook.showPage(this.getCurrentViewer().getControl());
        } else {
            this.fViewerbook.showPage((Control)this.fEmptyTypesViewer);
        }
    }

    private void setMemberFilter(IMember[] iMemberArray) {
        Assert.isNotNull((Object)this.fAllViewers);
        int n = 0;
        while (n < this.fAllViewers.length) {
            this.fAllViewers[n].setMemberFilter(iMemberArray);
            ++n;
        }
    }

    private IType getSelectableType(IJavaElement iJavaElement) {
        if (iJavaElement.getElementType() != 7) {
            return this.getCurrentViewer().getTreeRootType();
        }
        return (IType)iJavaElement;
    }

    private void internalSelectType(IMember iMember, boolean bl) {
        TypeHierarchyViewer typeHierarchyViewer = this.getCurrentViewer();
        typeHierarchyViewer.removePostSelectionChangedListener(this.fSelectionChangedListener);
        typeHierarchyViewer.setSelection((ISelection)(iMember != null ? new StructuredSelection((Object)iMember) : StructuredSelection.EMPTY), bl);
        typeHierarchyViewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
    }

    private void updateHierarchyViewer(final boolean bl) {
        if (this.fInputElement == null) {
            this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.TypeHierarchyViewPart_empty);
            this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        } else if (this.getCurrentViewer().containsElements() != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    TypeHierarchyViewPart.this.getCurrentViewer().updateContent(bl);
                }
            };
            BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
            if (!this.isChildVisible((Composite)this.fViewerbook, this.getCurrentViewer().getControl())) {
                this.setViewerVisibility(true);
            }
        } else {
            this.fEmptyTypesViewer.setText(Messages.format(TypeHierarchyMessages.TypeHierarchyViewPart_nodecl, this.fInputElement.getElementName()));
            this.setViewerVisibility(false);
        }
    }

    private void updateMethodViewer(final IType iType) {
        if (!this.fIsEnableMemberFilter && this.fCurrentLayout != 2) {
            if (iType == this.fMethodsViewer.getInput()) {
                if (iType != null) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            TypeHierarchyViewPart.this.fMethodsViewer.refresh();
                        }
                    };
                    BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
                }
            } else {
                if (iType != null) {
                    this.fMethodViewerPaneLabel.setText(this.fPaneLabelProvider.getText(iType));
                    this.fMethodViewerPaneLabel.setImage(this.fPaneLabelProvider.getImage(iType));
                } else {
                    this.fMethodViewerPaneLabel.setText("");
                    this.fMethodViewerPaneLabel.setImage(null);
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        TypeHierarchyViewPart.this.fMethodsViewer.setInput(iType);
                    }
                };
                BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
            }
        }
    }

    protected void doSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelectionProvider() == this.fMethodsViewer) {
            this.methodSelectionChanged(selectionChangedEvent.getSelection());
        } else {
            this.typeSelectionChanged(selectionChangedEvent.getSelection());
        }
    }

    private void methodSelectionChanged(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)iSelection).toList();
            int n = list.size();
            if (this.fIsEnableMemberFilter) {
                IMember[] iMemberArray = null;
                if (n > 0) {
                    iMemberArray = new IMember[n];
                    list.toArray(iMemberArray);
                }
                this.setMemberFilter(iMemberArray);
                this.updateHierarchyViewer(true);
                this.updateTitle();
                this.internalSelectType((IMember)this.fSelectedType, true);
            }
            if (n == 1 && this.fSelectInEditor) {
                this.revealElementInEditor(list.get(0), (StructuredViewer)this.fMethodsViewer);
            }
        }
    }

    private void typeSelectionChanged(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)iSelection).toList();
            int n = list.size();
            if (n != 0) {
                ArrayList arrayList = new ArrayList(n);
                int n2 = n - 1;
                while (n2 >= 0) {
                    Object e = list.get(n2);
                    if (e instanceof IType && !arrayList.contains(e)) {
                        arrayList.add(e);
                    }
                    --n2;
                }
                if (arrayList.size() == 1) {
                    this.fSelectedType = (IType)arrayList.get(0);
                    this.updateMethodViewer(this.fSelectedType);
                } else {
                    arrayList.size();
                }
                if (n == 1 && this.fSelectInEditor) {
                    this.revealElementInEditor(list.get(0), (StructuredViewer)this.getCurrentViewer());
                }
            } else {
                this.fSelectedType = null;
                this.updateMethodViewer(null);
            }
        }
    }

    private void revealElementInEditor(Object object, StructuredViewer structuredViewer) {
        if (this.getSite().getPage().getActivePart() != this) {
            return;
        }
        if (this.fSelectionProviderMediator.getViewerInFocus() != structuredViewer) {
            return;
        }
        IEditorPart iEditorPart = EditorUtility.isOpenInEditor(object);
        if (iEditorPart != null && object instanceof IJavaElement) {
            this.getSite().getPage().removePartListener(this.fPartListener);
            this.getSite().getPage().bringToTop((IWorkbenchPart)iEditorPart);
            EditorUtility.revealInEditor(iEditorPart, (IJavaElement)object);
            this.getSite().getPage().addPartListener(this.fPartListener);
        }
    }

    private Display getDisplay() {
        if (this.fPagebook != null && !this.fPagebook.isDisposed()) {
            return this.fPagebook.getDisplay();
        }
        return null;
    }

    private boolean isChildVisible(Composite composite, Control control) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] == control && controlArray[n].isVisible()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void updateTitle() {
        String string;
        String string2;
        String string3 = this.getCurrentViewer().getTitle();
        if (this.fInputElement != null) {
            IWorkingSet iWorkingSet = this.fWorkingSetActionGroup.getWorkingSet();
            if (iWorkingSet == null) {
                Object[] objectArray = new String[]{string3, JavaElementLabels.getElementLabel(this.fInputElement, JavaElementLabels.ALL_DEFAULT)};
                string2 = Messages.format(TypeHierarchyMessages.TypeHierarchyViewPart_title, objectArray);
                string = Messages.format(TypeHierarchyMessages.TypeHierarchyViewPart_tooltip, objectArray);
            } else {
                Object[] objectArray = new String[]{string3, JavaElementLabels.getElementLabel(this.fInputElement, JavaElementLabels.ALL_DEFAULT), iWorkingSet.getLabel()};
                string2 = Messages.format(TypeHierarchyMessages.TypeHierarchyViewPart_ws_title, objectArray);
                string = Messages.format(TypeHierarchyMessages.TypeHierarchyViewPart_ws_tooltip, objectArray);
            }
        } else {
            string2 = "";
            string = string3;
        }
        this.setContentDescription(string2);
        this.setTitleToolTip(string);
    }

    private void updateToolbarButtons() {
        boolean bl = this.fInputElement instanceof IType;
        int n = 0;
        while (n < this.fViewActions.length) {
            ToggleViewAction toggleViewAction = this.fViewActions[n];
            if (toggleViewAction.getViewerIndex() == 2) {
                toggleViewAction.setEnabled(this.fInputElement != null);
            } else {
                toggleViewAction.setEnabled(bl);
            }
            ++n;
        }
    }

    public void setHierarchyMode(int n) {
        Assert.isNotNull((Object)this.fAllViewers);
        if (n < this.fAllViewers.length && this.fCurrentViewerIndex != n) {
            this.fCurrentViewerIndex = n;
            this.updateHierarchyViewer(true);
            if (this.fInputElement != null) {
                ISelection iSelection = this.getCurrentViewer().getSelection();
                if (iSelection == null || iSelection.isEmpty()) {
                    this.internalSelectType((IMember)this.getSelectableType(this.fInputElement), false);
                    iSelection = this.getCurrentViewer().getSelection();
                }
                if (!this.fIsEnableMemberFilter) {
                    this.typeSelectionChanged(iSelection);
                }
            }
            this.updateTitle();
            this.fDialogSettings.put(DIALOGSTORE_HIERARCHYVIEW, n);
            this.getCurrentViewer().getTree().setFocus();
        }
        int n2 = 0;
        while (n2 < this.fViewActions.length) {
            ToggleViewAction toggleViewAction;
            toggleViewAction.setChecked(this.fCurrentViewerIndex == (toggleViewAction = this.fViewActions[n2]).getViewerIndex());
            ++n2;
        }
    }

    public int getHierarchyMode() {
        return this.fCurrentViewerIndex;
    }

    private TypeHierarchyViewer getCurrentViewer() {
        return this.fAllViewers[this.fCurrentViewerIndex];
    }

    public void showMembersInHierarchy(boolean bl) {
        if (bl != this.fIsEnableMemberFilter) {
            this.fIsEnableMemberFilter = bl;
            if (!bl) {
                IType iType = (IType)this.fMethodsViewer.getInput();
                this.setMemberFilter(null);
                this.updateHierarchyViewer(true);
                this.updateTitle();
                if (iType != null && this.getCurrentViewer().isElementShown(iType)) {
                    this.internalSelectType((IMember)iType, true);
                } else if (this.fSelectedType != null) {
                    this.internalSelectType((IMember)this.fSelectedType, true);
                    this.updateMethodViewer(this.fSelectedType);
                }
            } else {
                this.methodSelectionChanged(this.fMethodsViewer.getSelection());
            }
        }
        this.fEnableMemberFilterAction.setChecked(bl);
    }

    public boolean isShowMembersInHierarchy() {
        return this.fIsEnableMemberFilter;
    }

    public void showQualifiedTypeNames(boolean bl) {
        if (bl != this.fShowQualifiedTypeNames) {
            this.fShowQualifiedTypeNames = bl;
            if (this.fAllViewers != null) {
                int n = 0;
                while (n < this.fAllViewers.length) {
                    this.fAllViewers[n].setQualifiedTypeName(bl);
                    ++n;
                }
            }
        }
        this.fShowQualifiedTypeNamesAction.setChecked(bl);
        this.fDialogSettings.put(DIALOGSTORE_QUALIFIED_NAMES, bl);
    }

    public boolean isQualifiedTypeNamesEnabled() {
        return this.fShowQualifiedTypeNames;
    }

    protected void doTypeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchyLifeCycle, final IType[] iTypeArray) {
        if (!this.fIsVisible) {
            this.fNeedRefresh = true;
            return;
        }
        if (this.fIsRefreshRunnablePosted) {
            return;
        }
        Display display = this.getDisplay();
        if (display != null) {
            this.fIsRefreshRunnablePosted = true;
            display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        if (TypeHierarchyViewPart.this.fPagebook != null && !TypeHierarchyViewPart.this.fPagebook.isDisposed()) {
                            TypeHierarchyViewPart.this.doTypeHierarchyChangedOnViewers(iTypeArray);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var1_2 = null;
                        TypeHierarchyViewPart.this.fIsRefreshRunnablePosted = false;
                        throw throwable;
                    }
                    {
                        Object var1_3 = null;
                    }
                    TypeHierarchyViewPart.this.fIsRefreshRunnablePosted = false;
                }
            });
        }
    }

    protected void doTypeHierarchyChangedOnViewers(IType[] iTypeArray) {
        if (this.fHierarchyLifeCycle.getHierarchy() == null || !this.fHierarchyLifeCycle.getHierarchy().exists()) {
            this.clearInput();
        } else if (iTypeArray == null) {
            try {
                this.fHierarchyLifeCycle.ensureRefreshedTypeHierarchy(this.fInputElement, (IRunnableContext)this.getSite().getWorkbenchWindow());
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(invocationTargetException, this.getSite().getShell(), TypeHierarchyMessages.TypeHierarchyViewPart_exception_title, TypeHierarchyMessages.TypeHierarchyViewPart_exception_message);
                this.clearInput();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.fMethodsViewer.refresh();
            this.updateHierarchyViewer(false);
        } else {
            Object object = this.fMethodsViewer.getInput();
            this.fMethodsViewer.refresh();
            this.fMethodViewerPaneLabel.setText(this.fPaneLabelProvider.getText(object));
            this.fMethodViewerPaneLabel.setImage(this.fPaneLabelProvider.getImage(object));
            if (this.getCurrentViewer().isMethodFiltering()) {
                if (iTypeArray.length == 1) {
                    this.getCurrentViewer().refresh(iTypeArray[0]);
                } else {
                    this.updateHierarchyViewer(false);
                }
            } else {
                this.getCurrentViewer().update(iTypeArray, new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"});
            }
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.fMemento = iMemento;
    }

    public void saveState(IMemento iMemento) {
        Object object;
        if (this.fPagebook == null) {
            if (this.fMemento != null) {
                iMemento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fInputElement != null) {
            object = this.fInputElement.getHandleIdentifier();
            iMemento.putString(TAG_INPUT, (String)object);
        }
        iMemento.putInteger(TAG_VIEW, this.getHierarchyMode());
        iMemento.putInteger(TAG_LAYOUT, this.getViewLayout());
        iMemento.putInteger(TAG_QUALIFIED_NAMES, this.isQualifiedTypeNamesEnabled() ? 1 : 0);
        iMemento.putInteger(TAG_EDITOR_LINKING, this.isLinkingEnabled() ? 1 : 0);
        object = this.fTypeMethodsSplitter.getWeights();
        reference var3_3 = object[0] * 1000 / (object[0] + object[1]);
        iMemento.putInteger(TAG_RATIO, (int)var3_3);
        ScrollBar scrollBar = this.getCurrentViewer().getTree().getVerticalBar();
        int n = scrollBar != null ? scrollBar.getSelection() : 0;
        iMemento.putInteger(TAG_VERTICAL_SCROLL, n);
        IJavaElement iJavaElement = (IJavaElement)((IStructuredSelection)this.getCurrentViewer().getSelection()).getFirstElement();
        if (iJavaElement != null) {
            iMemento.putString(TAG_SELECTION, iJavaElement.getHandleIdentifier());
        }
        this.fWorkingSetActionGroup.saveState(iMemento);
        this.fMethodsViewer.saveState(iMemento);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState(final IMemento iMemento, IJavaElement iJavaElement) {
        IJavaElement iJavaElement2 = iJavaElement;
        String string = iMemento.getString(TAG_INPUT);
        if (string != null && (iJavaElement2 = JavaCore.create((String)string)) != null && !iJavaElement2.exists()) {
            iJavaElement2 = null;
        }
        if (iJavaElement2 == null) {
            this.doRestoreState(iMemento, iJavaElement2);
        } else {
            final IJavaElement iJavaElement3 = iJavaElement2;
            TypeHierarchyViewPart typeHierarchyViewPart = this;
            synchronized (typeHierarchyViewPart) {
                String string2 = Messages.format(TypeHierarchyMessages.TypeHierarchyViewPart_restoreinput, iJavaElement3.getElementName());
                this.fNoHierarchyShownLabel.setText(string2);
                this.fRestoreStateJob = new Job(string2){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        try {
                            TypeHierarchyViewPart.this.doRestoreInBackground(iMemento, iJavaElement3, iProgressMonitor);
                        }
                        catch (JavaModelException javaModelException) {
                            return javaModelException.getStatus();
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.fRestoreStateJob.schedule();
            }
        }
    }

    private void doRestoreInBackground(final IMemento iMemento, final IJavaElement iJavaElement, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.fHierarchyLifeCycle.doHierarchyRefresh(iJavaElement, iProgressMonitor);
        final boolean bl = !iProgressMonitor.isCanceled();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (TypeHierarchyViewPart.this.fPagebook != null && !TypeHierarchyViewPart.this.fPagebook.isDisposed()) {
                    if (bl) {
                        TypeHierarchyViewPart.this.doRestoreState(iMemento, iJavaElement);
                    } else {
                        TypeHierarchyViewPart.this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.TypeHierarchyViewPart_empty);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doRestoreState(IMemento iMemento, IJavaElement iJavaElement) {
        Integer n;
        ScrollBar scrollBar;
        Integer n2;
        Integer n3;
        Integer n4;
        Object object = this;
        synchronized (object) {
            if (this.fRestoreStateJob == null) {
                return;
            }
            this.fRestoreStateJob = null;
        }
        this.fWorkingSetActionGroup.restoreState(iMemento);
        this.setInputElement(iJavaElement);
        object = iMemento.getInteger(TAG_VIEW);
        if (object != null) {
            this.setHierarchyMode((Integer)object);
        }
        if ((n4 = iMemento.getInteger(TAG_LAYOUT)) != null) {
            this.setViewLayout(n4);
        }
        if ((n3 = iMemento.getInteger(TAG_EDITOR_LINKING)) != null) {
            this.setLinkingEnabled(n3 != 0);
        }
        if ((n2 = iMemento.getInteger(TAG_QUALIFIED_NAMES)) != null) {
            this.showQualifiedTypeNames(n2 != 0);
        }
        this.updateCheckedState();
        Integer n5 = iMemento.getInteger(TAG_RATIO);
        if (n5 != null) {
            this.fTypeMethodsSplitter.setWeights(new int[]{n5, 1000 - n5});
        }
        if ((scrollBar = this.getCurrentViewer().getTree().getVerticalBar()) != null && (n = iMemento.getInteger(TAG_VERTICAL_SCROLL)) != null) {
            scrollBar.setSelection(n.intValue());
        }
        this.fMethodsViewer.restoreState(iMemento);
    }

    protected void visibilityChanged(boolean bl) {
        this.fIsVisible = bl;
        if (bl && this.fNeedRefresh) {
            this.doTypeHierarchyChangedOnViewers(null);
        }
        this.fNeedRefresh = false;
    }

    protected void editorActivated(IEditorPart iEditorPart) {
        IType iType;
        IJavaElement iJavaElement;
        if (!this.isLinkingEnabled()) {
            return;
        }
        if (this.fInputElement == null) {
            return;
        }
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iJavaElement = (IJavaElement)iEditorInput.getAdapter((Class)clazz)) instanceof ITypeRoot && (iType = ((ITypeRoot)iJavaElement).findPrimaryType()) != null) {
            this.internalSelectType((IMember)iType, true);
            if (this.getCurrentViewer().getSelection().isEmpty()) {
                this.updateMethodViewer(null);
            } else {
                this.updateMethodViewer(iType);
            }
        }
    }

    public Object getViewPartInput() {
        return this.fInputElement;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, TypeHierarchyViewPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    public void setLinkingEnabled(boolean bl) {
        IEditorPart iEditorPart;
        IWorkbenchPartSite iWorkbenchPartSite;
        this.fLinkingEnabled = bl;
        this.fToggleLinkingAction.setChecked(bl);
        this.fDialogSettings.put(DIALOGSTORE_LINKEDITORS, bl);
        if (bl && (iWorkbenchPartSite = this.getSite()) != null && (iEditorPart = iWorkbenchPartSite.getPage().getActiveEditor()) != null) {
            this.editorActivated(iEditorPart);
        }
    }

    public void clearNeededRefresh() {
        this.fNeedRefresh = false;
    }
}

