/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ViewHistory;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

class HistoryListAction
extends Action {
    private ViewHistory fHistory;

    public HistoryListAction(ViewHistory viewHistory) {
        super(null, 8);
        this.fHistory = viewHistory;
        this.fHistory.configureHistoryListAction((IAction)this);
    }

    public void run() {
        HistoryListDialog historyListDialog = new HistoryListDialog();
        if (historyListDialog.open() == 0) {
            this.fHistory.setHistoryEntries(historyListDialog.getRemaining(), historyListDialog.getResult());
            this.fHistory.setMaxEntries(historyListDialog.getMaxEntries());
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private static final int MAX_MAX_ENTRIES = 100;
        private ListDialogField fHistoryList;
        private StringDialogField fMaxEntriesField;
        private int fMaxEntries;
        private Object fResult;

        private HistoryListDialog() {
            super(HistoryListAction.this.fHistory.getShell());
            this.setTitle(HistoryListAction.this.fHistory.getHistoryListDialogTitle());
            this.createHistoryList();
            this.createMaxEntriesField();
            this.setHelpAvailable(false);
        }

        private void createHistoryList() {
            IListAdapter iListAdapter = new IListAdapter(this){
                final /* synthetic */ HistoryListDialog this$1;
                {
                    this.this$1 = historyListDialog;
                }

                public void customButtonPressed(ListDialogField listDialogField, int n) {
                    HistoryListDialog.access$0(this.this$1, n);
                }

                public void selectionChanged(ListDialogField listDialogField) {
                    HistoryListDialog.access$1(this.this$1);
                }

                public void doubleClicked(ListDialogField listDialogField) {
                    HistoryListDialog.access$2(this.this$1);
                }
            };
            String[] stringArray = new String[]{JavaUIMessages.HistoryListAction_remove, JavaUIMessages.HistoryListAction_remove_all};
            TestRunLabelProvider testRunLabelProvider = new TestRunLabelProvider();
            this.fHistoryList = new ListDialogField(iListAdapter, stringArray, (ILabelProvider)testRunLabelProvider);
            this.fHistoryList.setLabelText(HistoryListAction.this.fHistory.getHistoryListDialogMessage());
            List list = HistoryListAction.this.fHistory.getHistoryEntries();
            this.fHistoryList.setElements(list);
            Object object = HistoryListAction.this.fHistory.getCurrentEntry();
            StructuredSelection structuredSelection = object != null ? new StructuredSelection(object) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)structuredSelection);
        }

        private void createMaxEntriesField() {
            this.fMaxEntriesField = new StringDialogField();
            this.fMaxEntriesField.setLabelText(HistoryListAction.this.fHistory.getMaxEntriesMessage());
            this.fMaxEntriesField.setDialogFieldListener(new IDialogFieldListener(this){
                final /* synthetic */ HistoryListDialog this$1;
                {
                    this.this$1 = historyListDialog;
                }

                public void dialogFieldChanged(DialogField dialogField) {
                    boolean bl;
                    String string = HistoryListDialog.access$3(this.this$1).getText();
                    try {
                        HistoryListDialog.access$4(this.this$1, Integer.parseInt(string));
                        bl = HistoryListDialog.access$5(this.this$1) > 0 && HistoryListDialog.access$5(this.this$1) < 100;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    if (bl) {
                        HistoryListDialog.access$6(this.this$1, StatusInfo.OK_STATUS);
                    } else {
                        HistoryListDialog.access$6(this.this$1, new StatusInfo(4, Messages.format(JavaUIMessages.HistoryListAction_max_entries_constraint, Integer.toString(100))));
                    }
                }
            });
            this.fMaxEntriesField.setText(Integer.toString(HistoryListAction.this.fHistory.getMaxEntries()));
        }

        protected Control createDialogArea(Composite composite) {
            this.initializeDialogUnits((Control)composite);
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayoutData((Object)new GridData(1808));
            composite3.setFont(composite2.getFont());
            LayoutUtil.doDefaultLayout(composite3, new DialogField[]{this.fHistoryList, new Separator()}, true);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            Composite composite4 = new Composite(composite3, 0);
            composite4.setLayoutData((Object)new GridData(4, 4, true, false));
            LayoutUtil.doDefaultLayout(composite4, new DialogField[]{this.fMaxEntriesField}, false);
            LayoutUtil.setHorizontalGrabbing((Control)this.fMaxEntriesField.getTextControl(null));
            HistoryListDialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        private void doCustomButtonPressed(int n) {
            switch (n) {
                case 0: {
                    this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
                    this.fHistoryList.selectFirstElement();
                    break;
                }
                case 1: {
                    this.fHistoryList.removeAllElements();
                }
            }
        }

        private void doDoubleClicked() {
            this.okPressed();
        }

        private void doSelectionChanged() {
            List list = this.fHistoryList.getSelectedElements();
            this.fResult = list.size() >= 1 ? list.get(0) : null;
            this.fHistoryList.enableButton(0, list.size() != 0);
        }

        public Object getResult() {
            return this.fResult;
        }

        public List getRemaining() {
            return this.fHistoryList.getElements();
        }

        public int getMaxEntries() {
            return this.fMaxEntries;
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }

        static /* synthetic */ void access$0(HistoryListDialog historyListDialog, int n) {
            historyListDialog.doCustomButtonPressed(n);
        }

        static /* synthetic */ void access$1(HistoryListDialog historyListDialog) {
            historyListDialog.doSelectionChanged();
        }

        static /* synthetic */ void access$2(HistoryListDialog historyListDialog) {
            historyListDialog.doDoubleClicked();
        }

        static /* synthetic */ StringDialogField access$3(HistoryListDialog historyListDialog) {
            return historyListDialog.fMaxEntriesField;
        }

        static /* synthetic */ void access$4(HistoryListDialog historyListDialog, int n) {
            historyListDialog.fMaxEntries = n;
        }

        static /* synthetic */ int access$5(HistoryListDialog historyListDialog) {
            return historyListDialog.fMaxEntries;
        }

        static /* synthetic */ void access$6(HistoryListDialog historyListDialog, IStatus iStatus) {
            historyListDialog.updateStatus(iStatus);
        }
    }

    private final class TestRunLabelProvider
    extends LabelProvider {
        private final HashMap fImages = new HashMap();

        private TestRunLabelProvider() {
        }

        public String getText(Object object) {
            return HistoryListAction.this.fHistory.getText(object);
        }

        public Image getImage(Object object) {
            ImageDescriptor imageDescriptor = HistoryListAction.this.fHistory.getImageDescriptor(object);
            return this.getCachedImage(imageDescriptor);
        }

        private Image getCachedImage(ImageDescriptor imageDescriptor) {
            Object v = this.fImages.get(imageDescriptor);
            if (v != null) {
                return (Image)v;
            }
            Image image = imageDescriptor.createImage((Device)HistoryListAction.this.fHistory.getShell().getDisplay());
            this.fImages.put(imageDescriptor, image);
            return image;
        }

        public void dispose() {
            Iterator iterator = this.fImages.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            this.fImages.clear();
        }
    }
}

