/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public class ProblemTableViewer
extends TableViewer
implements ResourceToItemsMapper.IContentViewerAccessor {
    protected ResourceToItemsMapper fResourceToItemsMapper;

    public ProblemTableViewer(Composite composite) {
        super(composite);
        this.initMapper();
    }

    public ProblemTableViewer(Composite composite, int n) {
        super(composite, n);
        this.initMapper();
    }

    public ProblemTableViewer(Table table) {
        super(table);
        this.initMapper();
    }

    private void initMapper() {
        this.fResourceToItemsMapper = new ResourceToItemsMapper(this);
    }

    public void doUpdateItem(Widget widget) {
        this.doUpdateItem(widget, widget.getData(), true);
    }

    protected void mapElement(Object object, Widget widget) {
        super.mapElement(object, widget);
        if (widget instanceof Item) {
            this.fResourceToItemsMapper.addToMap(object, (Item)widget);
        }
    }

    protected void unmapElement(Object object, Widget widget) {
        if (widget instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(object, (Item)widget);
        }
        super.unmapElement(object, widget);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray;
        if (labelProviderChangedEvent instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && !(objectArray = (Object[])labelProviderChangedEvent).isMarkerChange() && this.canIgnoreChangesFromAnnotionModel()) {
            return;
        }
        objectArray = labelProviderChangedEvent.getElements();
        if (objectArray != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)object);
                } else {
                    arrayList.add(object);
                }
                ++n;
            }
            if (arrayList.isEmpty()) {
                return;
            }
            labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)labelProviderChangedEvent.getSource(), arrayList.toArray());
        }
        super.handleLabelProviderChanged(labelProviderChangedEvent);
    }

    private boolean canIgnoreChangesFromAnnotionModel() {
        IContentProvider iContentProvider = this.getContentProvider();
        return iContentProvider instanceof IWorkingCopyProvider && !((IWorkingCopyProvider)iContentProvider).providesWorkingCopies();
    }
}

