/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class SelectionProviderMediator
implements IPostSelectionProvider {
    private StructuredViewer[] fViewers;
    private StructuredViewer fViewerInFocus;
    private ListenerList fSelectionChangedListeners;
    private ListenerList fPostSelectionChangedListeners;

    public SelectionProviderMediator(StructuredViewer[] structuredViewerArray, StructuredViewer structuredViewer) {
        Assert.isNotNull((Object)structuredViewerArray);
        this.fViewers = structuredViewerArray;
        InternalListener internalListener = new InternalListener();
        this.fSelectionChangedListeners = new ListenerList();
        this.fPostSelectionChangedListeners = new ListenerList();
        this.fViewerInFocus = structuredViewer;
        int n = 0;
        while (n < this.fViewers.length) {
            StructuredViewer structuredViewer2 = this.fViewers[n];
            structuredViewer2.addSelectionChangedListener((ISelectionChangedListener)internalListener);
            structuredViewer2.addPostSelectionChangedListener((ISelectionChangedListener)new InternalPostSelectionListener());
            Control control = structuredViewer2.getControl();
            control.addFocusListener((FocusListener)internalListener);
            ++n;
        }
    }

    private void doFocusChanged(Widget widget) {
        int n = 0;
        while (n < this.fViewers.length) {
            if (this.fViewers[n].getControl() == widget) {
                this.propagateFocusChanged(this.fViewers[n]);
                return;
            }
            ++n;
        }
    }

    final void doPostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelectionProvider iSelectionProvider = selectionChangedEvent.getSelectionProvider();
        if (iSelectionProvider == this.fViewerInFocus) {
            this.firePostSelectionChanged();
        }
    }

    final void doSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelectionProvider iSelectionProvider = selectionChangedEvent.getSelectionProvider();
        if (iSelectionProvider == this.fViewerInFocus) {
            this.fireSelectionChanged();
        }
    }

    final void propagateFocusChanged(StructuredViewer structuredViewer) {
        if (structuredViewer != this.fViewerInFocus) {
            this.fViewerInFocus = structuredViewer;
            this.fireSelectionChanged();
            this.firePostSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        if (this.fSelectionChangedListeners != null) {
            SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] objectArray = this.fSelectionChangedListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
                iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                ++n;
            }
        }
    }

    private void firePostSelectionChanged() {
        if (this.fPostSelectionChangedListeners != null) {
            SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] objectArray = this.fPostSelectionChangedListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
                iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                ++n;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionChangedListeners.add((Object)iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionChangedListeners.remove((Object)iSelectionChangedListener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPostSelectionChangedListeners.add((Object)iSelectionChangedListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPostSelectionChangedListeners.remove((Object)iSelectionChangedListener);
    }

    public ISelection getSelection() {
        if (this.fViewerInFocus != null) {
            return this.fViewerInFocus.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection iSelection) {
        if (this.fViewerInFocus != null) {
            this.fViewerInFocus.setSelection(iSelection);
        }
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        if (this.fViewerInFocus != null) {
            this.fViewerInFocus.setSelection(iSelection, bl);
        }
    }

    public StructuredViewer getViewerInFocus() {
        return this.fViewerInFocus;
    }

    private class InternalListener
    implements ISelectionChangedListener,
    FocusListener {
        private InternalListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            SelectionProviderMediator.this.doSelectionChanged(selectionChangedEvent);
        }

        public void focusGained(FocusEvent focusEvent) {
            SelectionProviderMediator.this.doFocusChanged(focusEvent.widget);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class InternalPostSelectionListener
    implements ISelectionChangedListener {
        private InternalPostSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            SelectionProviderMediator.this.doPostSelectionChanged(selectionChangedEvent);
        }
    }
}

