/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;

public abstract class NewElementWizard
extends Wizard
implements INewWizard {
    private IWorkbench fWorkbench;
    private IStructuredSelection fSelection;

    public NewElementWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected void openResource(final IFile iFile) {
        Display display;
        final IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        JavaPlugin.log(partInitException);
                    }
                }
            });
        }
    }

    protected abstract void finishPage(IProgressMonitor var1) throws InterruptedException, CoreException;

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean canRunForked() {
        return true;
    }

    public abstract IJavaElement getCreatedElement();

    protected void handleFinishException(Shell shell, InvocationTargetException invocationTargetException) {
        String string = NewWizardMessages.NewElementWizard_op_error_title;
        String string2 = NewWizardMessages.NewElementWizard_op_error_message;
        ExceptionHandler.handle(invocationTargetException, shell, string, string2);
    }

    public boolean performFinish() {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
                try {
                    NewElementWizard.this.finishPage(iProgressMonitor);
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException(interruptedException.getMessage());
                }
            }
        };
        try {
            ISchedulingRule iSchedulingRule = null;
            Job job = Job.getJobManager().currentJob();
            if (job != null) {
                iSchedulingRule = job.getRule();
            }
            WorkbenchRunnableAdapter workbenchRunnableAdapter = null;
            workbenchRunnableAdapter = iSchedulingRule != null ? new WorkbenchRunnableAdapter(iWorkspaceRunnable, iSchedulingRule, true) : new WorkbenchRunnableAdapter(iWorkspaceRunnable, this.getSchedulingRule());
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)workbenchRunnableAdapter);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleFinishException(this.getShell(), invocationTargetException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void warnAboutTypeCommentDeprecation() {
        String string = "org.eclipse.wst.jsdt.ui.typecomment.deprecated";
        if (OptionalMessageDialog.isDialogEnabled(string)) {
            boolean bl;
            TemplateStore templateStore = JavaPlugin.getDefault().getTemplateStore();
            boolean bl2 = bl = templateStore.findTemplate("filecomment") != null && templateStore.findTemplate("typecomment") != null;
            if (!bl) {
                OptionalMessageDialog.setDialogEnabled(string, false);
            }
            String string2 = NewWizardMessages.NewElementWizard_typecomment_deprecated_title;
            String string3 = NewWizardMessages.NewElementWizard_typecomment_deprecated_message;
            OptionalMessageDialog.open(string, this.getShell(), string2, null, string3, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        }
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fWorkbench = iWorkbench;
        this.fSelection = iStructuredSelection;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    protected void selectAndReveal(IResource iResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)iResource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
    }
}

