/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;

public class ExclusionInclusionEntryDialog
extends StatusDialog {
    private StringButtonDialogField fExclusionPatternDialog;
    private StatusInfo fExclusionPatternStatus;
    private IContainer fCurrSourceFolder;
    private String fExclusionPattern;
    private List fExistingPatterns;
    private boolean fIsExclusion;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExclusionInclusionEntryDialog(Shell shell, boolean bl, String string, List list, CPListElement cPListElement) {
        super(shell);
        IWorkspaceRoot iWorkspaceRoot;
        IResource iResource;
        String string2;
        String string3;
        this.fIsExclusion = bl;
        this.fExistingPatterns = list;
        if (bl) {
            string3 = string == null ? NewWizardMessages.ExclusionInclusionEntryDialog_exclude_add_title : NewWizardMessages.ExclusionInclusionEntryDialog_exclude_edit_title;
            string2 = Messages.format(NewWizardMessages.ExclusionInclusionEntryDialog_exclude_pattern_label, cPListElement.getPath().makeRelative().toString());
        } else {
            string3 = string == null ? NewWizardMessages.ExclusionInclusionEntryDialog_include_add_title : NewWizardMessages.ExclusionInclusionEntryDialog_include_edit_title;
            string2 = Messages.format(NewWizardMessages.ExclusionInclusionEntryDialog_include_pattern_label, cPListElement.getPath().makeRelative().toString());
        }
        this.setTitle(string3);
        if (string != null) {
            this.fExistingPatterns.remove(string);
        }
        if ((iResource = (iWorkspaceRoot = cPListElement.getJavaProject().getProject().getWorkspace().getRoot()).findMember(cPListElement.getPath())) instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)iResource;
        }
        this.fExclusionPatternStatus = new StatusInfo();
        ExclusionPatternAdapter exclusionPatternAdapter = new ExclusionPatternAdapter();
        this.fExclusionPatternDialog = new StringButtonDialogField(exclusionPatternAdapter);
        this.fExclusionPatternDialog.setLabelText(string2);
        this.fExclusionPatternDialog.setButtonLabel(NewWizardMessages.ExclusionInclusionEntryDialog_pattern_button);
        this.fExclusionPatternDialog.setDialogFieldListener(exclusionPatternAdapter);
        this.fExclusionPatternDialog.enableButton(this.fCurrSourceFolder != null);
        if (string == null) {
            this.fExclusionPatternDialog.setText("");
        } else {
            this.fExclusionPatternDialog.setText(string.toString());
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        int n = this.convertWidthInCharsToPixels(60);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 64);
        if (this.fIsExclusion) {
            label.setText(NewWizardMessages.ExclusionInclusionEntryDialog_exclude_description);
        } else {
            label.setText(NewWizardMessages.ExclusionInclusionEntryDialog_include_description);
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        label.setLayoutData((Object)gridData);
        this.fExclusionPatternDialog.doFillIntoGrid(composite3, 3);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getLabelControl(null), n);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternDialog.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getTextControl(null), n);
        LayoutUtil.setHorizontalGrabbing((Control)this.fExclusionPatternDialog.getTextControl(null));
        this.fExclusionPatternDialog.postSetFocusOnDialogField(composite.getDisplay());
        ExclusionInclusionEntryDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doChangeControlPressed() {
        IPath iPath = this.chooseExclusionPattern();
        if (iPath != null) {
            this.fExclusionPatternDialog.setText(iPath.toString());
        }
    }

    protected void doStatusLineUpdate() {
        this.checkIfPatternValid();
        this.updateStatus(this.fExclusionPatternStatus);
    }

    protected void checkIfPatternValid() {
        String string = this.fExclusionPatternDialog.getText().trim();
        if (string.length() == 0) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.ExclusionInclusionEntryDialog_error_empty);
            return;
        }
        Path path = new Path(string);
        if (path.isAbsolute() || path.getDevice() != null) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.ExclusionInclusionEntryDialog_error_notrelative);
            return;
        }
        if (this.fExistingPatterns.contains(string)) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.ExclusionInclusionEntryDialog_error_exists);
            return;
        }
        this.fExclusionPattern = string;
        this.fExclusionPatternStatus.setOK();
    }

    public String getExclusionPattern() {
        return this.fExclusionPattern;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.exclusion_pattern_dialog_context");
    }

    private IPath chooseExclusionPattern() {
        String string;
        String string2;
        if (this.fIsExclusion) {
            string2 = NewWizardMessages.ExclusionInclusionEntryDialog_ChooseExclusionPattern_title;
            string = NewWizardMessages.ExclusionInclusionEntryDialog_ChooseExclusionPattern_description;
        } else {
            string2 = NewWizardMessages.ExclusionInclusionEntryDialog_ChooseInclusionPattern_title;
            string = NewWizardMessages.ExclusionInclusionEntryDialog_ChooseInclusionPattern_description;
        }
        Path path = new Path(this.fExclusionPatternDialog.getText());
        IPath[] iPathArray = ExclusionInclusionEntryDialog.chooseExclusionPattern(this.getShell(), this.fCurrSourceFolder, string2, string, (IPath)path, false);
        if (iPathArray == null) {
            return null;
        }
        return iPathArray[0];
    }

    public static IPath[] chooseExclusionPattern(Shell shell, IContainer iContainer, String string, String string2, IPath iPath, boolean bl) {
        IPath[] iPathArray;
        int n;
        IContainer iContainer2;
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, bl);
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2);
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        IPath[] iPathArray2 = null;
        if (iPath != null) {
            iContainer2 = iContainer;
            int n2 = iPath.segmentCount();
            n = 0;
            while (n < n2) {
                iPathArray = iContainer2.findMember(iPath.segment(n));
                if (iPathArray != null) {
                    iPathArray2 = iPathArray;
                }
                if (!(iPathArray instanceof IContainer)) break;
                iContainer2 = (IContainer)iPathArray;
                ++n;
            }
        }
        iContainer2 = new ElementTreeSelectionDialog(shell, (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        iContainer2.setTitle(string);
        iContainer2.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        iContainer2.setMessage(string2);
        iContainer2.addFilter((ViewerFilter)typedViewerFilter);
        iContainer2.setInput((Object)iContainer);
        iContainer2.setInitialSelection((Object)iPathArray2);
        iContainer2.setComparator((ViewerComparator)new ResourceComparator(1));
        iContainer2.setHelpAvailable(false);
        if (iContainer2.open() == 0) {
            Object[] objectArray = iContainer2.getResult();
            n = iContainer.getFullPath().segmentCount();
            iPathArray = new IPath[objectArray.length];
            int n3 = 0;
            while (n3 < objectArray.length) {
                IResource iResource = (IResource)objectArray[n3];
                IPath iPath2 = iResource.getFullPath().removeFirstSegments(n).makeRelative();
                if (iResource instanceof IContainer) {
                    iPath2 = iPath2.addTrailingSeparator();
                }
                iPathArray[n3] = iPath2;
                ++n3;
            }
            return iPathArray;
        }
        return null;
    }

    private class ExclusionPatternAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private ExclusionPatternAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            ExclusionInclusionEntryDialog.this.doStatusLineUpdate();
        }

        public void changeControlPressed(DialogField dialogField) {
            ExclusionInclusionEntryDialog.this.doChangeControlPressed();
        }
    }
}

