/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPVariableElementLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JARFileSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;

public class NewVariableEntryDialog
extends StatusDialog {
    private final int IDX_EXTEND = 0;
    private ListDialogField fVariablesList;
    private boolean fCanExtend;
    private boolean fIsValidSelection;
    private IPath[] fResultPaths;
    private SelectionButtonDialogField fConfigButton;
    private CLabel fWarning;

    public NewVariableEntryDialog(Shell shell) {
        super(shell);
        this.setTitle(NewWizardMessages.NewVariableEntryDialog_title);
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
        this.updateStatus(new StatusInfo(4, ""));
        String[] stringArray = new String[]{NewWizardMessages.NewVariableEntryDialog_vars_extend};
        VariablesAdapter variablesAdapter = new VariablesAdapter();
        CPVariableElementLabelProvider cPVariableElementLabelProvider = new CPVariableElementLabelProvider(false);
        this.fVariablesList = new ListDialogField(variablesAdapter, stringArray, (ILabelProvider)cPVariableElementLabelProvider);
        this.fVariablesList.setDialogFieldListener(variablesAdapter);
        this.fVariablesList.setLabelText(NewWizardMessages.NewVariableEntryDialog_vars_label);
        this.fVariablesList.enableButton(0, false);
        this.fVariablesList.setViewerComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof CPVariableElement && object2 instanceof CPVariableElement) {
                    return this.getComparator().compare(((CPVariableElement)object).getName(), ((CPVariableElement)object2).getName());
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.fConfigButton = new SelectionButtonDialogField(8);
        this.fConfigButton.setLabelText(NewWizardMessages.NewVariableEntryDialog_configbutton_label);
        this.fConfigButton.setDialogFieldListener(variablesAdapter);
        this.initializeElements();
        this.fCanExtend = false;
        this.fIsValidSelection = false;
        this.fResultPaths = null;
        this.fVariablesList.selectFirstElement();
    }

    private void initializeElements() {
        String[] stringArray = JavaCore.getClasspathVariableNames();
        ArrayList<CPVariableElement> arrayList = new ArrayList<CPVariableElement>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            IPath iPath = JavaCore.getClasspathVariable((String)string);
            if (iPath != null) {
                arrayList.add(new CPVariableElement(string, iPath));
            }
            ++n;
        }
        this.fVariablesList.setElements(arrayList);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.new_variable_dialog_context");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection(((Object)((Object)this)).getClass().getName());
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        this.fVariablesList.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fVariablesList.getLabelControl(null), 2);
        GridData gridData = (GridData)this.fVariablesList.getListControl(null).getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        gridData.widthHint = this.convertWidthInCharsToPixels(70);
        this.fWarning = new CLabel(composite2, 0);
        this.fWarning.setLayoutData((Object)new GridData(4, 128, true, false, this.fVariablesList.getNumberOfControls() - 1, 1));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(256));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.fConfigButton.doFillIntoGrid(composite3, 1);
        NewVariableEntryDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public IPath[] getResult() {
        return this.fResultPaths;
    }

    private void doDoubleClick() {
        if (this.fIsValidSelection) {
            this.okPressed();
        } else if (this.fCanExtend) {
            this.extendButtonPressed();
        }
    }

    private void doSelectionChanged() {
        boolean bl = true;
        boolean bl2 = false;
        StatusInfo statusInfo = new StatusInfo();
        List list = this.fVariablesList.getSelectedElements();
        int n = list.size();
        if (n > 0) {
            this.fResultPaths = new Path[n];
            int n2 = 0;
            while (n2 < n) {
                CPVariableElement cPVariableElement = (CPVariableElement)list.get(n2);
                this.fResultPaths[n2] = new Path(cPVariableElement.getName());
                File file = cPVariableElement.getPath().toFile();
                if (!file.exists()) {
                    statusInfo.setError(NewWizardMessages.NewVariableEntryDialog_info_notexists);
                    bl = false;
                    break;
                }
                if (file.isDirectory()) {
                    statusInfo.setError(NewWizardMessages.NewVariableEntryDialog_info_isfolder);
                    bl2 = true;
                    bl = false;
                    break;
                }
                ++n2;
            }
        } else {
            bl = false;
            statusInfo.setInfo(NewWizardMessages.NewVariableEntryDialog_info_noselection);
        }
        if (bl && n > 1) {
            String string = Messages.format(NewWizardMessages.NewVariableEntryDialog_info_selected, String.valueOf(n));
            statusInfo.setInfo(string);
        }
        this.fCanExtend = n == 1 && bl2;
        this.fVariablesList.enableButton(0, this.fCanExtend);
        this.updateStatus(statusInfo);
        this.fIsValidSelection = bl;
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(bl);
        }
        this.updateDeprecationWarning();
    }

    private void updateDeprecationWarning() {
        if (this.fWarning == null || this.fWarning.isDisposed()) {
            return;
        }
        Iterator iterator = this.fVariablesList.getSelectedElements().iterator();
        while (iterator.hasNext()) {
            CPVariableElement cPVariableElement = (CPVariableElement)iterator.next();
            String string = cPVariableElement.getDeprecationMessage();
            if (string == null) continue;
            this.fWarning.setText(string);
            this.fWarning.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            return;
        }
        this.fWarning.setText(null);
        this.fWarning.setImage(null);
    }

    private IPath[] chooseExtensions(CPVariableElement cPVariableElement) {
        File file = cPVariableElement.getPath().toFile();
        JARFileSelectionDialog jARFileSelectionDialog = new JARFileSelectionDialog(this.getShell(), true, false);
        jARFileSelectionDialog.setTitle(NewWizardMessages.NewVariableEntryDialog_ExtensionDialog_title);
        jARFileSelectionDialog.setMessage(Messages.format(NewWizardMessages.NewVariableEntryDialog_ExtensionDialog_description, cPVariableElement.getName()));
        jARFileSelectionDialog.setInput(file);
        if (jARFileSelectionDialog.open() == 0) {
            Object[] objectArray = jARFileSelectionDialog.getResult();
            IPath[] iPathArray = new IPath[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                IPath iPath = Path.fromOSString((String)((File)objectArray[n]).getPath());
                Path path = new Path(cPVariableElement.getName());
                int n2 = cPVariableElement.getPath().segmentCount();
                while (n2 < iPath.segmentCount()) {
                    path = path.append(iPath.segment(n2));
                    ++n2;
                }
                iPathArray[n] = path;
                ++n;
            }
            return iPathArray;
        }
        return null;
    }

    protected final void extendButtonPressed() {
        IPath[] iPathArray;
        List list = this.fVariablesList.getSelectedElements();
        if (list.size() == 1 && (iPathArray = this.chooseExtensions((CPVariableElement)list.get(0))) != null) {
            this.fResultPaths = iPathArray;
            super.buttonPressed(0);
        }
    }

    protected final void configButtonPressed() {
        Object object;
        String string = "org.eclipse.wst.jsdt.ui.preferences.ClasspathVariablesPreferencePage";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = this.fVariablesList.getSelectedElements();
        if (!list.isEmpty()) {
            object = ((CPVariableElement)list.get(0)).getName();
            hashMap.put("ClasspathVariablesPreferencePage.select_var", (String)object);
        }
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)string, (String[])new String[]{string}, hashMap).open();
        object = this.fVariablesList.getElements();
        this.initializeElements();
        List list2 = this.fVariablesList.getElements();
        list2.removeAll((Collection<?>)object);
        if (!list2.isEmpty()) {
            this.fVariablesList.selectElements((ISelection)new StructuredSelection(list2));
        } else if (this.fVariablesList.getSelectedElements().isEmpty()) {
            this.fVariablesList.selectFirstElement();
        }
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            switch (n) {
                case 0: {
                    NewVariableEntryDialog.this.extendButtonPressed();
                }
            }
        }

        public void selectionChanged(ListDialogField listDialogField) {
            NewVariableEntryDialog.this.doSelectionChanged();
        }

        public void doubleClicked(ListDialogField listDialogField) {
            NewVariableEntryDialog.this.doDoubleClick();
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == NewVariableEntryDialog.this.fConfigButton) {
                NewVariableEntryDialog.this.configButtonPressed();
            }
        }
    }
}

