/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;

public class StringButtonStatusDialogField
extends StringButtonDialogField {
    private Label fStatusLabelControl;
    private Object fStatus = null;
    private String fWidthHintString = null;
    private int fWidthHint = -1;

    public StringButtonStatusDialogField(IStringButtonAdapter iStringButtonAdapter) {
        super(iStringButtonAdapter);
    }

    public void setStatus(String string) {
        if (this.isOkToUse((Control)this.fStatusLabelControl)) {
            this.fStatusLabelControl.setText(string);
        }
        this.fStatus = string;
    }

    public void setStatus(Image image) {
        if (this.isOkToUse((Control)this.fStatusLabelControl)) {
            if (image == null) {
                this.fStatusLabelControl.setImage(null);
            } else {
                this.fStatusLabelControl.setImage(image);
            }
        }
        this.fStatus = image;
    }

    public void setStatusWidthHint(String string) {
        this.fWidthHintString = string;
        this.fWidthHint = -1;
    }

    public void setStatusWidthHint(int n) {
        this.fWidthHint = n;
        this.fWidthHintString = null;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)StringButtonStatusDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)StringButtonStatusDialogField.gridDataForText(n - 3));
        Label label2 = this.getStatusLabelControl(composite);
        label2.setLayoutData((Object)this.gridDataForStatusLabel((Control)composite, 1));
        Button button = this.getChangeControl(composite);
        button.setLayoutData((Object)StringButtonStatusDialogField.gridDataForButton(button, 1));
        return new Control[]{label, text, label2, button};
    }

    public int getNumberOfControls() {
        return 4;
    }

    protected GridData gridDataForStatusLabel(Control control, int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalIndent = 0;
        if (this.fWidthHintString != null) {
            GC gC = new GC((Drawable)control);
            gC.setFont(JFaceResources.getDialogFont());
            gridData.widthHint = gC.textExtent((String)this.fWidthHintString).x;
            gC.dispose();
        } else {
            gridData.widthHint = this.fWidthHint != -1 ? this.fWidthHint : -1;
        }
        return gridData;
    }

    public Label getStatusLabelControl(Composite composite) {
        if (this.fStatusLabelControl == null) {
            this.assertCompositeNotNull(composite);
            this.fStatusLabelControl = new Label(composite, 16384);
            this.fStatusLabelControl.setFont(composite.getFont());
            this.fStatusLabelControl.setEnabled(this.isEnabled());
            if (this.fStatus instanceof Image) {
                this.fStatusLabelControl.setImage((Image)this.fStatus);
            } else if (this.fStatus instanceof String) {
                this.fStatusLabelControl.setText((String)this.fStatus);
            }
        }
        return this.fStatusLabelControl;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fStatusLabelControl)) {
            this.fStatusLabelControl.setEnabled(this.isEnabled());
        }
    }

    public void refresh() {
        super.refresh();
        if (this.fStatus instanceof String) {
            this.setStatus((String)this.fStatus);
        } else {
            this.setStatus((Image)this.fStatus);
        }
    }
}

