/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;

public class JavaElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int SYNCHRONIZED = 4;
    public static final int STATIC = 8;
    public static final int RUNNABLE = 16;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int OVERRIDES = 128;
    public static final int IMPLEMENTS = 256;
    public static final int CONSTRUCTOR = 512;
    public static final int DEPRECATED = 1024;
    public static final int VOLATILE = 2048;
    public static final int TRANSIENT = 4096;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;
    static /* synthetic */ Class class$0;

    public JavaElementImageDescriptor(ImageDescriptor imageDescriptor, int n, Point point) {
        this.fBaseImage = imageDescriptor;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = n;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = point;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fFlags = n;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point point) {
        Assert.isNotNull((Object)point);
        Assert.isTrue((point.x >= 0 && point.y >= 0 ? 1 : 0) != 0);
        this.fSize = point;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        block8: {
            block7: {
                if (object == null) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass())) break block8;
            }
            return false;
        }
        JavaElementImageDescriptor javaElementImageDescriptor = (JavaElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(javaElementImageDescriptor.fBaseImage) && this.fFlags == javaElementImageDescriptor.fFlags && this.fSize.equals((Object)javaElementImageDescriptor.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.getImageData(this.fBaseImage);
        if ((this.fFlags & 0x400) != 0) {
            Point point = this.getSize();
            ImageData imageData2 = this.getImageData(JavaPluginImages.DESC_OVR_DEPRECATED);
            this.drawImage(imageData2, 0, point.y - imageData2.height);
        }
        this.drawImage(imageData, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor imageDescriptor) {
        ImageData imageData = imageDescriptor.getImageData();
        if (imageData == null) {
            imageData = DEFAULT_IMAGE_DATA;
            JavaPlugin.logErrorMessage("Image data not available: " + imageDescriptor.toString());
        }
        return imageData;
    }

    private void addTopRightImage(ImageDescriptor imageDescriptor, Point point) {
        ImageData imageData = this.getImageData(imageDescriptor);
        int n = point.x - imageData.width;
        if (n >= 0) {
            this.drawImage(imageData, n, point.y);
            point.x = n;
        }
    }

    private void addBottomRightImage(ImageDescriptor imageDescriptor, Point point) {
        ImageData imageData = this.getImageData(imageDescriptor);
        int n = point.x - imageData.width;
        int n2 = point.y - imageData.height;
        if (n >= 0 && n2 >= 0) {
            this.drawImage(imageData, n, n2);
            point.x = n;
        }
    }

    private void addBottomLeftImage(ImageDescriptor imageDescriptor, Point point) {
        ImageData imageData = this.getImageData(imageDescriptor);
        int n = point.x;
        int n2 = point.y - imageData.height;
        if (n + imageData.width < this.getSize().x && n2 >= 0) {
            this.drawImage(imageData, n, n2);
            point.x = n + imageData.width;
        }
    }

    private void drawTopRight() {
        Point point = new Point(this.getSize().x, 0);
        if ((this.fFlags & 1) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_ABSTRACT, point);
        }
        if ((this.fFlags & 0x200) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_CONSTRUCTOR, point);
        }
        if ((this.fFlags & 2) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_FINAL, point);
        }
        if ((this.fFlags & 0x800) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_VOLATILE, point);
        }
        if ((this.fFlags & 8) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_STATIC, point);
        }
    }

    private void drawBottomRight() {
        Point point = this.getSize();
        Point point2 = new Point(point.x, point.y);
        int n = this.fFlags;
        int n2 = 132;
        int n3 = 260;
        if ((n & n2) == n2) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_SYNCH_AND_OVERRIDES, point2);
            n &= ~n2;
        } else if ((n & n3) == n3) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_SYNCH_AND_IMPLEMENTS, point2);
            n &= ~n3;
        }
        if ((n & 0x80) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_OVERRIDES, point2);
        }
        if ((n & 0x100) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_IMPLEMENTS, point2);
        }
        if ((n & 4) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_SYNCH, point2);
        }
        if ((n & 0x10) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_RUN, point2);
        }
        if ((n & 0x1000) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_TRANSIENT, point2);
        }
    }

    private void drawBottomLeft() {
        Point point = new Point(0, this.getSize().y);
        if ((this.fFlags & 0x40) != 0) {
            this.addBottomLeftImage(JavaPluginImages.DESC_OVR_ERROR, point);
        }
        if ((this.fFlags & 0x20) != 0) {
            this.addBottomLeftImage(JavaPluginImages.DESC_OVR_WARNING, point);
        }
    }
}

