/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;

public class JavadocContentAccess {
    private JavadocContentAccess() {
    }

    public static Reader getContentReader(IMember iMember, boolean bl) throws JavaModelException {
        JavaDocCommentReader javaDocCommentReader;
        IBuffer iBuffer = iMember.getOpenable().getBuffer();
        if (iBuffer == null) {
            return null;
        }
        ISourceRange iSourceRange = iMember.getJavadocRange();
        if (iSourceRange != null && !JavadocContentAccess.containsOnlyInheritDoc((Reader)((Object)(javaDocCommentReader = new JavaDocCommentReader(iBuffer, iSourceRange.getOffset(), iSourceRange.getOffset() + iSourceRange.getLength() - 1))), iSourceRange.getLength())) {
            javaDocCommentReader.reset();
            return javaDocCommentReader;
        }
        if (bl && iMember.getElementType() == 9) {
            return JavadocContentAccess.findDocInHierarchy((IMethod)iMember);
        }
        return null;
    }

    private static boolean containsOnlyInheritDoc(Reader reader, int n) {
        char[] cArray = new char[n];
        try {
            reader.read(cArray, 0, n);
        }
        catch (IOException iOException) {
            return false;
        }
        return new String(cArray).trim().equals("{@inheritDoc}");
    }

    public static Reader getHTMLContentReader(IMember iMember, boolean bl, boolean bl2) throws JavaModelException {
        String string;
        Reader reader = JavadocContentAccess.getContentReader(iMember, bl);
        if (reader != null) {
            return new JavaDoc2HTMLTextReader(reader);
        }
        if (bl2 && iMember.getOpenable().getBuffer() == null && (string = iMember.getAttachedJavadoc(null)) != null) {
            return new StringReader(string);
        }
        return null;
    }

    public static Reader getHTMLContentReader(IMember iMember, boolean bl) throws JavaModelException {
        return JavadocContentAccess.getHTMLContentReader(iMember, bl, false);
    }

    private static Reader findDocInHierarchy(IMethod iMethod) throws JavaModelException {
        IType iType = iMethod.getDeclaringType();
        if (iType == null) {
            return null;
        }
        ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
        MethodOverrideTester methodOverrideTester = new MethodOverrideTester(iType, iTypeHierarchy);
        IType[] iTypeArray = iTypeHierarchy.getAllSupertypes(iType);
        int n = 0;
        while (n < iTypeArray.length) {
            Reader reader;
            IType iType2 = iTypeArray[n];
            IMethod iMethod2 = methodOverrideTester.findOverriddenMethodInType(iType2, iMethod);
            if (iMethod2 != null && (reader = JavadocContentAccess.getContentReader((IMember)iMethod2, false)) != null) {
                return reader;
            }
            ++n;
        }
        return null;
    }
}

