/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ChangeTypeAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ChangeTypeAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public ChangeTypeAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.ChangeTypeAction_label);
        this.setToolTipText(RefactoringMessages.ChangeTypeAction_tooltipText);
        this.setDescription(RefactoringMessages.ChangeTypeAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.change_type_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isGeneralizeTypeAvailable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            IMember iMember = ChangeTypeAction.getMember(iStructuredSelection);
            if (iMember == null || !ActionUtil.isEditable(this.getShell(), (IJavaElement)iMember)) {
                return;
            }
            ISourceRange iSourceRange = iMember.getNameRange();
            RefactoringExecutionStarter.startChangeTypeRefactoring(iMember.getCompilationUnit(), this.getShell(), iSourceRange.getOffset(), iSourceRange.getLength());
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.ChangeTypeAction_dialog_title, RefactoringMessages.ChangeTypeAction_exception);
        }
    }

    private static IMember getMember(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IMember)) {
            return null;
        }
        if (object instanceof IMethod) {
            IMethod iMethod = (IMethod)object;
            String string = iMethod.getReturnType();
            if (PrimitiveType.toCode((String)Signature.toString((String)string)) != null) {
                return null;
            }
            return iMethod;
        }
        if (object instanceof IField && !JdtFlags.isEnum((IMember)object)) {
            return (IField)object;
        }
        return null;
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isGeneralizeTypeAvailable(javaTextSelection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        try {
            RefactoringExecutionStarter.startChangeTypeRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), this.getShell(), iTextSelection.getOffset(), iTextSelection.getLength());
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.ChangeTypeAction_dialog_title, RefactoringMessages.ChangeTypeAction_exception);
        }
    }
}

