/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.code.ExtractMethodWizard;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ExtractMethodAction
extends SelectionDispatchAction {
    private final JavaEditor fEditor;

    public ExtractMethodAction(JavaEditor javaEditor) {
        super((IWorkbenchSite)javaEditor.getEditorSite());
        this.setText(RefactoringMessages.ExtractMethodAction_label);
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.extract_method_action");
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(iTextSelection.getLength() == 0 ? false : this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        this.setEnabled(RefactoringAvailabilityTester.isExtractMethodAvailable(javaTextSelection));
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        try {
            ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), iTextSelection.getOffset(), iTextSelection.getLength());
            new RefactoringStarter().activate(extractMethodRefactoring, new ExtractMethodWizard(extractMethodRefactoring), this.getShell(), RefactoringMessages.ExtractMethodAction_dialog_title, 5);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.ExtractMethodAction_dialog_title, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }
}

