/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public abstract class FindAction
extends SelectionDispatchAction {
    private static final IJavaElement RETURN_WITHOUT_BEEP = JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    private Class[] fValidTypes = this.getValidTypes();
    private JavaEditor fEditor;
    static /* synthetic */ Class class$0;

    FindAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.init();
    }

    FindAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    abstract void init();

    abstract Class[] getValidTypes();

    private boolean canOperateOn(IStructuredSelection iStructuredSelection) {
        return iStructuredSelection != null && !iStructuredSelection.isEmpty() && this.canOperateOn(this.getJavaElement(iStructuredSelection, true));
    }

    boolean canOperateOn(IJavaElement iJavaElement) {
        if (iJavaElement == null || this.fValidTypes == null || this.fValidTypes.length == 0 || !ActionUtil.isOnBuildPath(iJavaElement)) {
            return false;
        }
        int n = 0;
        while (n < this.fValidTypes.length) {
            if (this.fValidTypes[n].isInstance(iJavaElement)) {
                if (iJavaElement.getElementType() == 4) {
                    return this.hasChildren((IPackageFragment)iJavaElement);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasChildren(IPackageFragment iPackageFragment) {
        try {
            return iPackageFragment.hasChildren();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private IJavaElement getTypeIfPossible(IJavaElement iJavaElement, boolean bl) {
        switch (iJavaElement.getElementType()) {
            case 5: {
                if (bl) {
                    return iJavaElement;
                }
                return this.findType((ICompilationUnit)iJavaElement, bl);
            }
            case 6: {
                return ((IClassFile)iJavaElement).getType();
            }
        }
        return iJavaElement;
    }

    IJavaElement getJavaElement(IStructuredSelection iStructuredSelection, boolean bl) {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            IJavaElement iJavaElement = null;
            if (object instanceof IJavaElement) {
                iJavaElement = (IJavaElement)object;
            } else if (object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz);
            }
            if (iJavaElement != null) {
                return this.getTypeIfPossible(iJavaElement, bl);
            }
        }
        return null;
    }

    private void showOperationUnavailableDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)SearchMessages.JavaElementAction_operationUnavailable_title, (String)this.getOperationUnavailableMessage());
    }

    String getOperationUnavailableMessage() {
        return SearchMessages.JavaElementAction_operationUnavailable_generic;
    }

    private IJavaElement findType(ICompilationUnit iCompilationUnit, boolean bl) {
        Object[] objectArray = null;
        try {
            objectArray = iCompilationUnit.getAllTypes();
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                ExceptionHandler.log(javaModelException, SearchMessages.JavaElementAction_error_open_message);
            }
            if (bl) {
                return RETURN_WITHOUT_BEEP;
            }
            return null;
        }
        if (objectArray.length == 1 || bl && objectArray.length > 0) {
            return objectArray[0];
        }
        if (bl) {
            return RETURN_WITHOUT_BEEP;
        }
        if (objectArray.length == 0) {
            return null;
        }
        String string = SearchMessages.JavaElementAction_typeSelectionDialog_title;
        String string2 = SearchMessages.JavaElementAction_typeSelectionDialog_message;
        int n = JavaElementLabelProvider.SHOW_DEFAULT;
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(n));
        elementListSelectionDialog.setTitle(string);
        elementListSelectionDialog.setMessage(string2);
        elementListSelectionDialog.setElements(objectArray);
        if (elementListSelectionDialog.open() == 0) {
            return (IType)elementListSelectionDialog.getFirstResult();
        }
        return RETURN_WITHOUT_BEEP;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IJavaElement iJavaElement = this.getJavaElement(iStructuredSelection, false);
        if (iJavaElement == null || !iJavaElement.exists()) {
            this.showOperationUnavailableDialog();
            return;
        }
        if (iJavaElement == RETURN_WITHOUT_BEEP) {
            return;
        }
        this.run(iJavaElement);
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        try {
            String string = SearchMessages.SearchElementSelectionDialog_title;
            String string2 = SearchMessages.SearchElementSelectionDialog_message;
            IJavaElement[] iJavaElementArray = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (iJavaElementArray.length > 0 && this.canOperateOn(iJavaElementArray[0])) {
                IJavaElement iJavaElement = iJavaElementArray[0];
                if (iJavaElementArray.length > 1) {
                    iJavaElement = SelectionConverter.selectJavaElement(iJavaElementArray, this.getShell(), string, string2);
                }
                if (iJavaElement != null) {
                    this.run(iJavaElement);
                }
            } else {
                this.showOperationUnavailableDialog();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = SearchMessages.Search_Error_search_title;
            String string3 = SearchMessages.Search_Error_codeResolve;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string3);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.canOperateOn(iStructuredSelection));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void run(IJavaElement iJavaElement) {
        if (!ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
            return;
        }
        try {
            this.performNewSearch(iJavaElement);
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), SearchMessages.Search_Error_search_notsuccessful_title, SearchMessages.Search_Error_search_notsuccessful_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void performNewSearch(IJavaElement iJavaElement) throws JavaModelException, InterruptedException {
        JavaSearchQuery javaSearchQuery = new JavaSearchQuery(this.createQuery(iJavaElement));
        if (javaSearchQuery.canRunInBackground()) {
            SearchUtil.runQueryInBackground(javaSearchQuery);
        } else {
            IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
            IStatus iStatus = SearchUtil.runQueryInForeground((IRunnableContext)iProgressService, javaSearchQuery);
            if (iStatus.matches(7)) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.Search_Error_search_title, (String)SearchMessages.Search_Error_search_message, (IStatus)iStatus);
            }
        }
    }

    QuerySpecification createQuery(IJavaElement iJavaElement) throws JavaModelException, InterruptedException {
        JavaSearchScopeFactory javaSearchScopeFactory = JavaSearchScopeFactory.getInstance();
        IJavaSearchScope iJavaSearchScope = javaSearchScopeFactory.createWorkspaceScope(true);
        String string = javaSearchScopeFactory.getWorkspaceScopeDescription(true);
        return new ElementQuerySpecification(iJavaElement, this.getLimitTo(), iJavaSearchScope, string);
    }

    abstract int getLimitTo();

    IType getType(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        IType iType = null;
        if (iJavaElement.getElementType() == 7) {
            iType = (IType)iJavaElement;
        } else if (iJavaElement instanceof IMember) {
            iType = ((IMember)iJavaElement).getDeclaringType();
        } else if (iJavaElement instanceof ILocalVariable) {
            iType = (IType)iJavaElement.getAncestor(7);
        }
        return iType;
    }

    JavaEditor getEditor() {
        return this.fEditor;
    }
}

