/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindImplementorsAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindImplementorsInWorkingSetAction
extends FindImplementorsAction {
    private IWorkingSet[] fWorkingSets;

    public FindImplementorsInWorkingSetAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
    }

    public FindImplementorsInWorkingSetAction(IWorkbenchSite iWorkbenchSite, IWorkingSet[] iWorkingSetArray) {
        this(iWorkbenchSite);
        this.fWorkingSets = iWorkingSetArray;
    }

    public FindImplementorsInWorkingSetAction(JavaEditor javaEditor) {
        super(javaEditor);
    }

    public FindImplementorsInWorkingSetAction(JavaEditor javaEditor, IWorkingSet[] iWorkingSetArray) {
        this(javaEditor);
        this.fWorkingSets = iWorkingSetArray;
    }

    void init() {
        this.setText(SearchMessages.Search_FindImplementorsInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindImplementorsInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_implementors_in_working_set_action");
    }

    QuerySpecification createQuery(IJavaElement iJavaElement) throws JavaModelException, InterruptedException {
        JavaSearchScopeFactory javaSearchScopeFactory = JavaSearchScopeFactory.getInstance();
        IWorkingSet[] iWorkingSetArray = this.fWorkingSets;
        if (this.fWorkingSets == null && (iWorkingSetArray = javaSearchScopeFactory.queryWorkingSets()) == null) {
            return super.createQuery(iJavaElement);
        }
        SearchUtil.updateLRUWorkingSets(iWorkingSetArray);
        IJavaSearchScope iJavaSearchScope = javaSearchScopeFactory.createJavaSearchScope(iWorkingSetArray, true);
        String string = javaSearchScopeFactory.getWorkingSetScopeDescription(iWorkingSetArray, true);
        return new ElementQuerySpecification(iJavaElement, this.getLimitTo(), iJavaSearchScope, string);
    }
}

