/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    static /* synthetic */ Class class$0;

    public OpenAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_action");
    }

    public OpenAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false) != null);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ISourceReference || e instanceof IFile || JavaModelUtil.isOpenableStorage(e)) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection iTextSelection) {
        if (!this.isProcessable()) {
            return;
        }
        try {
            IJavaElement[] iJavaElementArray = SelectionConverter.codeResolveForked(this.fEditor, false);
            if (iJavaElementArray == null || iJavaElementArray.length == 0) {
                IEditorStatusLine iEditorStatusLine;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iEditorStatusLine = (IEditorStatusLine)this.fEditor.getAdapter(clazz)) != null) {
                    iEditorStatusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
                }
                this.getShell().getDisplay().beep();
                return;
            }
            IJavaElement iJavaElement = iJavaElementArray[0];
            if (iJavaElementArray.length > 1 && (iJavaElement = SelectionConverter.selectJavaElement(iJavaElementArray, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element)) == null) {
                return;
            }
            int n = iJavaElement.getElementType();
            if (n == 2 || n == 3 || n == 4) {
                iJavaElement = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
            }
            this.run(new Object[]{iJavaElement});
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isProcessable() {
        IJavaElement iJavaElement;
        if (this.fEditor != null && (iJavaElement = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false)) instanceof ICompilationUnit && !JavaModelUtil.isPrimary((ICompilationUnit)iJavaElement)) {
            return true;
        }
        return ActionUtil.isProcessable(this.fEditor);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (!this.checkEnabled(iStructuredSelection)) {
            return;
        }
        this.run(iStructuredSelection.toArray());
    }

    public void run(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, ActionMessages.OpenAction_multistatus_message, null);
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            Object object2 = objectArray[n];
            try {
                object2 = this.getElementToOpen(object2);
                boolean bl = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                object = EditorUtility.openInEditor(object2, bl);
                if (object != null && object2 instanceof IJavaElement) {
                    JavaUI.revealInEditor(object, (IJavaElement)object2);
                }
            }
            catch (PartInitException partInitException) {
                object = Messages.format(ActionMessages.OpenAction_error_problem_opening_editor, new String[]{new JavaUILabelProvider().getText(object2), partInitException.getStatus().getMessage()});
                multiStatus.add((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, (String)object, null));
            }
            catch (CoreException coreException) {
                object = Messages.format(ActionMessages.OpenAction_error_problem_opening_editor, new String[]{new JavaUILabelProvider().getText(object2), coreException.getStatus().getMessage()});
                multiStatus.add((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, (String)object, null));
                JavaPlugin.log(coreException);
            }
            ++n;
        }
        if (!multiStatus.isOK()) {
            IStatus[] iStatusArray = multiStatus.getChildren();
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenAction_error_message, (IStatus)(iStatusArray.length == 1 ? iStatusArray[0] : multiStatus));
        }
    }

    public Object getElementToOpen(Object object) throws JavaModelException {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }
}

