/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindAction;
import org.eclipse.wst.jsdt.ui.actions.FindReferencesAction;
import org.eclipse.wst.jsdt.ui.actions.FindReferencesInHierarchyAction;
import org.eclipse.wst.jsdt.ui.actions.FindReferencesInProjectAction;
import org.eclipse.wst.jsdt.ui.actions.FindReferencesInWorkingSetAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.actions.WorkingSetFindAction;

public class ReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_references;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindReferencesAction fFindReferencesAction;
    private FindReferencesInProjectAction fFindReferencesInProjectAction;
    private FindReferencesInHierarchyAction fFindReferencesInHierarchyAction;
    private FindReferencesInWorkingSetAction fFindReferencesInWorkingSetAction;

    public ReferencesSearchGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        this.fGroupId = "group.search";
        this.fFindReferencesAction = new FindReferencesAction(iWorkbenchSite);
        this.fFindReferencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.references.in.workspace");
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(iWorkbenchSite);
        this.fFindReferencesInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.references.in.project");
        this.fFindReferencesInHierarchyAction = new FindReferencesInHierarchyAction(iWorkbenchSite);
        this.fFindReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.references.in.hierarchy");
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(iWorkbenchSite);
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.references.in.working.set");
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.registerAction(this.fFindReferencesAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindReferencesInProjectAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindReferencesInHierarchyAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindReferencesInWorkingSetAction, iSelectionProvider, iSelection);
    }

    public ReferencesSearchGroup(JavaEditor javaEditor) {
        Assert.isNotNull((Object)javaEditor);
        this.fEditor = javaEditor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindReferencesAction = new FindReferencesAction(javaEditor);
        this.fFindReferencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.references.in.workspace");
        this.fEditor.setAction("SearchReferencesInWorkspace", (IAction)this.fFindReferencesAction);
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(this.fEditor);
        this.fFindReferencesInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.references.in.project");
        this.fEditor.setAction("SearchReferencesInProject", (IAction)this.fFindReferencesInProjectAction);
        this.fFindReferencesInHierarchyAction = new FindReferencesInHierarchyAction(this.fEditor);
        this.fFindReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.references.in.hierarchy");
        this.fEditor.setAction("SearchReferencesInHierarchy", (IAction)this.fFindReferencesInHierarchyAction);
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(this.fEditor);
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.references.in.working.set");
        this.fEditor.setAction("SearchReferencesInWorkingSet", (IAction)this.fFindReferencesInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        selectionDispatchAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
    }

    protected String getName() {
        return MENU_TEXT;
    }

    public void fillActionBars(IActionBars iActionBars) {
        Assert.isNotNull((Object)iActionBars);
        super.fillActionBars(iActionBars);
        this.fActionBars = iActionBars;
        this.updateGlobalActionHandlers();
    }

    private void addAction(IAction iAction, IMenuManager iMenuManager) {
        if (iAction.isEnabled()) {
            iMenuManager.add(iAction);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] iWorkingSetArray, IMenuManager iMenuManager) {
        WorkingSetFindAction workingSetFindAction = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindReferencesInWorkingSetAction(this.fEditor, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindReferencesInWorkingSetAction(this.fSite, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray));
        workingSetFindAction.update(this.getContext().getSelection());
        this.addAction((IAction)workingSetFindAction, iMenuManager);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(this.getName(), "group.search");
        this.addAction((IAction)this.fFindReferencesAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindReferencesInProjectAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindReferencesInHierarchyAction, (IMenuManager)menuManager);
        menuManager.add((IContributionItem)new Separator());
        Iterator iterator = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iterator.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iterator.next(), (IMenuManager)menuManager);
        }
        this.addAction((IAction)this.fFindReferencesInWorkingSetAction, (IMenuManager)menuManager);
        if (!menuManager.isEmpty()) {
            iMenuManager.appendToGroup(this.fGroupId, (IContributionItem)menuManager);
        }
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.disposeAction(this.fFindReferencesAction, iSelectionProvider);
            this.disposeAction(this.fFindReferencesInProjectAction, iSelectionProvider);
            this.disposeAction(this.fFindReferencesInHierarchyAction, iSelectionProvider);
            this.disposeAction(this.fFindReferencesInWorkingSetAction, iSelectionProvider);
        }
        this.fFindReferencesAction = null;
        this.fFindReferencesInProjectAction = null;
        this.fFindReferencesInHierarchyAction = null;
        this.fFindReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ReferencesInWorkspace", (IAction)this.fFindReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ReferencesInProject", (IAction)this.fFindReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ReferencesInHierarchy", (IAction)this.fFindReferencesInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ReferencesInWorkingSet", (IAction)this.fFindReferencesInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        if (iSelectionChangedListener != null) {
            iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }
}

