/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.ui.actions.ShowInPackageViewAction;

public class ShowActionGroup
extends ActionGroup {
    private boolean fIsPackageExplorer;
    private IWorkbenchSite fSite;
    private ShowInPackageViewAction fShowInPackagesViewAction;

    public ShowActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public ShowActionGroup(IViewPart iViewPart) {
        this((IWorkbenchSite)iViewPart.getSite());
        this.fIsPackageExplorer = iViewPart instanceof PackageExplorerPart;
    }

    public ShowActionGroup(JavaEditor javaEditor) {
        this.fShowInPackagesViewAction = new ShowInPackageViewAction(javaEditor);
        this.fShowInPackagesViewAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.show.in.package.view");
        javaEditor.setAction("ShowInPackageView", (IAction)this.fShowInPackagesViewAction);
        this.initialize((IWorkbenchSite)javaEditor.getSite(), true);
    }

    private ShowActionGroup(IWorkbenchSite iWorkbenchSite) {
        this.fShowInPackagesViewAction = new ShowInPackageViewAction(iWorkbenchSite);
        this.fShowInPackagesViewAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.show.in.package.view");
        this.initialize(iWorkbenchSite, false);
    }

    private void initialize(IWorkbenchSite iWorkbenchSite, boolean bl) {
        this.fSite = iWorkbenchSite;
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fShowInPackagesViewAction.update(iSelection);
        if (!bl) {
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fShowInPackagesViewAction);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        if (!this.fIsPackageExplorer) {
            this.appendToGroup(iMenuManager, (IAction)this.fShowInPackagesViewAction);
        }
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fShowInPackagesViewAction);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        if (!this.fIsPackageExplorer) {
            iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ShowInPackagesView", (IAction)this.fShowInPackagesViewAction);
        }
    }

    private void appendToGroup(IMenuManager iMenuManager, IAction iAction) {
        if (iAction.isEnabled()) {
            iMenuManager.appendToGroup("group.show", iAction);
        }
    }
}

