/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameEnumConstProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameJavaProjectProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameSourceFolderProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameTypeParameterProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameRefactoringWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameSelectionState;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameUserInterfaceStarter;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_JAVADOC_COMMENTS = 2;
    public static final int UPDATE_REGULAR_COMMENTS = 4;
    public static final int UPDATE_STRING_LITERALS = 8;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getEntryMatchingSeverity(4).toStatus();
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    public void openDialog(Shell shell) throws CoreException {
        this.openDialog(shell, false);
    }

    public boolean openDialog(Shell shell, boolean bl) throws CoreException {
        UserInterfaceStarter userInterfaceStarter;
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(shell, this.fPreCheckStatus);
            return false;
        }
        if (!bl) {
            userInterfaceStarter = RenameUserInterfaceManager.getDefault().getStarter((Refactoring)this.fRefactoring);
        } else {
            userInterfaceStarter = new RenameUserInterfaceStarter();
            RenameRefactoringWizard renameRefactoringWizard = new RenameRefactoringWizard((Refactoring)this.fRefactoring, this.fRefactoring.getName(), null, null, null){

                protected void addUserInputPages() {
                }
            };
            renameRefactoringWizard.setForcePreviewReview(bl);
            userInterfaceStarter.initialize(renameRefactoringWizard);
        }
        return userInterfaceStarter.activate((Refactoring)this.fRefactoring, shell, this.getJavaRenameProcessor().getSaveMode());
    }

    public void perform(Shell shell, IRunnableContext iRunnableContext) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(shell, this.fPreCheckStatus);
                return;
            }
            RenameSelectionState renameSelectionState = this.createSelectionState();
            RefactoringExecutionHelper refactoringExecutionHelper = new RefactoringExecutionHelper((Refactoring)this.fRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), this.getJavaRenameProcessor().getSaveMode(), shell, iRunnableContext);
            refactoringExecutionHelper.perform(true, true);
            this.restoreSelectionState(renameSelectionState);
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
    }

    private RenameSupport(RenameJavaElementDescriptor renameJavaElementDescriptor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fRefactoring = (RenameRefactoring)renameJavaElementDescriptor.createRefactoring(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            this.fPreCheckStatus = refactoringStatus;
        } else {
            this.preCheck();
            refactoringStatus.merge(this.fPreCheckStatus);
            this.fPreCheckStatus = refactoringStatus;
        }
    }

    public static RenameSupport create(RenameJavaElementDescriptor renameJavaElementDescriptor) throws CoreException {
        return new RenameSupport(renameJavaElementDescriptor);
    }

    private RenameSupport(JavaRenameProcessor javaRenameProcessor, String string, int n) throws CoreException {
        this.fRefactoring = new JavaRenameRefactoring(javaRenameProcessor);
        RenameSupport.initialize(this.fRefactoring, string, n);
    }

    private JavaRenameProcessor getJavaRenameProcessor() {
        return (JavaRenameProcessor)this.fRefactoring.getProcessor();
    }

    public static RenameSupport create(IJavaProject iJavaProject, String string, int n) throws CoreException {
        RenameJavaProjectProcessor renameJavaProjectProcessor = new RenameJavaProjectProcessor(iJavaProject);
        return new RenameSupport(renameJavaProjectProcessor, string, n);
    }

    public static RenameSupport create(IPackageFragmentRoot iPackageFragmentRoot, String string) throws CoreException {
        RenameSourceFolderProcessor renameSourceFolderProcessor = new RenameSourceFolderProcessor(iPackageFragmentRoot);
        return new RenameSupport(renameSourceFolderProcessor, string, 0);
    }

    public static RenameSupport create(IPackageFragment iPackageFragment, String string, int n) throws CoreException {
        RenamePackageProcessor renamePackageProcessor = new RenamePackageProcessor(iPackageFragment);
        return new RenameSupport(renamePackageProcessor, string, n);
    }

    public static RenameSupport create(ICompilationUnit iCompilationUnit, String string, int n) throws CoreException {
        RenameCompilationUnitProcessor renameCompilationUnitProcessor = new RenameCompilationUnitProcessor(iCompilationUnit);
        return new RenameSupport(renameCompilationUnitProcessor, string, n);
    }

    public static RenameSupport create(IType iType, String string, int n) throws CoreException {
        RenameTypeProcessor renameTypeProcessor = new RenameTypeProcessor(iType);
        return new RenameSupport(renameTypeProcessor, string, n);
    }

    public static RenameSupport create(IMethod iMethod, String string, int n) throws CoreException {
        RenameMethodProcessor renameMethodProcessor = MethodChecks.isVirtual(iMethod) ? new RenameVirtualMethodProcessor(iMethod) : new RenameNonVirtualMethodProcessor(iMethod);
        return new RenameSupport(renameMethodProcessor, string, n);
    }

    public static RenameSupport create(IField iField, String string, int n) throws CoreException {
        if (JdtFlags.isEnum((IMember)iField)) {
            return new RenameSupport(new RenameEnumConstProcessor(iField), string, n);
        }
        RenameFieldProcessor renameFieldProcessor = new RenameFieldProcessor(iField);
        renameFieldProcessor.setRenameGetter(RenameSupport.updateGetterMethod(n));
        renameFieldProcessor.setRenameSetter(RenameSupport.updateSetterMethod(n));
        return new RenameSupport(renameFieldProcessor, string, n);
    }

    public static RenameSupport create(ITypeParameter iTypeParameter, String string, int n) throws CoreException {
        RenameTypeParameterProcessor renameTypeParameterProcessor = new RenameTypeParameterProcessor(iTypeParameter);
        renameTypeParameterProcessor.setUpdateReferences(RenameSupport.updateReferences(n));
        return new RenameSupport(renameTypeParameterProcessor, string, n);
    }

    public static RenameSupport create(ILocalVariable iLocalVariable, String string, int n) throws CoreException {
        RenameLocalVariableProcessor renameLocalVariableProcessor = new RenameLocalVariableProcessor(iLocalVariable);
        renameLocalVariableProcessor.setUpdateReferences(RenameSupport.updateReferences(n));
        return new RenameSupport(renameLocalVariableProcessor, string, n);
    }

    private static void initialize(RenameRefactoring renameRefactoring, String string, int n) {
        ITextUpdating iTextUpdating;
        Class<?> clazz;
        IReferenceUpdating iReferenceUpdating;
        if (renameRefactoring.getProcessor() == null) {
            return;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RenameSupport.setNewName((INameUpdating)renameRefactoring.getAdapter((Class)clazz2), string);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iReferenceUpdating = (IReferenceUpdating)renameRefactoring.getAdapter((Class)clazz3)) != null) {
            iReferenceUpdating.setUpdateReferences(RenameSupport.updateReferences(n));
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iTextUpdating = (ITextUpdating)renameRefactoring.getAdapter((Class)clazz)) != null) {
            iTextUpdating.setUpdateTextualMatches(RenameSupport.updateTextualMatches(n));
        }
    }

    private static void setNewName(INameUpdating iNameUpdating, String string) {
        if (string != null) {
            iNameUpdating.setNewElementName(string);
        }
    }

    private static boolean updateReferences(int n) {
        return (n & 1) != 0;
    }

    private static boolean updateTextualMatches(int n) {
        int n2 = 76;
        return (n & n2) != 0;
    }

    private static boolean updateGetterMethod(int n) {
        return (n & 0x10) != 0;
    }

    private static boolean updateSetterMethod(int n) {
        return (n & 0x20) != 0;
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)JavaUIMessages.RenameSupport_not_available) : new RefactoringStatus();
        }
    }

    private void showInformation(Shell shell, RefactoringStatus refactoringStatus) {
        String string = refactoringStatus.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)shell, (String)JavaUIMessages.RenameSupport_dialog_title, (String)string);
    }

    private RenameSelectionState createSelectionState() {
        RenameProcessor renameProcessor;
        Object[] objectArray;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ltk.core.refactoring.participants.RenameProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RenameSelectionState renameSelectionState = (objectArray = (renameProcessor = (RenameProcessor)this.fRefactoring.getAdapter((Class)clazz)).getElements()).length == 1 ? new RenameSelectionState(objectArray[0]) : null;
        return renameSelectionState;
    }

    private void restoreSelectionState(RenameSelectionState renameSelectionState) throws CoreException {
        Object object;
        INameUpdating iNameUpdating;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iNameUpdating = (INameUpdating)this.fRefactoring.getAdapter((Class)clazz)) != null && renameSelectionState != null && (object = iNameUpdating.getNewElement()) != null) {
            renameSelectionState.restore(object);
        }
    }
}

