/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.wst.jsdt.internal.ui.text.JavaColorManager;
import org.eclipse.wst.jsdt.internal.ui.text.JavaCommentScanner;
import org.eclipse.wst.jsdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCodeScanner;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDocScanner;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

public class JavaTextTools {
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character"};
    private JavaColorManager fColorManager;
    private JavaCodeScanner fCodeScanner;
    private JavaCommentScanner fMultilineCommentScanner;
    private JavaCommentScanner fSinglelineCommentScanner;
    private SingleTokenJavaScanner fStringScanner;
    private JavaDocScanner fJavaDocScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();

    public JavaTextTools(IPreferenceStore iPreferenceStore) {
        this(iPreferenceStore, null, true);
    }

    public JavaTextTools(IPreferenceStore iPreferenceStore, boolean bl) {
        this(iPreferenceStore, null, bl);
    }

    public JavaTextTools(IPreferenceStore iPreferenceStore, Preferences preferences) {
        this(iPreferenceStore, preferences, true);
    }

    public JavaTextTools(IPreferenceStore iPreferenceStore, Preferences preferences, boolean bl) {
        this.fPreferenceStore = iPreferenceStore;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = preferences;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
        this.fColorManager = new JavaColorManager(bl);
        this.fCodeScanner = new JavaCodeScanner(this.fColorManager, iPreferenceStore);
        this.fMultilineCommentScanner = new JavaCommentScanner((IColorManager)this.fColorManager, iPreferenceStore, preferences, "java_multi_line_comment");
        this.fSinglelineCommentScanner = new JavaCommentScanner((IColorManager)this.fColorManager, iPreferenceStore, preferences, "java_single_line_comment");
        this.fStringScanner = new SingleTokenJavaScanner(this.fColorManager, iPreferenceStore, "java_string");
        this.fJavaDocScanner = new JavaDocScanner((IColorManager)this.fColorManager, iPreferenceStore, preferences);
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fStringScanner = null;
        this.fJavaDocScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public RuleBasedScanner getJavaDocScanner() {
        return this.fJavaDocScanner;
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return new FastJavaPartitionScanner();
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        return new FastPartitioner(this.getPartitionScanner(), LEGAL_CONTENT_TYPES);
    }

    public String[] getPartitionManagingPositionCategories() {
        return new String[]{"__content_types_category"};
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return this.fCodeScanner.affectsBehavior(propertyChangeEvent) || this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fStringScanner.affectsBehavior(propertyChangeEvent) || this.fJavaDocScanner.affectsBehavior(propertyChangeEvent);
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fCodeScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fStringScanner.affectsBehavior(propertyChangeEvent)) {
            this.fStringScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fJavaDocScanner.affectsBehavior(propertyChangeEvent)) {
            this.fJavaDocScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    public void setupJavaDocumentPartitioner(IDocument iDocument) {
        this.setupJavaDocumentPartitioner(iDocument, "__dftl_partitioning");
    }

    public void setupJavaDocumentPartitioner(IDocument iDocument, String string) {
        IDocumentPartitioner iDocumentPartitioner = this.createDocumentPartitioner();
        if (iDocument instanceof IDocumentExtension3) {
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            iDocumentExtension3.setDocumentPartitioner(string, iDocumentPartitioner);
        } else {
            iDocument.setDocumentPartitioner(iDocumentPartitioner);
        }
        iDocumentPartitioner.connect(iDocument);
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    protected Preferences getCorePreferenceStore() {
        return this.fCorePreferenceStore;
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JavaTextTools.this.adaptToPreferenceChange(propertyChangeEvent);
        }

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            JavaTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
        }
    }
}

