/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java;

import java.util.Iterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class NodeHelper {
    protected static final char DOUBLE_QUOTE_CHAR = '\"';
    protected static final String DOUBLE_QUOTE_ENTITY = "&quot;";
    protected static final char SINGLE_QUOTE_CHAR = '\'';
    protected static final String SINGLE_QUOTE_ENTITY = "&#039;";
    protected final IStructuredDocumentRegion region;

    public static boolean isInArray(String[] stringArray, String string) {
        if (stringArray == null || string == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string.trim())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int n = string.length() - 1;
        char c = string.charAt(0);
        char c2 = string.charAt(n);
        return c == '\'' && c2 == '\'' || c == '\"' && c2 == '\"';
    }

    public NodeHelper(IStructuredDocumentRegion iStructuredDocumentRegion) {
        this.region = iStructuredDocumentRegion;
    }

    public boolean attrEquals(String string, String string2) {
        String string3 = this.getAttributeValue(string);
        if (string3 == null) {
            return false;
        }
        return string3.equalsIgnoreCase(string2);
    }

    public String AttrToString() {
        if (this.region == null) {
            return null;
        }
        ITextRegionList iTextRegionList = this.region.getRegions();
        Iterator iterator = iTextRegionList.iterator();
        String string = "Tag name:" + this.getTagName() + "\tAttribute\tValue\n";
        while (iterator.hasNext()) {
            ITextRegion iTextRegion = (ITextRegion)iterator.next();
            if (iTextRegion.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int n = iTextRegion.getStart();
            int n2 = iTextRegion.getTextEnd();
            string = String.valueOf(string) + "\t\t" + this.region.getText().substring(n, n2);
            if (iterator.hasNext()) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                iTextRegion = (ITextRegion)iterator.next();
            }
            System.out.println("attrib type");
            if (iTextRegion.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            int n3 = iTextRegion.getStart();
            int n4 = iTextRegion.getTextEnd();
            string = String.valueOf(string) + "\t\t" + this.stripEndQuotes(this.region.getText().substring(n3, n4)) + "\n";
        }
        return string;
    }

    public boolean containsAttribute(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        if (this.region == null) {
            return false;
        }
        ITextRegionList iTextRegionList = this.region.getRegions();
        Iterator iterator = iTextRegionList.iterator();
        while (iterator.hasNext()) {
            ITextRegion iTextRegion = (ITextRegion)iterator.next();
            if (iTextRegion.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int n = iTextRegion.getStart();
            int n2 = iTextRegion.getTextEnd();
            String string = this.region.getText().substring(n, n2).trim();
            if (!NodeHelper.isInArray(stringArray, string)) continue;
            return true;
        }
        return false;
    }

    public String getAttributeValue(String string) {
        if (this.region == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        ITextRegionList iTextRegionList = this.region.getRegions();
        Iterator iterator = iTextRegionList.iterator();
        while (iterator.hasNext()) {
            ITextRegion iTextRegion = (ITextRegion)iterator.next();
            if (iTextRegion.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int n = iTextRegion.getStart();
            int n2 = iTextRegion.getTextEnd();
            String string2 = this.region.getText().substring(n, n2).trim();
            if (!string2.equalsIgnoreCase(string)) continue;
            if (iterator.hasNext()) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                iTextRegion = (ITextRegion)iterator.next();
            }
            if (iTextRegion.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            int n3 = iTextRegion.getStart();
            int n4 = iTextRegion.getTextEnd();
            return this.stripEndQuotes(this.region.getText().substring(n3, n4));
        }
        return null;
    }

    public String getElementAsFlatString() {
        if (this.region == null) {
            return null;
        }
        String string = this.region.getFullText();
        if (string == null) {
            return null;
        }
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }

    public String getTagName() {
        if (this.region == null) {
            return null;
        }
        ITextRegionList iTextRegionList = this.region.getRegions();
        Iterator iterator = iTextRegionList.iterator();
        while (iterator.hasNext()) {
            ITextRegion iTextRegion = (ITextRegion)iterator.next();
            if (iTextRegion.getType() != "XML_TAG_NAME") continue;
            int n = iTextRegion.getStart();
            int n2 = iTextRegion.getTextEnd();
            return this.region.getText().substring(n, n2);
        }
        return null;
    }

    public boolean isEndTag() {
        if (this.region == null) {
            return false;
        }
        ITextRegionList iTextRegionList = this.region.getRegions();
        Iterator iterator = iTextRegionList.iterator();
        while (iterator.hasNext()) {
            ITextRegion iTextRegion = (ITextRegion)iterator.next();
            if (iTextRegion.getType() != "XML_END_TAG_OPEN") continue;
            return true;
        }
        return false;
    }

    public boolean isSelfClosingTag() {
        if (this.region == null) {
            return false;
        }
        if (this.region == null) {
            return false;
        }
        ITextRegionList iTextRegionList = this.region.getRegions();
        ITextRegion iTextRegion = iTextRegionList.get(iTextRegionList.size() - 1);
        return iTextRegion.getType() == "XML_EMPTY_TAG_CLOSE";
    }

    public boolean nameEquals(String string) {
        if (this.region == null) {
            return false;
        }
        String string2 = this.getTagName();
        return string2 != null && string2.equalsIgnoreCase(string);
    }

    public String stripEndQuotes(String string) {
        if (string == null) {
            return null;
        }
        if (NodeHelper.isQuoted(string)) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public String toString() {
        ITextRegionList iTextRegionList = this.region.getRegions();
        Iterator iterator = iTextRegionList.iterator();
        String string = new String();
        while (iterator.hasNext()) {
            ITextRegion iTextRegion = (ITextRegion)iterator.next();
            String string2 = iTextRegion.getType();
            string = String.valueOf(string) + "\tNode Type:" + string2 + " \t\tValue:" + this.region.getText().substring(iTextRegion.getStart(), iTextRegion.getTextEnd()) + "\n";
        }
        return string;
    }
}

