/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java.search;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.JsCorePlugin;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.internal.java.search.IndexWorkspaceJob;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;

public class JsIndexManager {
    static final boolean DEBUG;
    private static JsIndexManager fSingleton;
    static long fTotalTime;
    private static final String PKEY_INDEX_STATE = "jspIndexState";
    public static final int S_CANCELED = 4;
    public static final int S_REBUILDING = 3;
    public static final int S_STABLE = 1;
    public static final int S_UPDATING = 2;
    private IContentType fContentTypeJSP = null;
    private JSPResourceVisitor fVisitor = null;
    private IndexWorkspaceJob indexingJob = new IndexWorkspaceJob();
    private IndexJobCoordinator indexJobCoordinator;
    private boolean initialized;
    private boolean initializing = true;
    private IResourceChangeListener jspResourceChangeListener;
    private final String OSGI_FRAMEWORK_ID = "org.eclipse.osgi";
    private ProcessFilesJob processFilesJob = new ProcessFilesJob(JsCoreMessages.JSPIndexManager_0);

    static {
        fSingleton = null;
        fTotalTime = 0L;
        String string = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspindexmanager");
        DEBUG = string != null && string.equalsIgnoreCase("true");
    }

    public static synchronized JsIndexManager getInstance() {
        if (fSingleton == null) {
            fSingleton = new JsIndexManager();
        }
        return fSingleton;
    }

    private JsIndexManager() {
        this.processFilesJob.setSystem(true);
        this.processFilesJob.setPriority(30);
        this.processFilesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                super.done(iJobChangeEvent);
                JsIndexManager.this.setStableState();
            }
        });
    }

    boolean frameworkIsShuttingDown() {
        boolean bl;
        boolean bl2 = bl = Platform.getBundle((String)"org.eclipse.osgi").getState() == 16;
        if (DEBUG && bl) {
            System.out.println("JSPIndexManager: system is shutting down!");
        }
        return bl;
    }

    IndexWorkspaceJob getIndexingJob() {
        return this.indexingJob;
    }

    int getIndexState() {
        return JsCorePlugin.getDefault().getPluginPreferences().getInt(PKEY_INDEX_STATE);
    }

    ProcessFilesJob getProcessFilesJob() {
        return this.processFilesJob;
    }

    JSPResourceVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new JSPResourceVisitor();
        }
        return this.fVisitor;
    }

    final void indexFiles(IFile[] iFileArray) {
        this.processFilesJob.process(iFileArray);
    }

    public void initialize() {
        JsIndexManager jsIndexManager = JsIndexManager.getInstance();
        if (!jsIndexManager.initialized) {
            jsIndexManager.initialized = true;
            jsIndexManager.indexJobCoordinator = new IndexJobCoordinator();
            jsIndexManager.jspResourceChangeListener = new JSPResourceChangeListener();
            Platform.getJobManager().addJobChangeListener((IJobChangeListener)jsIndexManager.indexJobCoordinator);
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.jspResourceChangeListener, 1);
            this.saveIndexes();
            this.rebuildIndexIfNeeded();
            jsIndexManager.initializing = false;
        }
    }

    boolean isInitializing() {
        return this.initializing;
    }

    void rebuildIndex() {
        if (DEBUG) {
            System.out.println("*** JSP Index unstable, requesting re-indexing");
        }
        this.getIndexingJob().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
                super.aboutToRun(iJobChangeEvent);
                JsIndexManager.this.setRebuildingState();
            }

            public void done(IJobChangeEvent iJobChangeEvent) {
                super.done(iJobChangeEvent);
                JsIndexManager.this.setStableState();
                JsIndexManager.this.getIndexingJob().removeJobChangeListener((IJobChangeListener)this);
            }
        });
        this.getProcessFilesJob().clearFiles();
        this.getIndexingJob().schedule();
    }

    synchronized void rebuildIndexIfNeeded() {
        if (this.getIndexState() != 1) {
            this.rebuildIndex();
        }
    }

    void saveIndexes() {
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            block6: {
                if (JsWebNature.hasNature(iProjectArray[n]) && iProjectArray[n].isOpen()) {
                    IPath iPath = JsSearchSupport.getInstance().getModelJspPluginWorkingLocation(iProjectArray[n]);
                    File file = new File(iPath.toOSString());
                    String[] stringArray = file.list();
                    String string = "";
                    try {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            if (stringArray[n2].toLowerCase().endsWith(".index")) {
                                string = String.valueOf(iPath.toString()) + "/" + stringArray[n2];
                                indexManager.getIndex(iProjectArray[n].getFullPath(), (IPath)new Path(string), true, false);
                            }
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block6;
                        exception.printStackTrace();
                    }
                }
            }
            ++n;
        }
    }

    void setCanceledState() {
        this.setIndexState(4);
    }

    synchronized void setIndexState(int n) {
        if (DEBUG) {
            System.out.println("JSPIndexManager setting index state to: " + this.state2String(n));
        }
        JsCorePlugin jsCorePlugin = JsCorePlugin.getDefault();
        jsCorePlugin.getPluginPreferences().setValue(PKEY_INDEX_STATE, n);
        jsCorePlugin.savePluginPreferences();
    }

    void setRebuildingState() {
        this.setIndexState(3);
    }

    void setStableState() {
        this.setIndexState(1);
    }

    void setUpdatingState() {
        this.setIndexState(2);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.jspResourceChangeListener);
        JsSearchSupport.getInstance().setCanceled(true);
        Platform.getJobManager().removeJobChangeListener((IJobChangeListener)this.indexJobCoordinator);
        int n = 5000;
        if (this.processFilesJob != null) {
            this.processFilesJob.cancel();
        }
        this.waitTillNotRunning(n, this.processFilesJob);
        if (this.indexingJob != null) {
            this.indexingJob.cancel();
        }
        this.waitTillNotRunning(n, this.processFilesJob);
    }

    private String state2String(int n) {
        String string = "UNKNOWN";
        switch (n) {
            case 1: {
                string = "S_STABLE";
                break;
            }
            case 2: {
                string = "S_UPDATING";
                break;
            }
            case 4: {
                string = "S_CANCELED";
                break;
            }
            case 3: {
                string = "S_REBUILDING";
            }
        }
        return string;
    }

    private void waitTillNotRunning(int n, Job job) {
        int n2 = 10;
        int n3 = n / n2;
        int n4 = 0;
        while (n4++ < n3 && job.getState() == 4) {
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                Logger.logException(interruptedException);
            }
        }
    }

    private class IndexJobCoordinator
    extends JobChangeAdapter {
        private IndexJobCoordinator() {
        }

        public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
            Job job = iJobChangeEvent.getJob();
            if (this.isJobToAvoid(job)) {
                JsIndexManager.this.getProcessFilesJob().cancel();
            }
        }

        public void done(IJobChangeEvent iJobChangeEvent) {
            Job job = iJobChangeEvent.getJob();
            if (this.isJobToAvoid(job) && JsIndexManager.this.getProcessFilesJob().getFiles().length > 0) {
                JsIndexManager.this.getProcessFilesJob().schedule(500L);
            }
        }

        private boolean isJobToAvoid(Job job) {
            boolean bl = false;
            if (job.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) || job.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD) || job.belongsTo(ResourcesPlugin.FAMILY_AUTO_REFRESH)) {
                bl = true;
            }
            return bl;
        }
    }

    private class JSPResourceChangeListener
    implements IResourceChangeListener {
        private JSPResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            block10: {
                if (JsIndexManager.this.isInitializing()) {
                    return;
                }
                if (JsIndexManager.this.getIndexState() == 3) {
                    return;
                }
                if (JsIndexManager.this.getIndexState() == 4) {
                    JsIndexManager.this.getProcessFilesJob().schedule(500L);
                    return;
                }
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta != null) {
                    boolean bl;
                    int n = iResourceDelta.getKind();
                    boolean bl2 = (n & 1) == 1;
                    boolean bl3 = bl = (n & 4) == 4;
                    if ((bl2 || bl) && iResourceDelta.getFullPath().toString().equals("/")) {
                        try {
                            JSPResourceVisitor jSPResourceVisitor = JsIndexManager.this.getVisitor();
                            jSPResourceVisitor.reset();
                            iResourceDelta.accept((IResourceDeltaVisitor)jSPResourceVisitor, false);
                            IFile[] iFileArray = jSPResourceVisitor.getFiles();
                            if (iFileArray.length > 0) {
                                JsIndexManager.this.setUpdatingState();
                                JsIndexManager.this.indexFiles(iFileArray);
                            }
                        }
                        catch (CoreException coreException) {
                            if (DEBUG) {
                                Logger.logException(coreException);
                            }
                        }
                        catch (Exception exception) {
                            if (!DEBUG) break block10;
                            Logger.logException(exception);
                        }
                    }
                }
            }
        }
    }

    private class JSPResourceVisitor
    implements IResourceDeltaVisitor {
        private HashMap jspFiles = new HashMap();

        private void deleteIndex(IFile iFile) {
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            IPath iPath = iFile.getFullPath();
            IPath iPath2 = JsSearchSupport.getInstance().computeIndexLocation(iPath);
            indexManager.removeIndex(iPath2);
            File file = iPath2.toFile();
            file.delete();
        }

        public IFile[] getFiles() {
            return this.jspFiles.values().toArray(new IFile[this.jspFiles.size()]);
        }

        private boolean isHiddenResource(IPath iPath) {
            String[] stringArray = iPath.segments();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith(".")) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void reset() {
            this.jspFiles.clear();
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            block8: {
                if (JsSearchSupport.getInstance().isCanceled() || JsIndexManager.this.frameworkIsShuttingDown()) {
                    JsIndexManager.this.setCanceledState();
                    return false;
                }
                try {
                    if (!this.isHiddenResource(iResourceDelta.getFullPath())) {
                        int n;
                        int n2 = iResourceDelta.getKind();
                        boolean bl = (n2 & 1) == 1;
                        boolean bl2 = false;
                        if ((n2 & 4) == 4) {
                            n = iResourceDelta.getFlags();
                            bl2 = (n & 0x100) == 256 || (n & 0x40000) == 262144;
                        }
                        int n3 = n = (n2 & 2) == 2 ? 1 : 0;
                        if (bl || bl2) {
                            this.visitAdded(iResourceDelta);
                        } else if (n != 0) {
                            this.visitRemoved(iResourceDelta);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!DEBUG) break block8;
                    Logger.logException("Delta analysis may not be complete", exception);
                }
            }
            return true;
        }

        private void visitAdded(IResourceDelta iResourceDelta) {
            IResource iResource;
            int n = iResourceDelta.getFullPath().segmentCount();
            String string = iResourceDelta.getFullPath().segment(n - 1);
            if (Util.isJsType(string) && (iResource = iResourceDelta.getResource()) != null && iResource.exists() && iResource.getType() == 1) {
                this.jspFiles.put(iResource.getFullPath(), iResource);
            }
        }

        private void visitRemoved(IResourceDelta iResourceDelta) {
            IResource iResource;
            if (iResourceDelta.getResource() != null && (iResource = iResourceDelta.getResource()).getType() == 2 && iResource.exists()) {
                this.deleteIndex((IFile)iResource);
            }
        }
    }

    private class ProcessFilesJob
    extends Job {
        List fileList = new ArrayList();
        int lastFileCursor = 0;

        ProcessFilesJob(String string) {
            super(string);
        }

        synchronized void clearFiles() {
            this.fileList.clear();
            this.lastFileCursor = 0;
        }

        synchronized IFile[] getFiles() {
            return this.fileList.toArray(new IFile[this.fileList.size()]);
        }

        private boolean isCanceled(IProgressMonitor iProgressMonitor) {
            boolean bl = false;
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                bl = true;
            } else if (JsSearchSupport.getInstance().isCanceled()) {
                bl = true;
                if (iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                }
            }
            return bl;
        }

        synchronized void process(IFile[] iFileArray) {
            int n = 0;
            while (n < iFileArray.length) {
                this.fileList.add(iFileArray[n]);
                ++n;
            }
            if (DEBUG) {
                System.out.println("JSPIndexManager queuing " + iFileArray.length + " files");
            }
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 375->378)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

